
/**@file main.h
@brief Header file containing functions prototypes,defines and global variables.
@author William J Smith
@date May 2016
*/

#include "mbed.h"
#include "N5110.h"
#define DIRECTION_TOLERANCE 0.45// change this to alter tolerance of joystick direction

DigitalIn button(PTB11);/**@namespace Joy Stick Button Digital in*/
DigitalOut LED(PTC2);/**@namespace LED Digital output from mbed pin*/
AnalogIn xPot(PTB2);/**@namespace Joystick potentiometer connection*/
AnalogIn yPot(PTB3);/**@namespace Joystick potentiometer connection*/
Ticker pollJoystick;/**@namespace timer to regularly read the joystick*/
// Serial for debug
Serial serial(USBTX,USBRX);// Serial for debug

// create enumerated type (0,1,2,3 etc. for direction)
// could be extended for diagonals etc.
enum DirectionName {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    CENTRE,
    UNKNOWN
};
typedef struct JoyStick Joystick;// struct for Joystick
struct JoyStick {
    float x;    /** current x value*/
    float x0;   /** 'centred' x value*/
    float y;    /** current y value*/
    float y0;   /** 'centred' y value*/
    int button; /** button state (assume pull-down used, so 1 = pressed, 0 = unpressed)*/
    DirectionName direction;  /** current direction*/
};
Joystick joystick;/** create struct variable*/
int printFlag = 0;

/**@namespace        VCC,    SCE,    RST,    D/C,    MOSI,   SCLK,   LED*/
N5110 lcd( PTE26,     PTA0,   PTC4,   PTD0,   PTD2,   PTD1,   PTC3);
DigitalIn buttonA(PTB18);/**@namespace Digital input for button on PCB*/
int ni = 84; /*!<variable for matrixs of N5110*/
int x = 0;/*!<x Value of snake head */
int x1 = 0;/*!< x Value of snake Body including x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 x13 x14 x15 x16 x17 x18 x19 x20 x21 x22 x23 x24*/
int x2 = 0;
int x3 = 0;
int x4 = 0;
int x5 = 0;
int x6 = 0;
int x7 = 0;
int x8 = 0;
int x9 = 0;
int x10 = 0;
int x11 = 0;
int x12 = 0;
int x13 = 0;
int x14 = 0;
int x15 = 0;
int x16 = 0;
int x17 = 0;
int x18 = 0;
int x19 = 0;
int x20 = 0;
int x21 = 0;
int x22 = 0;
int x23 = 0;
int x24 = 0;
int y = 0;/*!< y Value of snake Head*/
int y1 = 1;/*!< y Value of snake Body including y2 y3 y4 y5 y6 y7 y8 y9 y10 y11 y12 y13 y14 y15 y16 y17 y18 y19 y20 y21 y22 y23 y24*/
int y2 = 2;
int y3 = 3;
int y4 = 4;
int y5 = 5;
int y6 = 6;
int y7 = 7;
int y8 = 8;
int y9 = 9;
int y10 = 10;
int y11 = 11;
int y12 = 12;
int y13 = 13;
int y14 = 14;
int y15 = 15;
int y16 = 16;
int y17 = 17;
int y18 = 18;
int y19 = 19;
int y20 = 20;
int y21 = 21;
int y22 = 22;
int y23 = 23;
int y24 = 24;
int change = 1;/*!< function to change the direction the snakes head is travelling*/
int n[84][48];/*!< Array for nokia 5110 screen*/
int array[48][84];/*!< Array for nokia 5110 screen for snake to travel in*/
int nj = 48;/*!< Variable for checkerboard function*/
int cells[84][48];/*!< Variable for checkerboard function*/
int Score = 0;/*!< Variable for the score that changed everytime food is eaten by the snake*/
int randX;/*!< x Variable that is randomly selected within the array to generate food in a random space*/
int randY;/*!< y Variable that is randomly selected within the array to generate food in a random space*/
char str[64];/*!< Character that enables you to print the score number on the screen */
int pause=0; /*!< Variable for pause function*/

void Menu();   /*!< Void for Menu function*/
void Welcomescreen(); /*!< Void for Welcome screen function which appears when device turned on*/
void clearCells();  /*!< Void to switch all pixels on the screen to OFF */
void checkerBoard(); /*!< Void to Make checker baord effect over */
void DrawArray(); /*!<Sets the pixel depending on whether 0 or higher than 1*/
void ClearArray();/*!<Checks over each individual pixel and if its 0 it will clear*/
void GenerateFood();/*!<Generates food at random places*/
void MakeSnake(); /*!<sets the pixels for the snake*/
void SnakeGame(); /*!<Game Rules*/
void MoveSnake(); /*!<moving the snake using the joy stick*/
void calibrateJoystick();/*!void to calibrate the joystick*/
void updateJoystick();/*!<Updates joystick within set amount of time*/
void SnakeGrowing();/*!<Function to make snake grow when it eats the food*/
void EndGame();/*!<Functions ends game when Snake hits itself or the wall*/
void calibrateJoystick();/*!void to calibrate the joystick*/
void updateJoystick();/*!void to calibrate the joystick*/
void GameOver();/*!void that runs Game over screen and enables user to go back to the beginning*/
void Winner();/*!void to show WINNER screen and enables user to go back to the beginning*/