
/**@file main.cpp
@brief C plus plus file containing functions prototypes,defines and global variables.
@author William J Smith
@date May 2016
*/

#include "main.h"

int main()
{
    buttonA.mode(PullDown);//set to pull down mode to enable use of button on PCB
    calibrateJoystick();  // get centred values of joystick
    pollJoystick.attach(&updateJoystick,1.0/10.0);  // read joystick 10 times per second
    calibrateJoystick();//calibrate joystick prior to game beginning 
    updateJoystick();//update joystick to reduce bugs
    lcd.init();//enables screen 
    Welcomescreen();//shows welcoming message when starting up 
    lcd.clear();//clears screen 

    GenerateFood();//Randomly generates food at the beginning of the game 
    DrawArray();//draws food array 
    Menu();//enables user to press start
    while(1) {

        MakeSnake();//creates inital SNAKE
        ClearArray();//clears all pixels accept food and snake 
        DrawArray();//draws pixels for food and snake 

    }
}
//menu screen show a mesdsage telling the user to press the button on the PCB in order to start the game
void Menu()
{
    // first need to initialise display

    lcd.clear();
    lcd.printString("Press Button",6,1);
    lcd.printString("To",35,3);
    lcd.printString("START",27,5);
    wait(0.3);

    while(1) {
        if (buttonA==1) {  // whenm the button is pressed a checkerboard effect is created and the game will start 
            lcd.clear();
            checkerBoard();
            wait(0.5);
            lcd.clear();


            while(1) {

                wait(0.005);
                SnakeGame(); //Snake rules implemented 

                if (buttonA==1) {
                    pause=0;
                    Menu();
                }

                if (button==1) { //if at any time in the game the joystick button is pressed then the game will pause and show the score in the centre
                    pause=0;
                    lcd.clear();
                    sprintf(str,"%d",Score); //enables string number to be printed on the screen 
                    lcd.printString(str,37,2);
                    wait(1);
                }
            }
        }
    }
}
//void displays a welcome message "Welcome to Snake" when the device is turned on
void Welcomescreen()   // Display welcome screen
{
    lcd.printString("Welcome",20,1); // display Welcome
    wait(0.1);
    lcd.printString("To",35,3); // display To
    wait(0.1);
    lcd.printString("SNAKE",27,5);  // display Snake
    wait(1);
}
//Void produces checkerboard effect to make the game look like it is loading 
void checkerBoard()
{
//
    for (int i = 0; i < ni ; i+=2) {//checks array values and sets every other pixel as 1
        for (int j = 0; j < nj ; j+=2) {
            lcd.setPixel(i,j);
        }
    }
    lcd.refresh();
}
//void enables the pixels that are set within the make snake void and the generate food void to be set as 1
void DrawArray()
{
    for(int x=0; x<84; x++) { //checks all of the array[x][y], if any of them are named as the snake or food it will set pixel 
        for (int y=0; y<48; y++) {
            if(array[y][x]>=1) {
                lcd.setPixel(x,y);
            } else {
                lcd.clearPixel(x,y); //Clears any pixels that may of previously been set to 1 
            }
        }
    }
    lcd.refresh();
}
//void to make sure there are no left over pixels when void DrawArray is initalised 
void ClearArray()
{
    for(int x=0; x<84; x++) {//checks all of the array[x][y], if any of them are NOT named as the snake or food it will set pixel 
        for(int y=0; y<48; y++) {
            if (array[y][x]==0) {
                lcd.clearPixel(x,y);
            } else {
                lcd.setPixel(x,y);
            }
        }
    }
    lcd.refresh();
}
//void to calibrate joystick so that the readings taken by the mbed are correct
void calibrateJoystick()// read default positions of the joystick to calibrate later readings
{
    button.mode(PullDown);  // must not move during calibration
    joystick.x0 = xPot;  // initial positions in the range 0.0 to 1.0 (0.5 if centred exactly)
    joystick.y0 = yPot;
}
//void so that when calibration is completed updates any changes to its position 
void updateJoystick()
{
    joystick.x = xPot - joystick.x0;// read current joystick values relative to calibrated values (in range -0.5 to 0.5, 0.0 is centred)
    joystick.y = yPot - joystick.y0;// read button state
    joystick.button = button; // calculate direction depending on x,y values
    if ( fabs(joystick.y) < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) { // tolerance allows a little lee-way in case joystick not exactly in the stated direction
        joystick.direction = CENTRE;
    } else if ( joystick.y > DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = LEFT;
    } else if ( joystick.y < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = RIGHT;
    } else if ( joystick.x > DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = DOWN;
    } else if ( joystick.x < DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = UP;
    } else {
        joystick.direction = UNKNOWN;
    }
    printFlag = 1;// set flag for printing
}
//void to generate food from a random array that is created. this array is smaller so that the food is not direcvtly next to the wall on the screen 
void GenerateFood()
{
    randX = (rand() %80)+2; //make random number between 2-82
    randY = (rand() %43)+2; //make random number between 2 - 45 
    while(array[randY][randX]) {
        randX= (rand() %80)+2;
        randY= (rand() %44)+2;
    }
    array[randY][randX]= 5;
}
//Void to set the individual starting pixels of the snake and also shows the correct location of the pixels as the snake grows 
void MakeSnake()
{
    array[y+36][x+5]= 1;
    array[y1+36][x1+5]= 1;
    array[y2+36][x2+5]= 1;
    array[y3+36][x3+5]= 1;
    array[y4+36][x4+5]= 1;
    array[y5+36][x5+5]= 0;
    array[y6+36][x6+5]= 0;
    array[y7+36][x7+5]= 0;
    array[y8+36][x7+5]= 0;
    array[y9+36][x9+5]= 0;
    array[y10+36][x10+5]= 0;
    array[y11+36][x11+5]= 0;
    array[y12+36][x12+5]= 0;
    array[y13+36][x13+5]= 0;          //SETS POSITION OF SNAKE ORGINALLY 
    array[y14+36][x14+5]= 0;
    array[y15+36][x15+5]= 0;
    array[y16+36][x16+5]= 0;
    array[y17+36][x17+5]= 0;
    array[y18+36][x18+5]= 0;
    array[y19+36][x19+5]= 0;
    array[y20+36][x20+5]= 0;
    array[y21+36][x21+5]= 0;
    array[y22+36][x22+5]= 0;
    array[y23+36][x23+5]= 0;
    array[y24+36][x24+5]= 0;
}
//Void that actually runs throuhg the ruls of snake 
void SnakeGame()
{
    MakeSnake(); // SNAKES CREATED 
    ClearArray(); //CLEARS EVERYTHING BAR SNAKE AND FOOD 
    DrawArray();
    SnakeGrowing(); //SNAKE GROWS AS EATS FOOD 
    lcd.drawRect(0,0,83,46,0); //Draws a rectangle around the outside of the snake game in order to creat a WALL
    lcd.refresh();
    if(pause==0) {
        MoveSnake(); //SNAKES MOVES AROUND
        EndGame(); //When snake hits itself or wall it ENDS GAME 
        Winner(); //When maximum points are scored shows message saying YOU WINNN
    }
    if(y+36==randY && x+5==randX) {
        GenerateFood(); // When food is eaten create new food 
      

        Score= Score+10; //When food is eaten add 10 onto the score

    }
    if(y+36==randY && x+5==randX) { 
        LED=!LED; //switch on when food is eaten
    }


}
//void that enables snake to move from pixel to pixel whilst following the head 
void MoveSnake()
{
    array[y+36][x+5]= 0;

    array[y1+36][x1+5]= 0;

    array[y2+36][x2+5]= 0;

    array[y3+36][x3+5]= 0;

    array[y4+36][x4+5]= 0;

    array[y5+36][x5+5]= 0;

    array[y6+36][x6+5]= 0;

    array[y7+36][x7+5]= 0;

    array[y8+36][x8+5]= 0;

    array[y9+36][x9+5]= 0;

    array[y10+36][x10+5]= 0;

    array[y11+36][x11+5]= 0;         //DIFFERENT VALUES OF SNAKE BODY FOLLOWING THE SNAKE HEAD

    array[y12+36][x12+5]= 0;

    array[y13+36][x13+5]= 0;

    array[y14+36][x14+5]= 0;

    array[y15+36][x15+5]= 0;

    array[y16+36][x16+5]= 0;

    array[y17+36][x17+5]= 0;

    array[y18+36][x18+5]= 0;

    array[y19+36][x19+5]= 0;

    array[y20+36][x20+5]= 0;

    array[y21+36][x21+5]= 0;

    array[y22+36][x22+5]= 0;

    array[y23+36][x23+5]= 0;

    array[y24+36][x24+5]= 0;

    x24=x23;
    y24=y23;
    x23=x22;
    y23=y22;
    x22=x21;
    y22=y21;
    x21=x20;
    y21=y20;
    x20=x19;
    y20=y19;
    x19=x18;
    y19=y18;       //MAKES THE PIXELS FOLLOWING 
    x18=x17;
    y18=y17;
    x17=x16;
    y17=y16;
    x16=x15;
    y16=y15;
    x15=x14;
    y15=y14;
    x14=x13;
    y14=y13;
    x13=x12;
    y13=y12;
    x12=x11;
    y12=y11;
    x11=x10;  
    y11=y10;
    x10=x9;
    y10=y9;
    x9=x8;
    y9=y8;
    x8=x7;
    y8=y7;
    x7=x6;
    y7=y6;
    x6=x5;
    y6=y5;
    x5=x4;
    y5=y4;
    x4=x3;
    y4=y3;
    x3=x2;
    y3=y2;
    x2=x1;
    y2=y1;
    x1 = x;
    y1 = y;
    if (joystick.direction == CENTRE) { //when joystick is at the centre the snake stays the same

        wait(0.05);
    } else if (joystick.direction == UP) { //when joystick is in the up position it minus the y value from the array 

        wait(0.05);
        //y--;                           
        change = 1;

    } else if (joystick.direction == DOWN) {//when joystick is in the up position it adds the y value from the array
        wait(0.05);
        change = 2;
        //y++;
    } else if (joystick.direction == LEFT) {//when joystick is in the up position it minus the x value from the array

        wait(0.05);
        //x--;
        change = 3;
    } else if (joystick.direction == RIGHT) {//when joystick is in the up position it adds the x value from the array
        wait(0.05);
        //x++;
        change = 4;
    }
    if (change == 1) { //change one makes snake go up
        y--;

    } else if (change == 2) { //change 2 makes snake go down 
        y++;

    } else if (change == 3) { //change 3 makes snake go left
        x--;
    } else if (change == 4) { //change 4 makes snake go right
        x++;
    }

}//void makes snake grow depending on what the score is 
void SnakeGrowing()
{


    if(Score>=10) {
        array[y+36][x+5]= 1;

        array[y1+36][x1+5]= 1;

        array[y2+36][x2+5]= 1;  //Snake grows to this length when scores 10

        array[y3+36][x3+5]= 1;

        array[y4+36][x4+5]= 1;

        array[y5+36][x5+5]= 1;

        array[y6+36][x6+5]= 1;

    }


    if(Score>=20) {
        array[y+36][x+5]= 1;

        array[y1+36][x1+5]= 1;

        array[y2+36][x2+5]= 1;

        array[y3+36][x3+5]= 1;

        array[y4+36][x4+5]= 1; //Snake grows to this length when scores 20

        array[y5+36][x5+5]= 1;

        array[y6+36][x6+5]= 1;

        array[y7+36][x7+5]= 2;

        array[y8+36][x8+5]= 2;
    }
    if(Score>=30) {
        array[y+36][x+5]= 1;

        array[y1+36][x1+5]= 1;

        array[y2+36][x2+5]= 1;

        array[y3+36][x3+5]= 1;

        array[y4+36][x4+5]= 1;

        array[y5+36][x5+5]= 1;//Snake grows to this length when scores 30

        array[y6+36][x6+5]= 1;

        array[y7+36][x7+5]= 2;

        array[y8+36][x8+5]= 2;

        array[y9+36][x9+5]= 2;

        array[y10+36][x10+5]= 2;

    }
    if(Score>=40) {
        array[y+36][x+5]= 1;

        array[y1+36][x1+5]= 1;

        array[y2+36][x2+5]= 1;

        array[y3+36][x3+5]= 1;

        array[y4+36][x4+5]= 1;

        array[y5+36][x5+5]= 1;

        array[y6+36][x6+5]= 1;//Snake grows to this length when scores 40

        array[y7+36][x7+5]= 2;

        array[y8+36][x8+5]= 2;

        array[y9+36][x9+5]= 2;

        array[y10+36][x10+5]= 2;

        array[y11+36][x11+5]= 2;

        array[y12+36][x12+5]= 2;

    }

    if(Score>=50) {
        array[y+36][x+5]= 1;

        array[y1+36][x1+5]= 1;

        array[y2+36][x2+5]= 1;

        array[y3+36][x3+5]= 1;

        array[y4+36][x4+5]= 1;

        array[y5+36][x5+5]= 1;  //Snake grows to this length when scores 50

        array[y6+36][x6+5]= 1;

        array[y7+36][x7+5]= 2;

        array[y8+36][x8+5]= 2;

        array[y9+36][x9+5]= 2;

        array[y10+36][x10+5]= 2;

        array[y11+36][x11+5]= 2;

        array[y12+36][x12+5]= 2;

        array[y13+36][x13+5]= 2;

        array[y14+36][x14+5]= 2;

    }
    if(Score>=60) {
        array[y+36][x+5]= 1;

        array[y1+36][x1+5]= 1;

        array[y2+36][x2+5]= 1;

        array[y3+36][x3+5]= 1;

        array[y4+36][x4+5]= 1;

        array[y5+36][x5+5]= 1;

        array[y6+36][x6+5]= 1;

        array[y7+36][x7+5]= 2;  //Snake grows to this length when scores 60

        array[y8+36][x8+5]= 2;

        array[y9+36][x9+5]= 2;

        array[y10+36][x10+5]= 2;

        array[y11+36][x11+5]= 2;

        array[y12+36][x12+5]= 2;

        array[y13+36][x13+5]= 2;

        array[y14+36][x14+5]= 2;

        array[y15+36][x15+5]= 2;

        array[y16+36][x16+5]= 2;

    }
    if(Score>=70) {
        array[y+36][x+5]= 1;

        array[y1+36][x1+5]= 1;

        array[y2+36][x2+5]= 1;

        array[y3+36][x3+5]= 1;

        array[y4+36][x4+5]= 1;

        array[y5+36][x5+5]= 1;

        array[y6+36][x6+5]= 1;  //Snake grows to this length when scores 70

        array[y7+36][x7+5]= 2;

        array[y8+36][x8+5]= 2;

        array[y9+36][x9+5]= 2;

        array[y10+36][x10+5]= 2;

        array[y11+36][x11+5]= 2;

        array[y12+36][x12+5]= 2;

        array[y13+36][x13+5]= 2;

        array[y14+36][x14+5]= 2;

        array[y15+36][x15+5]= 2;

        array[y16+36][x16+5]= 2;

        array[y17+36][x17+5]= 2;

        array[y18+36][x18+5]= 2;

    }
    if(Score>=80) {
        array[y+36][x+5]= 1;

        array[y1+36][x1+5]= 1;

        array[y2+36][x2+5]= 1;

        array[y3+36][x3+5]= 1;

        array[y4+36][x4+5]= 1;

        array[y5+36][x5+5]= 1;

        array[y6+36][x6+5]= 1;

        array[y7+36][x7+5]= 2;

        array[y8+36][x8+5]= 2;

        array[y9+36][x9+5]= 2;

        array[y10+36][x10+5]= 2;  //Snake grows to this length when scores 80

        array[y11+36][x11+5]= 2;

        array[y12+36][x12+5]= 2;

        array[y13+36][x13+5]= 2;

        array[y14+36][x14+5]= 2;

        array[y15+36][x15+5]= 2;

        array[y16+36][x16+5]= 2;

        array[y17+36][x17+5]= 2;

        array[y18+36][x18+5]= 2;

        array[y19+36][x19+5]= 2;

        array[y20+36][x20+5]= 2;

    }
    if(Score>=90) {
        array[y+36][x+5]= 1;

        array[y1+36][x1+5]= 1;

        array[y2+36][x2+5]= 1;

        array[y3+36][x3+5]= 1;

        array[y4+36][x4+5]= 1;

        array[y5+36][x5+5]= 1;

        array[y6+36][x6+5]= 1;

        array[y7+36][x7+5]= 2;

        array[y8+36][x8+5]= 2;    //Snake grows to this length when scores 90

        array[y9+36][x9+5]= 2;

        array[y10+36][x10+5]= 2;

        array[y11+36][x11+5]= 2;

        array[y12+36][x12+5]= 2;

        array[y13+36][x13+5]= 2;

        array[y14+36][x14+5]= 2;

        array[y15+36][x15+5]= 2;

        array[y16+36][x16+5]= 2;

        array[y17+36][x17+5]= 2;

        array[y18+36][x18+5]= 2;

        array[y19+36][x19+5]= 2;

        array[y20+36][x20+5]= 2;

        array[y21+36][x21+5]= 2;
        array[y22+36][x22+5]= 2;

    }
    if(Score>=100) {
        array[y+36][x+5]= 1;

        array[y1+36][x1+5]= 1;

        array[y2+36][x2+5]= 1;

        array[y3+36][x3+5]= 1;

        array[y4+36][x4+5]= 1;

        array[y5+36][x5+5]= 1;

        array[y6+36][x6+5]= 1;

        array[y7+36][x7+5]= 2;

        array[y8+36][x8+5]= 2;

        array[y9+36][x9+5]= 2;

        array[y10+36][x10+5]= 2;

        array[y11+36][x11+5]= 2;

        array[y12+36][x12+5]= 2;  //Snake grows to this length when scores 100

        array[y13+36][x13+5]= 2;

        array[y14+36][x14+5]= 2;

        array[y15+36][x15+5]= 2;

        array[y16+36][x16+5]= 2;

        array[y17+36][x17+5]= 2;

        array[y18+36][x18+5]= 2;

        array[y19+36][x19+5]= 2;

        array[y20+36][x20+5]= 2;

        array[y21+36][x21+5]= 2;

        array[y22+36][x22+5]= 2;

        array[y23+36][x23+5]= 2;

        array[y24+36][x24+5]= 2;

    }
    DrawArray(); // draws snake 



}

//void that ends game when snake hits the wall or snake eats itself 
void EndGame()
{

    if(y+36==46||y+36==0||x+5==83||x+5==0) { //checks if the snake head is equal to any pixels that are out of bounds 
        GameOver();
        wait(3);

    }
}
//void to show when game is ended. shows GAMEOVER and the score that the user has 
void GameOver()
{

    // first need to initialise display

    lcd.clear();
    lcd.printString("GAME OVER",15,1); // print GAME OVER
    sprintf(str,"%d",Score);
    lcd.printString(str,37,3);    // shows score in centre of screen 
    lcd.printString("Press Button",6,5); // shows press button to return to menu
    while(1) {
        if (buttonA==1) {
            lcd.clear();
            checkerBoard();
            wait(0.5);
            lcd.clear();
            x = 0;
            x1 = 0;
            x2 = 0;
            x3 = 0;
            x4 = 0;
            x5 = 0;
            x6 = 0;
            x7 = 0;
            x8 = 0;
            x9 = 0;
            x10 = 0;
            x11 = 0;
            x12 = 0;
            x13 = 0;
            x14 = 0;
            x15 = 0;      // SETS ALL VALUES BACK TO ORGINAL SO GAME CAN START AGAIN 
            x16 = 0;
            x17 = 0;
            x18 = 0;
            x19 = 0;
            x20 = 0;
            x21 = 0;
            x22 = 0;
            x23 = 0;
            x24 = 0;
            y = 0;
            y1 = 1;
            y2 = 2;
            y3 = 3;
            y4 = 4;
            y5 = 5;
            y6 = 6;
            y7 = 7;
            y8 = 8;
            y9 = 9;
            y10 = 10;
            y11 = 11;
            y12 = 12;
            y13 = 13;
            y14 = 14;
            y15 = 15;
            y16 = 16;
            y17 = 17;
            y18 = 18;
            y19 = 19;
            y20 = 20;
            y21 = 21;
            y22 = 22;
            y23 = 23;
            y24 = 24;
            change = 1;
            pause=0;
            Score=0;

            Menu(); // returns to menu so game can start again

        }
    }
}
//void that comes up when the maximum score is achieved shows "YOU WIN" and shows the user the score
void Winner()
{
    if(Score==110) { // when the score is equal to 110 

        lcd.clear();
        lcd.printString("YOU WIN!!!",10,1); // Clear screen and show YOU WIN
        sprintf(str,"%d",Score);     // shows score in the centre of the page
        lcd.printString(str,34,3);
        lcd.printString("Press Button",6,5);
        while(1) {
            if (buttonA==1) { // when the button on the PCB the screen checkers and the Menu displayed  
                lcd.clear();
                checkerBoard();
                wait(0.5);
                lcd.clear();
                x = 0;
                x1 = 0;
                x2 = 0;
                x3 = 0;
                x4 = 0;
                x5 = 0;
                x6 = 0;
                x7 = 0;
                x8 = 0;
                x9 = 0;
                x10 = 0;
                x11 = 0;
                x12 = 0;
                x13 = 0;
                x14 = 0;
                x15 = 0;
                x16 = 0;
                x17 = 0;
                x18 = 0;
                x19 = 0;
                x20 = 0;
                x21 = 0;
                x22 = 0;
                x23 = 0;  // SET ALL VALUES BACK TO ORIGINAL VALUE 
                x24 = 0;
                y = 0;
                y1 = 1;
                y2 = 2;
                y3 = 3;
                y4 = 4;
                y5 = 5;
                y6 = 6;
                y7 = 7;
                y8 = 8;
                y9 = 9;
                y10 = 10;
                y11 = 11;
                y12 = 12;
                y13 = 13;
                y14 = 14;
                y15 = 15;
                y16 = 16;
                y17 = 17;
                y18 = 18;
                y19 = 19;
                y20 = 20;
                y21 = 21;
                y22 = 22;
                y23 = 23;
                y24 = 24;
                change = 1;
                pause=0;
                Score=0;

                Menu(); //SHOW MENU

            }
        }
    }
}
