/**
@file main.h
@brief Header file containing functions prototypes, defines and global variables.
@brief Revision 1.0.
@author Wu Chyi Woon
@date  May 2015
*/

#include "mbed.h"
#include "N5110.h"
#include "SDFileSystem.h"
#define JOYSTICK_TOLERANCE 0.1 ///direction tolerance of joystick

/**  
@namespace lcd
@brief Define output pins for lcd display
*/

N5110 lcd (PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);

/**  
@namespace sd
@brief Define output pins for SD card
*/
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd");

/// VARIABLES

int pdirection;/*!< temporary direction store for constant movement function */
int gamemode; /*!< Decides game mode */
int HiScoreTable[5]; /*!< Array to store high scores (read from SD, write to SD) */
int level_array[5]; /*!< Array to store levels for highscores when reading from SD */
int level;  /*!< storage for current level */
int fx,fy,score; /*!< global variables to hold data (food coordinates, score) */
volatile int butt1_flag, butt2_flag; /*!< Button flags */
float levelcalc ; /*!< storage for current speed depending on level */
bool gameOver; /*!< decides if game has ended */
FILE *fp; /*!< pointer for file storage system */

const int width = (84 - 2) / 2 ; /*!< Constant variable for screen width (playable by snake)*/
const int height = (48 - 4) / 2 ; /*!< Constant variable for screen height (playable by snake) */

/** 
enum for joystick directions
*/
enum DirectionName { //joystick directions
    CENTRE,
    UP,
    LEFT,
    DOWN,
    RIGHT,
    UNKNOWN
};

/** 
struct for joystick data
*/
typedef struct joystick1 Joystick;
struct joystick1 {
    float x;    /// current x value
    float x0;   /// 'centred' x value
    float y;    /// current y value
    float y0;   /// 'centred' y value
    int button; /// button state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    DirectionName direction;  // current direction
};

Joystick joystick; /// defines joystick

typedef struct snake1 Snake;
struct snake1 {
    int hx; /// head x value
    int hy; /// head y value
    int length; /// snake length
    int tailx[100],taily[100]; ///tail coordinates array
};

Snake snake; ///defines snake


/// FUNCTIONS

/**
Initializes the display
*/
void init_display();

/** 
Function to draw game screen, is called by ticker timer. Draws the hard wall, snake body and food.
*/
void draw_screen();

/**
Calibrates the joystick to get the offset for centering
*/
void calibrate_joystick();

/** 
function to determine the direction the joystick is pointing
*/
void joystick_pos();

/**
generates food position by random
*/
void food_pos();


/**
moves the snake (head) according to joystick position. Called in the game logic.
*/
void snake_move();

/**
Main logic of the snake game including growth rule, death rule
*/
void snake_logic_1();

/**
Displays the gameOver screen
*/
void gameOver_screen();

/**
Displays the gamePaused screen, activated via button in game
*/
void gamePaused_screen();

/** 
Displays the main menu in game
*/
void main_menu();
/**
Displays the highscores according to level. Called from main menu
*/
void HiScoreScreen();

/**
Displays the settings screen, called from main menu
*/
void settingsScreen();

/** 
activates the gameplay, called from main menu
*/
void game();


/**
ISR for button 1 to activate flag
*/
void butt1_isr();

/** 
ISR for button 2 to activate flag
*/
void butt2_isr();

/**  
@namespace gameTimer1
@brief Ticker Used for game logic
*/
Ticker gameTimer1;

/**  
@namespace gameTimer2
@brief Ticker used for Draw Screen
*/
Ticker gameTimer2;

/**  
@namespace joystickTimer
@brief Ticker used for joystick position
*/
Ticker joystickTimer;

/**  
@namespace xAxis
@brief AnalogIn for xAxis of joystick
*/
AnalogIn xAxis(A0);

/**  
@namespace yAxis
@brief AnalogIn for yAxis of joystick
*/
AnalogIn yAxis(A1);

/**  
@namespace Butt1
@brief InterruptIn for joystick Button
*/
InterruptIn Butt1(PTB11);

/**  
@namespace Butt2
@brief InterruptIn for button
*/
InterruptIn Butt2(PTB18);

/**  
@namespace LED
@brief DigitalOut for LED
*/
DigitalOut LED(PTC2);




