/**
@file main.h
@brief ʜeader file declares functions and variables
@brief Reverse parking and motion detection tool - Embedded Systems Project
@brief Revision 1.0.
@author Mateusz Loboda
@Date 02/05/16
*/


#ifndef MAIN_H
#define MAIN_H
#include "mbed.h"
#include "N5110.h"
#include "SRF02.h"

/**
@namespace lcd
@brief Object of the N5110 class
*/
N5110 lcd(PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);

/**
@namespace sensor
@brief Object of the SRF02 class
*/
SRF02 sensor(I2C_SDA,I2C_SCL);

/**
@namespace r_led
@brief Output for status of red LED
*/
DigitalOut r_led(LED_RED);

/**
@namespace g_led
@brief Output for status of green LED
*/
DigitalOut g_led(LED_GREEN);

/**
@namespace b_led
@brief Output for status of blue LED
*/
DigitalOut b_led(LED_BLUE);

/**
@namespace button 1
@brief Interrupt executes an event triggered task
*/
InterruptIn button1(PTB9);

/**
@namespace button 2
@brief Interrupt executes an event triggered task
*/
InterruptIn button2(PTB18);

/**
@namespace buzzer
@brief Use PWM pin to control the volume of the buzzer, duty cycle and period
*/
PwmOut buzzer(PTA2);

/**
@namespace pot
@brief Read value of the potentiometer from the potentiometer position
*/
AnalogIn rate(PTB10);

/**
@namespace myled
@brief Output for status of red LED, used as auditory alert 
*/
DigitalOut myled(PTC2);

/**
@namespace timer
@brief Periodic interrupt executes a time triggered task
*/
Ticker ticker; 

/**
@namespace timeout
@brief Interrupt used to call a function after a specified amount of time
*/
Timeout out;  

//variables
volatile int g_button1_flag = 0; /*!< Set flag in ISR for button 1, event triggered interrupt */
volatile int g_button2_flag = 0; /*!< Set flag in ISR for button 2, event triggered interrupt */
volatile int g_ticker_flag = 0;  /*!< Set ticker flag in ISR , time triggered interrupt */


/**
The main function where the code is executed
*/
int main();

/**
setting flag to 1
*/
void units();

/**
setting flag to 1
*/
void mode();

/**
setting flag to 1
*/
void timeout_isr();

/**
setting flag to 1
*/
void ticker_isr();

/**
Setting up the buttons and on board LEDs
*/
void init_K64F();

/**
Inital screen printed
*/
void initialScreen();

/**
Initialize graph array for distance points
*/
void initialArray();

/**
calculate the average distance from a set number of consecutive readings 
*/
void get_averageDistance();

/**
Set visual and auditory alerts 
*/
void redLedIndicator();

/**
Creates rectangular bars
*/
void drawDistanceBars();

/**
Shifts array elements by one 
*/
void moveArrayElements();

/**
assigning float distance to first element of graph matrix
*/
void adjacentArrayElements();

/**
plots the x and y axes
*/
void plotAxes();

/**
converts float distance to integer pixel and plots the point
*/
void plotDistancePoint();

//void modeTwo();

/// equation which relates the average distance to the frequency of the buzzer 
float buzzerPeriod;

/// output value of the potentiometer used to control buzzer volume
float delay;

/// average of multiple consecutive distance readings
float averageDistance;

/// initialize graph array, 2 pixels used for a and y axis hence array not 84
float graphArray[82];
 
#endif