/**
@file sounds.h

@brief Header file for containing defines of note frequencies and sound arrays
@brief Revision 1.1
@author Joel W. Webb
@date March 2016
*/

/// Note definitions from Arduino.cc
#define NOTE_B0  31
#define NOTE_C1  33
#define NOTE_CS1 35
#define NOTE_D1  37
#define NOTE_DS1 39
#define NOTE_E1  41
#define NOTE_F1  44
#define NOTE_FS1 46
#define NOTE_G1  49
#define NOTE_GS1 52
#define NOTE_A1  55
#define NOTE_AS1 58
#define NOTE_B1  62
#define NOTE_C2  65
#define NOTE_CS2 69
#define NOTE_D2  73
#define NOTE_DS2 78
#define NOTE_E2  82
#define NOTE_F2  87
#define NOTE_FS2 93
#define NOTE_G2  98
#define NOTE_GS2 104
#define NOTE_A2  110
#define NOTE_AS2 117
#define NOTE_B2  123
#define NOTE_C3  131
#define NOTE_CS3 139
#define NOTE_D3  147
#define NOTE_DS3 156
#define NOTE_E3  165
#define NOTE_F3  175
#define NOTE_FS3 185
#define NOTE_G3  196
#define NOTE_GS3 208
#define NOTE_A3  220
#define NOTE_AS3 233
#define NOTE_B3  247
#define NOTE_C4  262
#define NOTE_CS4 277
#define NOTE_D4  294
#define NOTE_DS4 311
#define NOTE_E4  330
#define NOTE_F4  349
#define NOTE_FS4 370
#define NOTE_G4  392
#define NOTE_GS4 415
#define NOTE_A4  440
#define NOTE_AS4 466
#define NOTE_B4  494
#define NOTE_C5  523
#define NOTE_CS5 554
#define NOTE_D5  587
#define NOTE_DS5 622
#define NOTE_E5  659
#define NOTE_F5  698
#define NOTE_FS5 740
#define NOTE_G5  784
#define NOTE_GS5 831
#define NOTE_A5  880
#define NOTE_AS5 932
#define NOTE_B5  988
#define NOTE_C6  1047
#define NOTE_CS6 1109
#define NOTE_D6  1175
#define NOTE_DS6 1245
#define NOTE_E6  1319
#define NOTE_F6  1397
#define NOTE_FS6 1480
#define NOTE_G6  1568
#define NOTE_GS6 1661
#define NOTE_A6  1760
#define NOTE_AS6 1865
#define NOTE_B6  1976
#define NOTE_C7  2093
#define NOTE_CS7 2217
#define NOTE_D7  2349
#define NOTE_DS7 2489
#define NOTE_E7  2637
#define NOTE_F7  2794
#define NOTE_FS7 2960
#define NOTE_G7  3136
#define NOTE_GS7 3322
#define NOTE_A7  3520
#define NOTE_AS7 3729
#define NOTE_B7  3951
#define NOTE_C8  4186
#define NOTE_CS8 4435
#define NOTE_D8  4699
#define NOTE_DS8 4978


/**
@note Tunes are defined as float arrays with a structure {Note, Time of Note, Note2, Time of Note 2... etc, NULL}
@note Must end in a NULL or we start to read from memory outside the note array
*/
const float tune_intro[] = {NOTE_E4,0.2,NOTE_GS4,0.2,NOTE_B4,0.2,NOTE_E5,0.2,NOTE_B4,0.2,NOTE_GS4,0.2,NOTE_E4,0.3,1,0.1,NOTE_GS4,0.2,NOTE_E4,0.3,NULL};
const float tune_snakeintro[] = {NOTE_C4,0.2,NOTE_CS4,0.2,NOTE_D4,0.2,NOTE_DS4,0.2,NOTE_E4,0.2,NOTE_B3,0.2,NOTE_E4,0.4,NOTE_C4,0.2,NOTE_CS4,0.2,NOTE_D4,0.2,NOTE_DS4,0.2,NOTE_E4,0.2,NOTE_B3,0.2,NOTE_E4,0.4,NULL};
const float tune_plinkintro[] = {NOTE_C5,0.05,NOTE_D5,0.05,NOTE_E5,0.05,NOTE_F5,0.05,NOTE_G5,0.1,NULL};
const float tune_snakeEat[] = {NOTE_D5,0.1,NOTE_FS5,0.1,NULL};
const float tune_plinkjump_small[] = {NOTE_C6,0.05,1,0.05,NOTE_C6,0.05,NULL};
const float tune_plinkjump_normal[] = {NOTE_C3,0.05,1,0.05,NOTE_C3,0.05,NULL};
const float tune_plinkjump_big[] = {NOTE_C1,0.05,1,0.05,NOTE_C1,0.05,NULL};
const float tune_gameOver[] = {NOTE_E5,0.2,NOTE_DS5,0.2,NOTE_D5,0.2,NOTE_CS5,0.4,NULL};

const float tune_test1[] = {NOTE_C4,0.5,NOTE_D4,0.5,NOTE_E4,0.5,NOTE_F4,0.5,NOTE_G4,0.5,NOTE_A4,0.5,NOTE_B4,0.5,NOTE_C5,0.5,NULL};
const float tune_test2[] = {NOTE_C5,0.25,NOTE_B4,0.25,NOTE_A4,0.25,NOTE_G4,0.25,NOTE_F4,0.25,NOTE_E4,0.25,NOTE_D4,0.25,NULL};



/// The Timout object used originally has been re-designed as a Ticker because the poll-joystick interrupt was interferring with the Timout and breaking it
Ticker note;

/// playSound is the function to make calling the sound_isr easier form within our code
void playSound(const float* sound) /// const float* sound is a pointer to the first element of the tune array you wish to play
{
    noteArray = sound; /// It is stored in the global const float pointer noteArray
    note.attach(&sound_isr,0.005);
}

/// The sound_isr is a Timeout interrupt service routine that calls itself with varying time delays
void sound_isr()
{
    /// If the float located at *noteArray is a NULL then we have reached the end of the tune
    if (*noteArray != NULL) {

        if (*noteArray == 1) {  /// If the frequency is 0 then we have a pause
            buzzer = 0.0;
        } else {  /// PWM signal with frequency equal to *noteArray
            buzzer = 0.5;
            buzzer.period((float) 1.0/(*noteArray));
        }
        if ((*(noteArray+1)>5.0F) || (*(noteArray+1) == 0)){
            error();
        }
        note.detach();
        note.attach(&sound_isr,*(noteArray+1));   /// Recall sound_isr with the time delay located one array index after the note frequency *(noteArray+1)
        noteArray += 2;   /// Increment the noteArray pointer to point at the next note in the array to be played (or NULL);

    } else {
        noteArray = NULL; /// If we reach the end of the tune array then we clear to noteArray pointer of any memory value to avoid conflicts
        buzzer = 0; /// and set the duty cycle to 0
        note.detach();
    }
}
