/**
@file main.h
@brief Header file contains functions and variables
@brief Treasure Hunt - Embedded Systems Project
@brief Revision 1.0
@author Nikollao Sulollari
@Date 26/03/2016
*/

#ifndef MAIN_H
#define MAIN_H
#include "mbed.h"
#include "N5110.h"
#include "SoftPWM.h"

#define DIRECTION_TOLERANCE 0.05
/**
@nameSpace r_led
@brief output for status of red LED
*/
DigitalOut r_led(LED_RED);

/**
@namespace g_led
@brief output for status of green LED
*/
DigitalOut g_led(LED_GREEN);

/**
@namespace b_led
@brief output for status of blue LED
*/
DigitalOut b_led(LED_BLUE);

/**
@namespace blue_led
@brief output for status of blue LED, lights when game tool is loaded
*/
DigitalOut blue_led(PTA1);

/**
@namespace led_output
@brief output for status of left tries for the user to win the game
*/
BusOut led_output(PTC2,PTA2,PTB23);

/**
@namespace lcd
@brief object of the N5110 class
*/
N5110 lcd(PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);

/**
@namespace pc
@brief serial connection between mbed and pc
*/
Serial pc(USBTX,USBRX);

// K64F on-board switches
InterruptIn sw2(SW2);
InterruptIn sw3(SW3);


/**
@namespace xPot
@brief read x-axis position from the value of the joystick
*/
AnalogIn xPot(PTB2);

/**
@namespace yPot
@brief read y-axis position from the value of the joystick
*/
AnalogIn yPot(PTB3);

/**
@namespace button
@brief interrupt executes an event triggered task
*/
InterruptIn button(PTB10);

/**
@namespace button
@brief interrupt executes an event triggered task
*/
InterruptIn button1(PTB18);

/**
@namespace buzzer
@brief create PWM signal using the SoftPWM library to set buzzer duty cycle and period
*/
SoftPWM buzzer(PTB9);

/**
@namespace ticker
@brief interrupt executes a time-triggered task
*/
Ticker ticker;

/**
@namespace timer
@brief  interface is used to measure the time between start and stop
*/
Timer timer;

/**
@namespace game_ticker
@brief interrupt executes a time-triggered task
*/
Ticker game_ticker;

/**
@namespace timeout
@brief interrupt calls a function after a specified amount of time
*/
Timeout timeout;


/**
@namespace DirectionName
@brief define joystick's direction based on its x,y values
*/
enum DirectionName {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    CENTRE,
    UP_LEFT,
    UP_RIGHT,
    DOWN_LEFT,
    DOWN_RIGHT
};

/**
@namespace Joystick
@brief create strcut Joystick
*/
typedef struct JoyStick Joystick;
struct JoyStick {
    double x;    /// current x value
    double x0;   /// 'centred' x value
    double y;    /// current y value
    double y0;   /// 'centred' y value
    int button; /// button state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    DirectionName direction;  // current direction
};
/// create struct variable
Joystick joystick;

/**
The main function where the program takes place
*/
int main();

/**
set-up serial port
*/
void init_serial();

/**
 set-up the on-board LEDs and switches
*/
void init_K64F();

/**
Set-up random variables and game menu
*/
void init_game();

/**
Set-up flag to 1
*/

/**
Set-up flag to 1
*/
void timer_isr();

/**
Set-up flag to 1
*/

/**
Set-up flag to 1
*/
void game_timer_isr();

/**
Set-up flag to 1
*/
void sw2_isr();

/**
Set-up flag to 1
*/
void sw3_isr();

/**
Set-up flag to 1
*/
void button_isr();

/**
Set-up flag to 1
*/
void button1_isr();

/**
Set-up flag to 1
*/
void timeout_isr();


/**
Set current position to default position of Joystick
*/
void calibrateJoystick();

/**
Update the values of the joystick to get current position
*/
void updateJoystick();

/**
Create an enemy rectangular shape
*/
void enemyRect();

/**
Create an enemy rectangular shape
*/
void enemyRocket();

/**
Create circle shape enemy
*/
void enemyCircle();

/**
creates the hero of the game
*/
void hero();

/**
Shows the right direction
*/
void guidance();

/**
Locates obstacles in the screen
*/
void obstacles();

/**
Gets enemies depending on the level
*/
void enemies();

/**
Implement Menu in the game and display on screen
*/
void menu();

/**
Check for overlap between hero and enemies or obstacles
*/
void checkOverlap();

/**
Check for intrersection
@param i loops through x direction
@param j loops through y direction
@returns the number of pixels around the hero detected
*/
int intersection(int i, int j);


//vars
volatile int rectX; /*!< used to determine x-axis position of the rect enemy */

volatile int rectY ;/*!< used to determine y-axis position of the rect enemy */

volatile int circleX;/*!< used to determine x-axis position of the circular enemy */

volatile int circleY;/*!< used to determine y-axis position of the circular enemy */

volatile int heroX;/*!<  used to move the hero along x-axis */

volatile int heroY;/*!<  used to move the hero along y-axis */

volatile int level = 0; /*!< initiate the level difficulty of the game */

volatile int g_timer_flag = 0; /*!< set timer flag in the isr, timer trigger interrupt */

volatile int g_game_timer_flag = 0;  /*!< set timer flag in the isr, timer trigger interrupt */

volatile int g_sw2_flag = 0;  /*!< set timer flag in the isr, event trigger interrupt */

volatile int g_sw3_flag = 0;  /*!< set timer flag in the isr, event trigger interrupt */

volatile int g_button_flag = 0;  /*!< set flag in the isr, event trigger interrupt */

volatile int g_button1_flag = 0; /*!< set flag in the isr, event trigger interrupt */

volatile int option = 0;  /*!< select option in menu based on Joystick's movement */

volatile int play = 0; /*!< counts the number of plays */

volatile int tries = 3;/*!< counts the number of trials */

volatile int n;/*!< number of pixels overlapping */

volatile float game_speed = 0.05; /*!< value is set to the ticker, allows user to select game speed */

int fsm[4] = {7,6,4,0}; /*!< array of elements in the FSM, each element is the output of the counter */

int fsm_state = 0; /*!<  variable is used to access the array of states and produce an output */

int reset = 0; /*!< used to save current level of difficulty */

int objectX = 0; /*!< used to move obstacles in the x-axis */

int objectY = 20; /*!< used to move obstacles in the y-axis */

int state = 0; /*!< controls the direction of the objtacle */

int objectX1 = 58; /*!< used to move obstacles in the x-axis */

int state1 = 1; /*!< controls the direction of the objtacle */

int speed = 1; /*!< controls the speed menu display  */

bool normal=0; /*!< controls the lcd mode selection on menu */

bool sound = 0; /*!< determines if sound is on or off */

#endif