#include "mbed.h"
#include "N5110.h"
#include "Pieces.h"
#include <vector>


//Tetris by Kristian Bridges

//         VCC,    SCE,   RST,   D/C,   MOSI,  SCLK,   LED
N5110 lcd (PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);

AnalogIn potX(PTB2);
AnalogIn potY(PTB3);
DigitalIn joyButton(PTB11);
DigitalIn buttonA(PTB18);
DigitalIn buttonB(PTB19);
InterruptIn A(PTB18);
InterruptIn B(PTB19);

#define tolerance 0.1f
#define down_tolerance -0.1f
#define right_tolerance -0.1f

Ticker checkJoy;
Ticker gameCheck;

enum direction_t {
    UP, //0
    DOWN, //1
    LEFT, //2
    RIGHT, //3
    CENTRE, //4
    UNKNOWN //5
};

typedef struct {
    float initial_x,initial_y;
    float current_x,current_y;
    int button;
    direction_t direction;
    int buttonA;
    int buttonB;
} joystick;

joystick joy;
joystick rotate_buttons;

struct Tetris {
    int xP; //current x position
    int yP; //current y position
    int next_xP; //next potential x position
    int next_yP; //next potential y position
    int level;
    int line_check;
    int total_lines;
    int current_shape;
    int piece_in_play;
    int orientation;
    int score;
    int game_over;
    int orientation_copy;
    int currentPiece[10][10];
} tetris;

int g_bank_index  = 0;
int g_bank_index_copy = 4;
volatile int g_joyFlag = 0;
volatile int g_rotate_clock_flag = 0;
volatile int g_rotate_anticlock_flag = 0;
int currentState[45][40];
volatile int g_call_game_Flag = 0;
float timer = 1.0;

void menu();
void cal();
void joyUpdate();
void game();
void options();
void orientation();
void draw_piece();
void array_checker();
void piece_generator();
void anticlockwise();
void clockwise();
void gameCheck_isr();

int main()
{
    lcd.init();
    lcd.clear();
    lcd.printString("Tetris",24,1);
    lcd.printString("by",36,2);
    lcd.printString("K.Bridges",15,3);
    lcd.printString("SID: 200859491",0,5);
    wait(2);
    lcd.clear();
    cal();
    checkJoy.attach(&joyUpdate,0.01);
    menu();
}

void drawPiece()
{

}
void menu()
{
    int x,y;

    while(joy.button == 0) {
        if(g_joyFlag) {
            g_joyFlag = 0;

            switch(joy.direction) {
                case UP:
                    if(g_bank_index == 0) {
                        g_bank_index = 2;
                        break;
                    } else
                        g_bank_index--;
                    break;
                case DOWN:
                    if(g_bank_index == 2) {
                        g_bank_index = 0;
                    } else
                        g_bank_index++;
            }

            if(g_bank_index_copy != g_bank_index) {
                g_bank_index_copy = g_bank_index;

                if(g_bank_index == 0) {

                    lcd.clear();
                    lcd.printString("New Game",18,1);
                    lcd.printString("Achievements",6,2);
                    lcd.printString("Options",21,3);

                    for(x=0; x<WIDTH; x++) {
                        for(y=7; y<16; y++) {
                            if(lcd.getPixel(x,y)) {
                                lcd.clearPixel(x,y);
                            } else {
                                lcd.setPixel(x,y);
                            }
                        }
                    }
                }
                if(g_bank_index == 1) {

                    lcd.clear();
                    lcd.printString("New Game",18,1);
                    lcd.printString("Achievements",6,2);
                    lcd.printString("Options",21,3);

                    for(x=0; x<WIDTH; x++) {
                        for(y=15; y<24; y++) {
                            if(lcd.getPixel(x,y)) {
                                lcd.clearPixel(x,y);
                            } else {
                                lcd.setPixel(x,y);
                            }
                        }
                    }
                }
                if(g_bank_index == 2) {

                    lcd.clear();
                    lcd.printString("New Game",18,1);
                    lcd.printString("Achievements",6,2);
                    lcd.printString("Options",21,3);

                    for(x=0; x<WIDTH; x++) {
                        for(y=23; y<32; y++) {
                            if(lcd.getPixel(x,y)) {
                                lcd.clearPixel(x,y);
                            } else {
                                lcd.setPixel(x,y);
                            }
                        }
                    }
                }
                lcd.refresh();
            } else if(g_bank_index_copy == g_bank_index) {
                sleep();
            }
        }
    }//end of while loop

    if(g_bank_index == 0) {
        lcd.clear();
        game();
    } else if(g_bank_index == 1) {
        lcd.clear();
    } else if(g_bank_index == 2) {
        lcd.clear();
        options();
    }
}//end of function

void cal()
{
    joy.initial_x = potX;
    joy.initial_y = potY;
    joyButton.mode(PullDown);
    buttonA.mode(PullDown); //1 if pressed
    buttonB.mode(PullDown); //1 if pressed
    A.fall(&anticlockwise);
    B.fall(&clockwise);
}

void joyUpdate()
{
    joy.current_x = potX - joy.initial_x; //current x-position
    joy.current_y = potY - joy.initial_y; //current y-position
    joy.button = joyButton; //current button state
    rotate_buttons.buttonA = buttonA; //current anti-clockwise state
    rotate_buttons.buttonB = buttonB; //current clockwise state

    if((joy.current_y) > tolerance && fabs(joy.current_x) < tolerance) {    //fabs returns an absolute value
        joy.direction = UP;
    } else if((joy.current_y) < down_tolerance && fabs(joy.current_x) < tolerance) {
        joy.direction = DOWN;
    } else if((joy.current_x) > tolerance && fabs(joy.current_y) < tolerance) {
        joy.direction = LEFT;
    } else if((joy.current_x) < right_tolerance && fabs(joy.current_y) < tolerance) {
        joy.direction = RIGHT;
    } else if(fabs(joy.current_x) < tolerance && fabs(joy.current_y) < tolerance) {
        joy.direction = CENTRE;
    } else
        joy.direction = UNKNOWN;
    g_joyFlag = 1;
}
void piece_generator()
{
    
    if(tetris.piece_in_play == 0) { //initialisation of a piece in play
        tetris.current_shape = rand() %7;
        tetris.xP = rand() % 39 + 0; //39 is the least significant x position (xP is the current position of the piece)
        tetris.yP = -5; //change if collision rules check out (yP is the current position of the piece)
        tetris.orientation = 0;
        tetris.piece_in_play = 1; //defines whether a piece is in play
    }
}

void game()
{
    tetris.orientation_copy = 5;
    tetris.game_over = 0;
    lcd.printString("Score:",0,1);
    lcd.printString("Lines:",0,4);
    lcd.drawRect(38,0,42,47,0);
    srand(time(NULL));
    for(int y = 0; y<45; y++) {
        for(int x = 0; x<40; x++) {
            if(y == 44) {
                currentState[y][x] = 1;
            } else
                currentState[y][x] = 0;
        }
    }

    gameCheck.attach(&gameCheck_isr,timer);
    while(tetris.game_over == 0) {
        if(joy.direction == UP) {
            timer = 0.01;
        } else timer = 0.1;

        if(g_call_game_Flag == 1) {
            piece_generator();
            orientation();
            draw_piece();
            for(int y=0; y<45; y++) {
                for(int x=0; x<40; x++) {
                    if(currentState[y][x] == 1) {
                        lcd.setPixel(x+39,y+1);
                    } else
                        lcd.clearPixel(x+39,y+1);
                }
            }

            for(int m = 0; m<10; m++) {
                for(int n = 0; n<10; n++) {
                    if(tetris.currentPiece[m][n] == 1) {
                        lcd.setPixel(tetris.xP+n+39,tetris.yP+m+1);
                    }
                }
            }
            
            lcd.refresh();
            array_checker();
        }
        sleep();
    }
    gameCheck.detach();
    lcd.clear();
    lcd.printString("Game Over",15,2);
    wait(1);
    lcd.clear();
    menu();
}

void options()
{
    float brightness = 0.5;

    lcd.printString("UP = +",24,0);
    lcd.printString("DOWN = -",18,1);
    lcd.printString("Press B",24,2);
    lcd.printString("to exit",21,3);

    while(joy.button == 0) {
        if(joy.direction == UP) {
            brightness += 0.1f;
            lcd.setBrightness(brightness);
        } else if(joy.direction == DOWN) {
            brightness -= 0.1f;
            lcd.setBrightness(brightness);
        }
    }
    lcd.clear();
    menu();
}


void orientation()
{


    if(g_rotate_clock_flag == 1) {
        g_rotate_clock_flag = 0;
        if(tetris.orientation == 3) {
            tetris.orientation = 0;
        } else if(tetris.orientation == 0) {
            tetris.orientation++;
        }
    }

    if(g_rotate_anticlock_flag == 1) {
        g_rotate_anticlock_flag = 0;
        if(tetris.orientation == 0) {
            tetris.orientation = 3;
        } else if(tetris.orientation == 3) {
            tetris.orientation--;
        }
    }
    if(tetris.orientation_copy != tetris.orientation) {
        tetris.orientation_copy = tetris.orientation;

        if(tetris.current_shape == 0) { //Square
            if(tetris.orientation == 0 || 1 || 2 || 3) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = O[m][n];
                    }
                }
            }
        }

        if(tetris.current_shape == 1) { //I
            if(tetris.orientation == 0) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = I0[m][n];
                    }
                }
            }
            if(tetris.orientation == 1) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = I90[m][n];
                    }
                }
            }
            if(tetris.orientation == 2) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = I180[m][n];
                    }
                }
            }
            if(tetris.orientation == 3) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = I270[m][n];
                    }
                }
            }
        }

        if(tetris.current_shape == 2) { //L
            if(tetris.orientation == 0) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = L0[m][n];
                    }
                }
            }
            if(tetris.orientation == 1) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = L90[m][n];
                    }
                }
            }
            if(tetris.orientation == 2) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = L180[m][n];
                    }
                }
            }
            if(tetris.orientation == 3) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = L270[m][n];
                    }
                }
            }
        }

        if(tetris.current_shape == 3) { //J
            if(tetris.orientation == 0) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = J0[m][n];
                    }
                }
            }
            if(tetris.orientation == 1) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = J90[m][n];
                    }
                }
            }
            if(tetris.orientation == 2) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = J180[m][n];
                    }
                }
            }
            if(tetris.orientation == 3) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = J270[m][n];
                    }
                }
            }
        }

        if(tetris.current_shape == 4) { //Z
            if(tetris.orientation == 0) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = Z0[m][n];
                    }
                }
            }
            if(tetris.orientation == 1) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = Z90[m][n];
                    }
                }
            }
            if(tetris.orientation == 2) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = Z180[m][n];
                    }
                }
            }
            if(tetris.orientation == 3) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = Z270[m][n];
                    }
                }
            }
        }

        if(tetris.current_shape == 5) { //S
            if(tetris.orientation == 0) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = S0[m][n];
                    }
                }
            }
            if(tetris.orientation == 1) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = S90[m][n];
                    }
                }
            }
            if(tetris.orientation == 2) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = S180[m][n];
                    }
                }
            }
            if(tetris.orientation == 3) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = S270[m][n];
                    }
                }
            }
        }

        if(tetris.current_shape == 6) { //T
            if(tetris.orientation == 0) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = T0[m][n];
                    }
                }
            }
            if(tetris.orientation == 1) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = T90[m][n];
                    }
                }
            }
            if(tetris.orientation == 2) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = T180[m][n];
                    }
                }
            }
            if(tetris.orientation == 3) {
                for(int m = 0; m < 10; m++) {
                    for(int n = 0; n < 10; n++) {
                        tetris.currentPiece[m][n] = T270[m][n];
                    }
                }
            }
        }
    }
}
bool GetcurrentState(int y,int x){

if (y<0||y>45||x<0||x>40) return false;

return currentState[y][x];
}

void SetcurrentState(int y,int x,bool state){

if (y<0||y>45||x<0||x>40) return;

currentState[y][x] = state;
}
void draw_piece()
{

    if(joy.direction == LEFT) {
        tetris.next_xP = tetris.xP-1;
    } else if(joy.direction == RIGHT) {
        tetris.next_xP = tetris.xP+1;
    } else {

        tetris.next_xP = tetris.xP;

    }

    if (tetris.next_xP+10>42) {
        tetris.next_xP = 42-10;
    }
    if (tetris.next_xP<0) {
        tetris.next_xP = 0;
    }
    bool piece_collided_x = false;
    for(int y = 0; y < 10; y++) {
        for(int x = 0; x < 10; x++) {
            if((tetris.currentPiece[y][x] == 1)   && (GetcurrentState(tetris.yP + y,tetris.next_xP + x) == 1)) {
                piece_collided_x = true;
            }
        }
    }
    if(piece_collided_x == false) {
        tetris.xP = tetris.next_xP;
    }
    tetris.next_yP = tetris.yP+1;

    bool piece_collided_y = false;
    for(int y = 0; y < 10; y++) {
        for(int x = 0; x < 10; x++) {
            if((tetris.currentPiece[y][x] == 1)   && (GetcurrentState(tetris.next_yP + y,tetris.xP + x) == 1)) {
                piece_collided_y = true;
            }
        }
    }

    if(piece_collided_y == false) {
        tetris.yP = tetris.next_yP;
    } else {
        for(int y = 0; y < 10; y++) {
            for(int x = 0; x < 10; x++) {
                if((tetris.currentPiece[y][x] == 1)) {
                    SetcurrentState(tetris.yP + y,tetris.xP + x,1);
                }
            }
            tetris.piece_in_play = 0;
        }
    }


}

void array_checker()
{
    for(int x = 0; x<40; x++) {
        
        if(currentState[0][x] == 1) {
            printf("boop: %d",x);
            tetris.game_over = 1;
        }
    }
}


void clockwise()
{
    g_rotate_clock_flag = 1;
}
void anticlockwise()
{
    g_rotate_anticlock_flag = 1;
}
void gameCheck_isr()
{
    g_call_game_Flag = 1;
}
