/**

@file main.h

@Header file to denote the various functions, global variables, and definitions.


@Author: Kristian Bridges
@SID:200859491

@brief: University of Leeds Elec2645 (Embedded systems project)

@Date: May 2016

*/

#ifndef MAIN_H

#define MAIN_H

#include "mbed.h"

#include "Pieces.h"

#include "N5110.h"

// --------------- Peripherals - Input --------------

/**

@namespace joystick

@brief joystick that allows me to move in the x and y direction. Two potentiometers allow this functionality, as well as a button, which allows additional
functionality.

*/

AnalogIn potX(PTB2);
AnalogIn potY(PTB3);
DigitalIn joyButton(PTB11);

/**

@namespace Button A

@brief DigitalIn button that calls an interrupt to rotate the tetris piece anticlockwise.

*/

DigitalIn buttonA(PTB18);

/**

@namespace Button B

@brief DigitalIn button that calls an interrupt to rotate the tetris piece clockwise.

*/

DigitalIn buttonB(PTB19);

// -------------- Peripherals - Output --------------

/**

@namespace Nokia 5110 LCD

@brief 84*48 black and white pixel display.
@brief VCC, GND, SCE, RST, D/C, MOSI, SCLK, LED

*/

N5110 lcd (PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);

// -------------- Variables --------------

int g_bank_index  = 0; /*!<Index for the menu */
int g_bank_index_copy = 4; /*!<Backup index to ensure the menu doesn't continuously refresh the pixels on the screen */
volatile int g_joyFlag = 0; /*!<Interrupt for the joystick */
volatile int g_rotate_clock_flag = 0; /*!<Interrupt for the B button */
volatile int g_rotate_anticlock_flag = 0; /*!<Interrupt for the A button */
int currentState[45][40]; /*!<Array to store the current playfield state */
volatile int g_call_game_Flag = 0; /*!<Interrupt to call the game functions */
float timer = 1.0; /*!<Value for the game ticker */
int xP; /*!<Current x position */
int yP; /*!<Current y position */
int next_xP; /*!<Next x position */
int next_yP; /*!<Next y position */
int level; /*!<Stores the level */
int line_check; /*!<Checks whether 10 lines have been cleared */
int total_lines; /*!<Total lines cleared */
int current_shape; /*!<Current shape in play */
int piece_in_play; /*!<States whether there's a piece in play */
int orientation; /*!<Stores the orientation of the piece */
int score; /*!<Stores the score */
int game_over; /*!<States whether the game is over */
int orientation_copy; /*!<Keeps track of whether a rotation has occured */
int currentPiece[10][10]; /*!<Current piece in play */
float initial_x,initial_y; /*!<Initial x and y position of the joystick */ 
float current_x,current_y; /*!<Current x and y position of the joystick */
int button; /*!<State of the joystick button */
int buttonA; /*!<State of the anticlockwise button */
int buttonB; /*!<State of the clockwise button */

//  -------------- Functions --------------

/**

@namespace Menu

@brief Renders the menu based on the direction of the joystick.
@brief An index keeps track of which menu item is currently selected.
@brief Index also allows the appropriate function to be called.

*/
void menu();

/**

@namespace cal

@brief Calibrates the joystick, as well as the other input peripherals.

*/
void cal();

/**

@namespace joyUpdate

@brief Updates the direction of the joystick based on tolerances.

*/
void joyUpdate();

/**

@namespace game

@brief Carries out the necessary functions to render and update the game of tetris, although, the actual game doesn't work correctly.

*/
void game();

/**

@namespace options

@brief Allows the user to change the led brightness. More functions can be implemented if needed, such as options to change the parameter
@brief of the game.e

*/
void options();

/**

@namespace orientation

@brief Changes the orientation of the piece in play if either of the rotation interrupts are called.

*/
void orientation();

/**

@namspace draw_piece

@brief Checks the current piece array with the currentState array for any collisions at the next x,y-position. If a collision has been detected,
@brief the piece will be saved to the currentState array, and the next piece will be spawned.

@brief If a collision hasn't been detected, then the piece will be rendered onto the playfield.

*/
void draw_piece();

/**

@namespace array_checker

@brief Checks the currentState array for any elements that are 'on' throughout the top row.
@brief If there are any elements 'on', then the game finishes and returns back to the main menu.
@brief Some features are missing, such as the complete line checker, but the overall feature didn't work; this can be improved upon for a fully working
@brief game of tetris.

*/
void array_checker();

/**

@namespace piece_generator

@brief Generates the next tetris piece, as well as the initial piece orientation, and the initial x and y coordinates.
@brief Spawning of random shapes doesn't entirely work. Not sure whether it is the location of the seed, but further investigation into the issue is needed.

*/
void piece_generator();

/**

@namespace anticlockwise

@brief An ISR that sets a global variable to 1, and calls the piece to be rotated anticlockwise.

*/
void anticlockwise();

/**

@namespace clockwise

@brief An ISR that sets a global variable to 1, and calls the piece to be rotated clockwise.

*/
void clockwise();

/**

@namespace gameCheck_isr

@brief An ISR that sets a global variable to 1, and calls several functions from within the game function.

*/
void gameCheck_isr();



#endif