/**
@file main.h
@breif Version 1.2
@author Joseph Allison
@date 27/3/2016
*/

#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"

#include "time.h"
#include "N5110.h"

#include "Tetris.h"

#define E  3034
#define GSharp 2408
#define G 2551
#define A 2273
#define B 2025
#define C 1911
#define HD 1703
#define HE 1517
#define HF 1431
#define HG 1276
#define HA 1136

//         VCC,    SCE,   RST,   D/C,   MOSI,  SCLK,   LED
N5110 lcd (PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);

/** Creates Tertis instance*/
Tetris tetris;

/** Creates Ticker instance*/
Ticker ticker; 

/** Creates music ticker instace*/
Ticker musicticker;

/** Creates Timeout instances that is used to stop the left button double clicks */
Timeout lefttimeout;
/** Creates Timeout instances that is used to stop the right button double clicks */
Timeout righttimeout;
/** Creates Timeout instances that is used to stop the spin button double clicks */
Timeout spintimeout;
/** Creates Timeout instances that is used to stop the down button double clicks */
Timeout downtimeout;
/** Creates Timeout instances that is ised for the pause menu */
Timeout pausemenu;


/**
@namespace ain
@breif Analog input that is used for the seed for the randomiser
*/
AnalogIn ain(A0);

/** 
@namespace buzzer
@brief Buzzer output to play tetris music
*/
PwmOut buzzer(PTA2);


/**
@namespace left
@brief The interrupt input of the left button
*/
InterruptIn left(PTC5); //PTC7
/**
@namespace right
@brief The interrupt input of the right button
*/
InterruptIn right(PTC9);
/**
@namespace spin
@brief The interrupt input of the spin button
*/
InterruptIn spin(PTC7);
/**
@namespace down
@brief The interrupt input of the down button
*/
InterruptIn down(PTC0); //PTC5

/**
Displays the splash Screen
*/
void startScreen();

/**
Sets up the mode and the rise settings of the button interrupts
*/
void setupInterruptInputs();

/**
Creates the game menu and wait for user input
*/
void gameMenu();
/**
The screen that appears when the game is over and tells the user their score
*/
void gameOverScreen();
/**
Checks if any of the flags are one
*/
void checkGameFlags();
/**
Displays the help screen text and waits for user input
*/
void helpScreen();
/**
Sets the gamearea array to its initial state
*/
void setGameAreaArray();
/**
Randomly generates new bag of 7
*/
void newShapeBag();
/**
Moves the piece in the game area
@param x - How far the piece is moved horizontally
@param y - How far the piece is moved vertically
@param spin - How far the piece is spun round
*/
void movePiece(int x, int y,int spin);
/**
Moves the piece right
*/
void movePieceRight();
/**
Moves the piece left
*/
void movePieceLeft();
/**
Spins the piece clockwise
*/
void spinPiece();
/**
Moves the piece downwards
*/
void movePieceDown(); 

/**
Returns turn if piece placement is valid
@param xpos - The horizontal position of where to piece is moving to
@param ypos - The vertical position of where to piece is moving to
@param orientation - The orientation the piece will be in when it moves
*/
bool movePossible(int xpos, int ypos, int orientation); //returns turn if piece placement is valid

/**
Places the next piece in the game area
*/
void newpiece();

/**
Adds the placed piece to the game area array
*/
void pieceToGameArray();
/**
Checks each row of the game area to see if there are any rows complete
*/
void checkCompleteLine();
/**
Removes any completed rows
@param rowscomplete[4] - An array with of upto 4 row numbers
*/
void removeCompleteLines(int rowscomplete[4]);
/**
Sets the game area from the game area array
*/
void setGameArea(); 
/**
Resets the Ticker to chance the speed at which a piece falls
*/
void setTicker(float time);
/**
Fucntions called by the ticker to set g_timer_flag = 1
*/
void moveDownTicker();
/**
Fucntions called by the ticker to set g_left = 1
*/
void left_isr();
/**
Fucntions called by the ticker to set g_right = 1
*/
void right_isr();
/**
Fucntions called by the ticker to set g_spin = 1
*/
void spin_isr();
/**
Fucntions called by the ticker to set g_down = 1
*/
void down_isr();
/**
Fucntions called by the ticker to set g_music = 1
*/
void music_isr();


/**
Fucntions called by the timeout to set g_lefttimeout  = 1
*/
void lefttimeout_isr();
/**
Fucntions called by the timeout to set g_righttimeout  = 1
*/
void righttimeout_isr();
/**
Fucntions called by the timeout to set g_spintimeout  = 1
*/
void spintimeout_isr();
/**
Fucntions called by the timeout to set g_downtimeout  = 1
*/
void downtimeout_isr();

/**
Function called by the timeout to ser g_pausemenu = 1;
*/
void pausemenu_isr();


/**
True if the game is running
*/
bool gameplaying = true;
/**
True if the game menu is being displayed
*/
bool gamemenu = true;

/**
True if the game music is playing
*/
bool musicplaying = false;
/**
Counts through the notes in the array
*/
int musiccounter = 0;  
/**
Stores the next 7 shapes to be used - 7 bag system 
*/
int nextshape[7];
/**
Stores the players current score
*/
int score = 0; 
/**
The current level the user is on
*/
int level = 1;
/**
The number of lines the user has completed
*/
int completedlines = 0;
/**
The time between each downward movement of the piece
*/
double gamespeed = 0.8; //how often a block moves down

/**
Stores the postion of the piece (x,y)
*/
int pieceposition[2] = {4,0}; //set position of the current dropping piece ***
/**
The orientation of the piece
*/
int orientation = 0;
/**
The current piece on the screen
*/
int currentshape = 3;
/**
The next piece to be played on the screen
*/
int nextpiece;
/**
Counts through the shape in the 7 system bag of shapes
*/
int shapebagcounter = 0;

/**
Stores all the shapes I,J,L,O,T,S,Z all stored as Hex values
*/
int shapes[7][4] = {{0x00F0,0x4444,0x0F00,0x2222},{0x0071,0x0226,0x0470,0x0322},{0x0074,0x0622,0x0170,0x0223},{0x0033,0x0033,0x0033,0x0033},
                    {0x0072,0x0262,0x0270,0x0232},{0x0036,0x0462,0x0360,0x0231},{0x0063,0x0264,0x0630,0x0132}};
/**
Stores the current state of the game area. Used for checking collison
*/
int gamearea[12][16]; 

/**
Stores the notes used to play the music
*/
int musisnotes[64] = {E,E,E,GSharp,B,B,G,E,A,A,A,C,HE,HE,HD,C,B,B,B,C,HD,HD,HE,HE,C,C,A,A,A,A,A,A,
                        HF,HF,HF,HG,HA,HA,HG,HF,HE,HE,HE,HF,HE,HE,HD,C,B,B,B,C,HD,HD,HE,HE,C,C,A,A,A,A,A,A};


/**
Flag for the ticker
*/
volatile int g_timer_flag = 0;
/**
Flag for the left inperrupt
*/
volatile int g_left = 0;
/**
Flag for the right inperrupt
*/
volatile int g_right = 0;
/**
Flag for the spin inperrupt
*/
volatile int g_spin = 0;
/**
Flag for the down inperrupt
*/
volatile int g_down = 0;

/**Flag for the music ticker
*/
volatile int g_music = 0;

/**
Flag used to stop the left interrupt being called twice unintentionally
*/
volatile int g_lefttimeout = 1;
/**
Flag used to stop the right interrupt being called twice unintentionally
*/
volatile int g_righttimeout = 1;
/**
Flag used to stop the spin interrupt being called twice unintentionally
*/
volatile int g_spintimeout = 1;
/**
Flag used to stop the drop interrupt being called twice unintentionally
*/
volatile int g_downtimeout = 1;

/**
Flag used to reset the pause menu flags
*/
volatile int g_pausemenu = 0;

/**
Flag used when a new peice needs placing at the top of the screen
*/
volatile int g_newpiece = 1;
/**
Flag used when a piece is being hard dropped
*/
volatile int harddropping = 0;

/**
Flag used to start pause menu
*/
volatile int pauseleft = 0;

/**
Flag used to start pause menu
*/

volatile int pauseright = 0;
                        
#endif                        