/** 

@file Tetris.cpp

@brief Library containing all the functions for the game tetris

*/

#include "Tetris.h"

N5110 screen (PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);
int tetrominoe[7][4] = {{0x00F0,0x4444,0x0F00,0x2222},{0x0071,0x0226,0x0470,0x0322},{0x0074,0x0622,0x0170,0x0223},{0x0033,0x0033,0x0033,0x0033},{0x0072,0x0262,0x0270,0x0232},{0x0036,0x0462,0x0360,0x0231},{0x0063,0x0264,0x0630,0x0132}};

Tetris::Tetris()
{
}

void Tetris::gameSetup()
{

    //prints the starting game info on the screen
    screen.printString("Level:",0,0);
    screen.printString("Score:",0,2);
    screen.printString("0",0,1);
    screen.printString("Next",0,4);


    //creats the game boarder
    screen.drawRect(40,0,33,47,0);
    screen.drawRect(41,1,31,46,0);
    screen.refresh();


}

void Tetris::gameInfo(int score,int level,int next)
{
    //outputs the level
    char buffer[6];
    int length = sprintf(buffer,"%d",level);
    if(length <=6) {
        screen.printString("      ",0,1);
        screen.printString(buffer,0,1);
    }
    //outputs the score
    length = sprintf(buffer,"%d",score);
    if(length <=6) {
        screen.printString("      ",0,3);
        screen.printString(buffer,0,3);
    }

    for(int i = 0; i <4; i++) { //clears the next piece shape before the new one is displayed
        for(int j = 0; j <2; j++) {
            clearGamePixel(-6+i,12+j);
        }
    }
    piecePlace(-6,12,tetrominoe[next][0]); //places the next piece in the next piece position
}

void Tetris::gamePixel(int x, int y)
{
    screen.drawRect(42+(3*x),2+(3*y),2,2,1); //draws a 3x3 square on the screen relative to the game area
    screen.refresh();
}

void Tetris::clearGamePixel(int x, int y)
{
    for(int i =0; i<3; i++) {
        for(int j =0; j<3; j++) {
            screen.clearPixel(42+(x*3)+i,2+(3*y)+j); //clears a 3x3 sqaure relative to the game area
        }
    }
    screen.refresh();
}

void Tetris::clearGame()
{
    for(int i = 0; i<30; i++) {
        for(int j = 0; j<45; j++) {
            screen.clearPixel(42+i,2+j);
        }
    }
    screen.refresh();
}

void Tetris::piecePlace(int x,int y,int shape)
{
    int count = 0; //converts the hex value into seperate bits
    for(int i = 0; i<4; i++) {
        for(int j = 0; j<4; j++) {

            int bit = shape & (1<<count); 

            if (bit) { //prints each 1 bit
                gamePixel(j+x,i+y);
            }
            count++;
        }
    }
}

void Tetris::pieceClear(int x,int y,int shape)
{
    int count = 0; //converts the hex value into seperate bits
    for(int i = 0; i<4; i++) {
        for(int j = 0; j<4; j++) {

            int bit = shape & (1<<count);

            if (bit) {
                clearGamePixel(j+x,i+y); //clears each bit
            }
            count++;
        }
    }
}