/**
@file Tetris.h

@brief V 1.0 - initial release

*/

#ifndef Tetris_H //header guards to stop the library from being included more than once
#define Tetris_H

#include "mbed.h"
#include "N5110.h"

/**
@brief Library created to interact with the game area for Tertis on a N5110 screen

@brief Version - 1.0

@author Joseph Allison
@date   April 2016
*/


class Tetris{

public:

    /**Create Tetris instance
    */
    Tetris();
        
    /** Game Setup
    @brief Creates the game area boarder and writes the Level, score and next text
    */
    void gameSetup();
    
    /**
    Outputs the score, level and next piece onto the left side of the screen
    */
    void gameInfo(int score,int level,int next);
    
    /**
    Clears the game area
    */
    void clearGame();
    
    /**
    Places a game piece on the screen
    @param x - cells horizontal position
    @param y - cells vertical position
    @param shape - the shape that is being placed
    */
    void piecePlace(int x,int y,int shape);
    /**
    Clears a game piece on the screen
    @param x - cells horizontal position
    @param y - cells vertical position
    @param shape - the shape that is being cleared
    */
    void pieceClear(int x,int y,int shape);
    
    /**
    Sets a 3x3  sets a pixel cell in the game area at position (x,y)
    @param x - cells horizontal position
    @param y - cells vertical position
    */
    void gamePixel(int x,int y);
private:

    /**
    Sets a 3x3  clears a pixel cell in the game area at position (x,y)
    @param x - cells horizontal position
    @param y - cells vertical position
    */
    void clearGamePixel(int x, int y);
    
public:


private:


};

#endif