#include "mbed.h"
#include "Patterns.h"
#include "N5110.h"
#include "SDFileSystem.h"
#include "Joystick.h"
#include "Game.h"
#include "main.h"

int main()
{
    init();
    while(1) {
        if(g_menuTimer_flag) {
            g_menuTimer_flag=0;

            if (g_button_flag) {// if button pressed, go to next menu according current state and pointer position input
                g_button_flag=0;
                state=fsm[state].nextState[pointer_position];
                lcd.clear();
            }

            switch(state) {
                case 0: // main menu
                    pointer();
                    red_led=0;
                    green_led=0;
                    lcd.printString("Tetis Game",10,1);
                    lcd.printString("START",25,3);
                    lcd.printString("SCORE",25,4);
                    lcd.refresh();
                    break;
                case 1: // game level choosing menu
                    pointer();
                    red_led=0;
                    green_led=0;
                    lcd.printString("Game Level",10,1);
                    lcd.printString("EASY",25,3);
                    lcd.printString("HARD",25,4);
                    lcd.printString("Back",60,5);
                    lcd.refresh();
                    break;
                case 2: // highest score menu
                    red_led=0;
                    green_led=0;
                    lcd.printString("Highest Score:",1,1);
                    int top_score;
                    top_score=read_score_SD();
                    char score[14];
                    sprintf(score,"%d",top_score);
                    lcd.printString(score,30,3);
                    lcd.printString("Press Button",0,4);
                    lcd.printString("To Exit",0,5);
                    lcd.refresh();
                    break;
                case 3: // easy game menu
                    init_game();
                    game.attach(&game_isr,0.2);
                    lcd.printString("easy",42,1);
                    tetis_game();
                    break;
                case 4: // hard game menu
                    init_game();
                    game.attach(&game_isr,0.1);
                    lcd.printString("hard",42,1);
                    tetis_game();
                    break;
            }
        }
        sleep();
    }
}
