#include "main.h"


 
int main()
{
    
    lcd.init();
    button.mode(PullDown);
    calibrateJoystick();  // get centred values of joystick
    pollJoystick.attach(&updateJoystick,1.0/10.0);  // read joystick 10 times per second
 
 
    while(opentimes<24)//a simple opening animation for the game
    {
      lcd.drawCircle(42,24,100,1);
      lcd.drawCircle(42,24,r2,2);
      r2=r2+2;
      opentimes++;
      lcd.refresh();
      wait(0.5);
      lcd.clear();
      }

     
     
               
 
    while(1) {
            //Drawing the targets
            lcd.drawRect(x5,y5,10,10,colour);
            lcd.drawLine(x5+5,y5+10,x5+5,y5+20,1);
            lcd.drawRect(x6,y6,10,10,colour1);
            lcd.drawLine(x6+5,y6+10,x6+5,y6+20,1);
            lcd.drawRect(x7,y7,10,10,colour2);
            lcd.drawLine(x7+5,y7+10,x7+5,y7+20,1);
            lcd.drawRect(x8,y8,10,10,colour3);
            lcd.drawLine(x8+5,y8+10,x8+5,y8+20,1);
            
            //Drawing the crosshair
            lcd.drawLine(x1,y1,x2,y2,1);
            lcd.drawLine(x3,y3,x4,y4,1);
            
            //Drawing the Progressbar which shows how much movements player can do
            lcd.drawRect(0,0,moves,4,1);
            lcd.refresh();
            
        if (printFlag) {  // if flag set, clear flag and print joystick values to serial port
            printFlag = 0;
            serial.printf("x = %f y = %f button = %d ",joystick.x,joystick.y,joystick.button);
            
            
            if (joystick.direction == UP) //When the joystick is moved up
            {
            //Drawing white line to cancel the old crosshair
            lcd.drawLine(x1,y1,x2,y2,2);
            lcd.drawLine(x3,y3,x4,y4,2);
            y1++;
            y3++;
            y2++;
            y4++;
            
            moves++;//Progress bar value added
            
            //Drawing the new crosshair
            lcd.drawLine(x1,y1,x2,y2,1);
            lcd.drawLine(x3,y3,x4,y4,1);
            lcd.refresh();
            lcd.clear();
            }
                
            if (joystick.direction == DOWN)//When the joystick is moved down
            {
            //Drawing white line to cancel the old crosshair
            lcd.drawLine(x1,y1,x2,y2,2);
            lcd.drawLine(x3,y3,x4,y4,2);
            y1--;
            y3--;
            y2--;
            y4--;
            
            moves++;//Progress bar value added
            
            //Drawing the new crosshair
            lcd.drawLine(x1,y1,x2,y2,1);
            lcd.drawLine(x3,y3,x4,y4,1);
            lcd.refresh();
            lcd.clear();
            }
            
            if (joystick.direction == LEFT)//When the joystick is moved left
            {
            //Drawing white line to cancel the old crosshair
            lcd.drawLine(x1,y1,x2,y2,2);
            lcd.drawLine(x3,y3,x4,y4,2);
            x1--;
            x3--;
            x2--;
            x4--;
            
            moves++;//Progress bar value added
            
            //Drawing the new crosshair
            lcd.drawLine(x1,y1,x2,y2,1);
            lcd.drawLine(x3,y3,x4,y4,1);
            lcd.refresh();
            lcd.clear();
            }
            
            if (joystick.direction == RIGHT)//When the joystick is moved right
            {
            //Drawing white line to cancel the old crosshair
            lcd.drawLine(x1,y1,x2,y2,2);
            lcd.drawLine(x3,y3,x4,y4,2);
            x1++;
            x3++;
            x2++;
            x4++;
            
            moves++;//Progress bar value added
            
            //Drawing the new crosshair
            lcd.drawLine(x1,y1,x2,y2,1);
            lcd.drawLine(x3,y3,x4,y4,1);
            lcd.refresh();
            lcd.clear();
            }
            
            if(button)//if button is pressed
            {
            
            //judging whether the crosshair is in the targets' area   
            if ((10<x1)&&(x1<20)&&(20<y3)&&(y3<30))
            {
                lcd.clear();
                colour=2;    
                lcd.drawRect(x5,y5,10,10,colour);
            }
                
            if ((x6<x1)&&(x1<(x6+10))&&(y6<y3)&&(y3<(y6+10)))
            {
                lcd.clear();
                colour1=2;    
                lcd.drawRect(x6,y6,10,10,colour1);
            }
            
            if ((x7<x1)&&(x1<(x7+10))&&(y7<y3)&&(y3<(y7+10)))
            {
                lcd.clear();
                colour2=2;    
                lcd.drawRect(x6,y6,10,10,colour2);
            }
            
             if ((x8<x1)&&(x1<(x8+10))&&(y8<y3)&&(y3<(y8+10)))
            {
                lcd.clear();
                colour3=2;    
                lcd.drawRect(x8,y8,10,10,colour3);
            }
            }
            
            //judging whether all the targets are shot
            if ((colour==2)&&(colour1==2)&&(colour2==2)&&(colour3==2))
            {
              
              lcd.printString("YOU WIN",0,0);
              
              break;    
              }
              
            //juding whether the progress bar has arrive the end  
            if (moves==90)
            {
              lcd.printString("YOU LOSE",0,0);
              
              break;    
              }
            
            
        }
 
    }
    
    
}
 
// read default positions of the joystick to calibrate later readings
void calibrateJoystick()
{
    button.mode(PullDown);
    // must not move during calibration
    joystick.x0 = xPot;  // initial positions in the range 0.0 to 1.0 (0.5 if centred exactly)
    joystick.y0 = yPot;
}
void updateJoystick()
{
    // read current joystick values relative to calibrated values (in range -0.5 to 0.5, 0.0 is centred)
    joystick.x = xPot - joystick.x0;
    joystick.y = yPot - joystick.y0;
    // read button state
    joystick.button = button;
 
    // calculate direction depending on x,y values
    // tolerance allows a little lee-way in case joystick not exactly in the stated direction
    if ( fabs(joystick.y) < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = CENTRE;
    } else if ( joystick.y > DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = UP;
    } else if ( joystick.y < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = DOWN;
    } else if ( joystick.x > DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = RIGHT;
    } else if ( joystick.x < DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = LEFT;
    } else {
        joystick.direction = UNKNOWN;
    }
 
    // set flag for printing
    printFlag = 1;
}