/**
@file main.h
@brief Header file containing functions
@brief Revision 1.0
@author Yang Chen
@date May 2016
*/
#define DIRECTION_TOLERANCE 0.05

#include "mbed.h"
#include "N5110.h"




/**    
@namespace N5110_lcd
@brief lcd display
*/
N5110 lcd (PTE26 , PTA0 , PTC4 , PTD0, PTD2 , PTD1 , PTC3);


 
/**    
@namespace joystick
@brief input for joystick
*/
DigitalIn button(PTB18);
AnalogIn xPot(PTB2);
AnalogIn yPot(PTB3);
 
/** 
@namespace pollJoystick
@timer to regularly read the joystick
*/
Ticker pollJoystick;

/**
@namespace Serial_serial
@Serial for debug
*/
Serial serial(USBTX,USBRX);
 
/**
@namespace DirectionName
@create enumerated type (0,1,2,3 etc. for direction)
*/
enum DirectionName {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    CENTRE,
    UNKNOWN
};
 
/**
@namespace JoyStick_Joystick
@struct for Joystick
*/
typedef struct JoyStick Joystick;
struct JoyStick {
    float x;                  /*!< current x value */
    float x0;                 /*!< 'centred' x value */
    float y;                  /*!<  current y value */
    float y0;                 /*!<  'centred' y value */
    int button;               /*!<  button state (assume pull-down used, so 1 = pressed, 0 = unpressed) */
    DirectionName direction;  /*!<  current direction */
};
/**
@namespace Joystick_joystick
@create struct variable
*/
Joystick joystick;
 

/**
@namespace calibratejoystick
@namespace updateJoystick
@function prototypes
*/
void calibrateJoystick();
void updateJoystick();




int printFlag = 0;
int x1=42;       /*!< x value of the start point to draw the line1 of the crosshair */
int y1=19;       /*!< y value of the start point to draw the line1 of the crosshair */
int x2=42;       /*!< x value of the end point to draw the line1 of the crosshair */
int y2=29;       /*!< y value of the end point to draw the line1 of the crosshair */
int x3=37;       /*!< x value of the start point to draw the line2 of the crosshair */
int y3=24;       /*!< y value of the start point to draw the line2 of the crosshair */
int x4=47;       /*!< x value of the end point to draw the line2 of the crosshair */
int y4=24;       /*!< y value of the end point to draw the line2 of the crosshair */
int x5=10;       /*!< x value for target 1 */
int y5=20;       /*!< y value for target 1 */
int x6=40;       /*!< x value for target 2 */
int y6=30;       /*!< y value for target 2 */
int x7=30;       /*!< x value for target 3 */
int y7=10;       /*!< y value for target 3 */
int x8=60;       /*!< x value for target 4 */
int y8=15;       /*!< y value for target 4 */
int opentimes=0; /*!< the  value to draw a circle in the opening animation */
int r2=2;        /*!< the  value of radius to darw the circle in the opening animation */
int colour=0;    /*!< the  value of clour of the target1 */
int colour1=0;   /*!< the  value of clour of the target1 */
int colour2=0;   /*!< the  value of clour of the target1 */
int colour3=0;   /*!< the  value of clour of the target1 */
int moves=0;     /*!< the value of the progress bar */