/** Temperature Sensor Functions
@file TMP102.cpp
@brief help sensor
@author Craig Evans
@date April2016
*/
#include "TMP102.h"

// we now implement each of the methods listed in the header

// note the TMP102:: at the beginning of the method name
TMP102::TMP102(PinName sda, PinName scl)
{
    // in the constructor, we create the mbed API objects using 'new'
    i2c_ = new I2C(sda,scl);
    led_ = new DigitalOut(LED_RED);
}

void TMP102::init()
{
    i2c_->frequency(400000); // set bus speed to 400 kHz

    int ack;  // used to store acknowledgement bit
    char config_data[2];  // array for data
    char reg = CONFIG_REG;  // register address

    //////// Read current status of configuration register ///////

    ack = i2c_->write(TMP102_W_ADD,&reg,1);  // send the slave write address and the configuration register address
    if (ack)
        error();  // if we don't receive acknowledgement, flash error message

    ack = i2c_->read(TMP102_R_ADD,config_data,2);  // read default 2 bytes from configuration register and store in array
    if (ack)
        error();  // if we don't receive acknowledgement, flash error message

    ///////// Configure the register //////////

    // set conversion rate to 1 Hz - CR1 and CR2 are in the second data byte
    config_data[1] |= (1 << 6);    // set bit 6
    config_data[1] &= ~(1 << 7);    // clear bit 7

    //////// Send the configured register value to the slave config register ////////////

    // create data packet
    char data_packet[3] = {reg,config_data[0],config_data[1]};

    ack = i2c_->write(TMP102_W_ADD,data_packet,3);  // send the data packet to the slave write address
    if (ack)
        error();  // if we don't receive acknowledgement, flash error message

}

void TMP102::read_temperature()
{
    int ack;  // used to store acknowledgement bit
    char data[2];  // array for data
    char reg = TEMP_REG;  // temperature register address

    ack = i2c_->write(TMP102_W_ADD,&reg,1);  // send temperature register address
    if (ack)
        error();  // if we don't receive acknowledgement, flash error message

    ack = i2c_->read(TMP102_R_ADD,data,2);  // read 2 bytes from temperature register and store in array
    if (ack)
        error();  // if we don't receive acknowledgement, flash error message

    int temperature = (data[0] << 4) | (data[1] >> 4);

    temperature_ = temperature*0.0625F;
}

// temperature accessor method
float TMP102::get_temperature() 
{
    read_temperature();
    return temperature_;    
}

void TMP102::error()
{
    while(1) {  // if error, hang while flashing error message
        led_->write(0);
        wait(0.2);
        led_->write(1);
        wait(0.2);
    }
}