/**
@file main.h
@brief Header file containing functions prototypes, defines and global variables.
@brief Shows examples of creating Doxygen documentation.
@brief Revision 1.0.
@author XIN ZHANG
@date   May 2016
*/

#ifndef MAIN_H
#define MAIN_H


#include "mbed.h"
#include "N5110.h"
#include "SRF02.h"

/**
@namespace lcd
@brief lcd connections
*/
N5110 lcd (PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);
/**namespace sensor
@brief sensor connections
*/
SRF02 sensor(PTE25,PTE24);
Serial serial(USBTX, USBRX);
/**
@namespace r_led1
@brief r_led1 connections
*/
PwmOut r_led1(PTC2);
/**
@namespace r_led2
@brief r_led2 connections
*/
PwmOut r_led2(PTA1);
/**
@namespace buzzer
@brief buzzer connections
*/
PwmOut buzzer(PTA2);
/**
@namespace ticker
@brief make led flashes at 2HZ
*/
Ticker ticker;
/**
@namespace detect
@brief make sensor detect at 2HZ
*/
Ticker detect;

volatile int g_timer_flag = 0;    /*!<Flag in timer_isr */

volatile int g_detect_timer_flag = 0; /*!<Flag in detect-timer-isr */

/**
Setting LED flahses at 2 HZ
*/
void timer_isr();

/**
Setting sensor detect at 2 HZ
*/
void detect_isr();

/**
Drawing car at positon x and y
@param x - draw the car at positon x
@param y - draw the car at positon y
*/
void drawCar(int x,int y);

/**
Clear car at positon x and y
@param x - clear the car at positon x
@param y - clear the car at positon y
*/
void clearCar(int x,int y);


int xOld=0;                /*! < Save car  previous position */
int distanceArray[10];  /*!< Detect 10 times and add total distance in order to get mean vlaue */

#endif