
#include "main.h"

int main()
{
    int distance;
    int lcd_message;
    char distance_array [14];
    lcd.init();  // initialise display
    lcd.normalMode();      // normal colour mode
    lcd.setBrightness(1.0); // put LED backlight on 50%
    for (int i=0; i < 23; i++) {
        lcd.drawCircle(42,24,i,0);
        lcd.refresh();
        wait(0.2);
    }
    lcd.clear();
    lcd.printString("Welocme to",15,1);
    lcd.printString ("Sensor Project",2,3);
    lcd.printString("Xin Zhang",0,5);
    wait (2.0);
    lcd.clear();
    lcd.refresh();
    ticker.attach(&timer_isr,0.5); //2Hz   LED flash
    detect.attach(&detect_isr,0.5); //2HZ  Sensor detect 
    while(1) {

        if(g_detect_timer_flag == 1) {
            for(int i=0; i<=9; i++) {                     //Detect 10 times 
                distanceArray[i]=sensor.getDistanceCm(); // read sensor distance in cm and print over serial port
            }

            int sum=0;                                  // Make sensor to detect 10 times and add togther in order to get mean value
            for(int i=0; i<=9; i++) {
                sum=sum+distanceArray[i];
            }

            distance = sum/10;                          // Getting Mean vlaue

            lcd_message = sprintf(distance_array, "D = %d CM",distance);// short delay before next measurement

            lcd.printString(distance_array,5,1);

            int x;
            clearCar(xOld,40);
            if (distance >= 300) {                       // situation which distance is above 300
                x=2;
                xOld=2;
                drawCar(x,40);

                lcd.clearPixel(77,9);      //Delete symbol for exclamation mark
                lcd.clearPixel (77,10);
                lcd.clearPixel (77,11);
                lcd.clearPixel (77,12);
                lcd.clearPixel (77,13);
                lcd.clearPixel (77,15);

                lcd.clearPixel (79,9);
                lcd.clearPixel (79,10);
                lcd.clearPixel (79,11);
                lcd.clearPixel (79,12);
                lcd.clearPixel (79,13);
                lcd.clearPixel (79,15);

                lcd.clearPixel (75,9);
                lcd.clearPixel (75,10);
                lcd.clearPixel (75,11);
                lcd.clearPixel (75,12);
                lcd.clearPixel (75,13);
                lcd.clearPixel (75,15);

                buzzer.period(1.0/1000.0);      // buzzer cloesd
                buzzer=0.0;
                wait(0.2);

            } else if(distance < 300 && distance >16) {     // situation  which distance is from 16 to 300
                x = 68.0-(66.0/284 * distance);
                xOld = 68.0-(66.0/284 * distance);
                drawCar(x,40);

                lcd.clearPixel(77,9);
                lcd.clearPixel (77,10);
                lcd.clearPixel (77,11);
                lcd.clearPixel (77,12);
                lcd.clearPixel (77,13);
                lcd.clearPixel (77,15);

                lcd.clearPixel (79,9);
                lcd.clearPixel (79,10);
                lcd.clearPixel (79,11);
                lcd.clearPixel (79,12);
                lcd.clearPixel (79,13);
                lcd.clearPixel (79,15);

                lcd.clearPixel (75,9);
                lcd.clearPixel (75,10);
                lcd.clearPixel (75,11);
                lcd.clearPixel (75,12);
                lcd.clearPixel (75,13);
                lcd.clearPixel (75,15);

                buzzer.period(1.0/1000.0);    // buzzer closed
                buzzer=0.0;
                wait(0.2);


            } else {                                     // situation which distance is below 16 and
                x=67;
                xOld = 67;
                drawCar(x,40);

                lcd.setPixel(77,9);  // symbol for exclamation mark
                lcd.setPixel (77,10);
                lcd.setPixel (77,11);
                lcd.setPixel (77,12);
                lcd.setPixel (77,13);
                lcd.setPixel (77,15);

                lcd.setPixel (79,9);
                lcd.setPixel (79,10);
                lcd.setPixel (79,11);
                lcd.setPixel (79,12);
                lcd.setPixel (79,13);
                lcd.setPixel (79,15);

                lcd.setPixel (75,9);
                lcd.setPixel (75,10);
                lcd.setPixel (75,11);
                lcd.setPixel (75,12);
                lcd.setPixel (75,13);
                lcd.setPixel (75,15);

                buzzer.period(1.0/1000.0);    //buzzer up
                buzzer=0.5;
                wait(0.2);




            }
        }
        lcd.setPixel(82,43);   //Building walls
        lcd.setPixel(81,42);
        lcd.setPixel(80,41);
        lcd.setPixel(79,40);
        lcd.setPixel(78,39);
        lcd.setPixel(77,38);
        lcd.setPixel (77,37);
        lcd.setPixel(77,36);
        lcd.setPixel (77,35);
        lcd.setPixel (77,34);
        lcd.setPixel (77,33);
        lcd.setPixel (77,32);
        lcd.setPixel (77,31);
        lcd.setPixel (77,30);
        lcd.setPixel (77,29);
        lcd.setPixel (77,28);
        lcd.setPixel (78,28);
        lcd.setPixel (79,29);
        lcd.setPixel (80,30);
        lcd.setPixel (81,31);
        lcd.setPixel (82,32);

        if ( distance >=0 && distance <= 16) {   //When the distance is from 0 to 16, the two led will flash and show warining signal
            if(g_timer_flag == 1) {
                r_led1 = !r_led1;
                r_led2= !r_led2;
            }
        } else {                                //When the distance is above 16, the only one led flashs
            if(g_timer_flag == 1) {
                r_led1 = !r_led1;
                r_led2= 0;
            }
        }
        lcd.refresh();
        sleep();
    }
}

void timer_isr()
{
    g_timer_flag = 1;   // set flag in ISR
}

void detect_isr()
{
    g_detect_timer_flag = 1;
}

void drawCar(int x,int y)   //43
{
    lcd.setPixel(x,y);
    lcd.setPixel(x+1,y);
    lcd.setPixel(x+2,y);
    lcd.setPixel (x+3,y);
    lcd.setPixel (x+4,y);
    lcd.setPixel (x+5,y);
    lcd.setPixel (x+6,y);
    lcd.setPixel (x+7,y);
    lcd.setPixel (x+8,y);
    lcd.setPixel (x+9,y);
    lcd.setPixel (x+10,y);
    lcd.setPixel (x,y-1);
    lcd.setPixel (x+1,y-2);
    lcd.setPixel (x+2,y-3);
    lcd.setPixel (x+3,y-3);
    lcd.setPixel (x+4,y-3);
    lcd.setPixel (x+5,y-3);
    lcd.setPixel (x+6,y-3);
    lcd.setPixel (x+7,y-3);
    lcd.setPixel (x+9,y-1);
    lcd.setPixel (x+8,y-2);
    lcd.setPixel (x+10,y);
    lcd.drawCircle(x+2,y+2,1,1);
    lcd.drawCircle(x+7,y+2,1,1);

}

void clearCar(int x,int y)
{
    lcd.clearPixel(x,y);
    lcd.clearPixel(x+1,y);
    lcd.clearPixel(x+2,y);
    lcd.clearPixel (x+3,y);
    lcd.clearPixel (x+4,y);
    lcd.clearPixel (x+5,y);
    lcd.clearPixel (x+6,y);
    lcd.clearPixel (x+7,y);
    lcd.clearPixel (x+8,y);
    lcd.clearPixel (x+9,y);
    lcd.clearPixel (x+10,y);
    lcd.clearPixel (x,y-1);
    lcd.clearPixel (x+1,y-2);
    lcd.clearPixel (x+2,y-3);
    lcd.clearPixel (x+3,y-3);
    lcd.clearPixel (x+4,y-3);
    lcd.clearPixel (x+5,y-3);
    lcd.clearPixel (x+6,y-3);
    lcd.clearPixel (x+7,y-3);
    lcd.clearPixel (x+9,y-1);
    lcd.clearPixel (x+8,y-2);
    lcd.clearPixel (x+10,y);
    lcd.drawCircle(x+2,y+2,1,2);
    lcd.drawCircle(x+7,y+2,1,2);
}