/**
@file main.cpp
@brief Revision 1.0.
@author Robin Milward Cooney
@date   May 2015
*/

/* ELEC2645 Game - Shooty shooty bang bang (priliminary name)

Week 19 - initial version, basic testing of sensor and display

(c) Robni Milward Cooney Uniersity of Leeds, 06/03/16

*/

#include "main.h"

int main()                      //main function, currently used to test different functions
{
    initialize_values();        //Call the initialize_values funtion
    lcd.init();                 //Initialize the LCD
    b_A.mode(PullDown);         //Declare the Pull down state of the digital in b_A
    b_B.mode(PullDown);         //Declare the Pull down state of the digital in b_B
    swJoy.mode(PullDown);       //Declare the Pull down state of the digital in swJoy
    Ticker_Menu.attach(&Ticker_Menu_isr,0.15); //Set the ticker for menus to flag every 0.15 seconds
    Ticker_Game.attach(&Ticker_Game_isr,0.1);   //Set the ticker for the game to flag every 0.1 seconds
    Ticker_ds.attach(&Ticker_ds_isr,0.1);       //Set the ticker for the ticker_wait funtion to flag every 0.1 seconds
    press_b_A.fall(&press_b_A_isr);             //Set interrupt to flag when buttion A pressed
    press_b_A.mode(PullDown);                   // Declare that button A is pulldown
    press_b_B.fall(&press_b_B_isr);             //Set interrupt to flag when buttion B pressed
    press_b_B.mode(PullDown);                   // Declare that button A is pulldown
    calibrateJoystick();                        //Initialize the joystick, allocating a defalut possition for xJoy and yJoy
    intro();                                    //Prints the name of the game before the manin menu runs
    main_menu();                                //Funtion that runs the main menu, the game itself it called within the main_menu() funtion
}


// -----------------------------------------------------------------------------------------------------------------------------------------

// Funtion that initializes all values so when the game ends and is re_played all the variables are in there initial state
void initialize_values()
{

//the movements of all the interactive elements are arranged so they start off screen and as the value _movement values increases
//they begin to appear on screen
    rat_movement=85;
    hound_hMovement=90;
    hound_vMovement=40;
    hound_jump=0;
    bear_movement=100;
    bird_hMovement=95;
    bird_vMovement=20;
    cactus_movement=110;
    t_rex_movement=120;
    quick_sand_movement=85;
    fire_ball_hMovement=t_rex_movement-6;
    fire_ball_vMovement=25;
    heart_movement=90;
    ammo_movement=100;

//Thenu state is reset to 0 so that the first menu option is highlited when returned to the main menu
    menuState=0;

//All action flags are re-set to 0
    jump_flag=0;
    shoot_flag=0;
    shield_flag=0;
    hound_jump_flag=0;


//All print flags are set to 0
    print_rat_flag=0;
    print_hound_flag=0;
    print_bear_flag=0;
    print_bird_flag=0;
    print_heart_flag=0;
    print_ammo_flag=0;
    print_speed_boost_flag=0;
    print_cactus_flag=0;
    print_t_rex_flag=0;
    print_quick_sand_flag=0;
    print_fire_ball_flag=0;
    fire_on_screen=0;

//Score and relevant score variable are set to 0
    score=0;
    kill_score=0;
    shield_score=0;

//Other miscellaneous varaivles relevent to the game are set
    red_led = 1;
    green_led=1;
    i=0;
    g_shoot_loop=0;
    recks_movement=2;
    fall=37;
    g_jump=36;
    accel=0;
    bullet=9;
    h_movement=0;
    ammo=24;
    lose_lives_delay_flag=0;
    lives_delay_loop=0;
    lives=4;
    bear_lives=0;
    shield_counter=0;

}

//Funtion that uses a ticker to create a ticker based wait() funtion, less power consumtion then normal wait() funtion
//Input t in 0.1*number of seconds to wait
void ticker_wait(int t)
{
    for (int q=0; q<=t; q++) {      //for loop stops when q<=t
        if (g_Ticker_ds_flag) {     //ticker_ds_flag flags every 0.1seconds
            g_Ticker_ds_flag=0;
            q++;                    //q increases every loop until q=t
        }
        sleep();                    //puts mbed to sleep
    }
}

//Funtion that reads the story_progress variable form the SD card
void readSD_progress()
{
    Progress=fopen("/sd/Progress.txt", "r");       //Opens the file Progress.txt (read only)
    if (Progress!=NULL) {                           //If file exists
        green_led=0;                                //Turn green led on mbed on
        fscanf(Progress,"%d, ",&story_progress);    //Retrive the story_progress variable
        fclose(Progress);                           //Close the file Progress.txt
        ticker_wait(5);                             //wait 0.5s
        green_led=1;                                //Turn green led on mbed off
    } else {                                        //If flie doesn't exist
        red_led=0;                                  //Turn red led on mebed on
        ticker_wait(5);                             //wait 0.5s
        red_led=1;                                  //Turn red led on mebed off
    }
}

//Funtion that reads the story_progress variable on the SD card
void writeSD_progress()
{
    Progress=fopen("/sd/Progress.txt", "w");        //Opens the file Progress.txt (write)
    if (Progress!=NULL) {                           //If file exists
        green_led=0;                                //Turn green led on mbed on
        fprintf(Progress,"%d, ",story_progress);    //Write the story_progress variable to the file
        fclose(Progress);                           //Close the file Progress.txt
        ticker_wait(5);                             //wait 0.5s
        green_led=1;                                //Turn red led on mebed off
    } else {                                        //If the file doesn't exist
        red_led=0;                                  //Turn red led on mebed on
        ticker_wait(5);                             //wait 0.5s
        red_led=1;                                  //Turn red led on mebed off
    }
}

//Funtion that reads and prints the g_top_score[6] array on the SD card and prints the higest 5 values
//on the LCD
void readSD_and_print_top_score()
{
    Highscores=fopen("/sd/Highscores.txt", "r");    //Opens the file Highscores.txt (read only) from SD card
    if (Highscores!=NULL) {                         //If file exists
        green_led=0;                                //Turn green led on mbed on
        ticker_wait(3);                             //wait 0.3s
        green_led=1;                                //Turn green led on mbed oFF
        for (int j=0; j<=5; j++) {                  //Go through all the values of the array and reads them
            fscanf(Highscores,"%d, ",&g_top_scores[j]);
        }
        lcd.printString("Highscores:",0,0);         //Prints Highscores
        for (int j=1; j<=5; j++) {                  //Goes through the top 5 values
            char buffer[14];                        //Declares buffer to store the values of the g_top_score array
            int temp = sprintf(buffer,"%d",g_top_scores[j]);  //Stores them in the buffer
            lcd.printString(buffer,12,j);                     //Prints the values on the LCD screen in order
        }
        fclose(Highscores);                         //Close Highscores file
    } else {                                        //If the file doesn't exist
        red_led=0;                                  //Turn the red led on mbed off
        ticker_wait(3);                             //wait 0.3s
        red_led=1;                                  //Turn the red led on mebed off
        lcd.printString("NO HIGHSCORES",3,2);       //Print error message on LCD
        lcd.printString("SET YET!!",18,3);
    }
}


//Funtion that writes the highscore[6] array on the SD
void writeSD()
{
    Highscores=fopen("/sd/Highscores.txt", "w");    //Opens the file Highscores.txt (write only) from SD card
    if (Highscores!=NULL) {                         //If file exists
        green_led=0;                                //Turn green led on mbed on
        ticker_wait(3);                             //wait 0.3s
        green_led=1;                                //Turn green led on mbed off
        for (int j=0; j<=5; j++) {                  //Goes through the all values
            fprintf(Highscores,"%d, ",g_top_scores[j]); //Retrive the g_top_score array
        }
        fclose(Highscores);                          //Close file
    } else {                                        //If file doesn't exists
        red_led=0;                                  //Turns red led on
        ticker_wait(3);                             //Waits 0.3s
        red_led=1;                                  //Turns red led off
    }
}

//Funtion that deletes a file
void delete_file(char filename[])
{
    lcd.printString("Deleting file",0,1);   //print deleting file
    ticker_wait(5);         //wait 05s
    FILE *fp = fopen(filename, "r");  // try and open file
    if (fp != NULL) {  // if it does open...
        fclose(fp);    // close it
        remove(filename);  // and then delete
        lcd.printString("Done!",0,5);
        ticker_wait(10);
    }
    // if we can't open it, it doesn't exist and so we can't delete it
    lcd.refresh();
}

void Delete_Highscores()
{
    lcd.clear();      //Clear all the pixels on the LCD screen
    while (1) {
        if (g_Ticker_Menu_flag) {       //ticker flags every 0.15s
            g_Ticker_Menu_flag=0;
            lcd.printString("Delete all",0,2);
            lcd.printString("high scores?",0,3);
            if (b_A==1) {              //if dlete highscores is selected
                lcd.clear();          //Clear all the pixels on the LCD screen
                while (1) {
                    if (g_Ticker_Menu_flag) {
                        g_Ticker_Menu_flag=0;
                        lcd.printString("Are you sure?",0,1);   //Print are you sure message
                        if (b_A==1) {           //Are you sure is selected
                            lcd.clear();        //Clear all the pixels on the LCD screen
                            delete_file("/sd/Highscores.txt");      //deletes the file
                            return;
                        } else if (b_B==1) {        //If it's not, returns to the main menu
                            return;
                        }
                    }
                    lcd.refresh();
                    sleep();                    //puts mbed to sleep
                }
            } else if (b_B==1) {         //If it's not, returns to the main menu
                return;
            }
        }
        lcd.refresh();
        sleep();                    //puts mbed to sleep
    }
}

//Sorts all the top scores in descending order
void sort_top_scores()
{
    g_top_scores[5]=score;      //The 5 element is equal to the score
    int temp;
    for (int j=0; j<=5; j++) {      //for each array element
        for (int n=1; n<=5; n++) {  //for each array element+1 (except for when the array element=5 as there is no further one)
            if (g_top_scores[j]>g_top_scores[n]) {      //if array element is greater then the next element
                temp = g_top_scores[j];                 //store the element
                g_top_scores[j] = g_top_scores[n];      //make the element equal to the next element
                g_top_scores[n] = temp;                 //stores element equals the nest elememnt
            }
        }
    }
}


//Funtion that plays the song1
void play_music()
{
    tOut.attach(&music_tOut, (song1[0]/2)); //the note will play for the the ammount of time specified in the first
    //element of the song1
    PWM.period (1.0/1000);                  //sets the frequancy to 1kHz
    PWM.write(0.0);                         //Changes the time that the buzzer is on to 0
    if (song1[g_music_count]!=0) {           //Checks if there is a note to be played at a ceratain position in the song1 array
        PWM.period(1/(song1[g_music_count]));   //Sets the period to the corret frequency from the song array
        PWM.write(0.5);                         //Changes PWM to square wave
    }
    if (g_music_count<(sizeof(song1)/sizeof(song1[1]))) {   //If the current count of the music is less then the array size
        g_music_count++;        //increases the music line by one
    } else {
        g_music_count=1;        //otherwise it sets it back to one
    }
}


//Generates a random number between 0 and 9999
void generate_random_number()
{
    time_t seconds = time(NULL);        //Get time in seconds from mbed
    srand(seconds);                     //Use time as soucre for srand() funtion
    random_num=rand()%10000;            //create random number between 1 and 9999
}

//Converts the socre value so it can be dysplayed as a bar
void led_bar()
{
    led=pow(2,lives)-1; //lives^2 -1 will turn all the led on thats the value of lives
    if (lives>5) {      //the value of lives cannot exceed 5
        lives=5;
    }
}


void ground()                       //funtion to print the ground
{
    for (int x = 0; x<=84 ; x++) {
        lcd.setPixel(x,47);         //prints a line 84 pixels long at the bottom of the screen
    }
}

/*
==========================EXAMPLE OF PRINTING FUNTION===========================

THIS EXAMPLE CODE APPLIES FOR ALL THE "print_" FUNTIONS

//Prints the item on the LCD screen
void print_item()
{
    //Goes through all the columns in the g_item array
    for (int c=0; c<=(1-g_item number of columns in array); c++) {
        //Goes through all the rows in the g_item array
        for (int r=0; r<=(1-g_item number of rows in array);r++) {
            //if the element of the g_item array corresponding to row r and column c is o
            if (g_item[r][c]==0) {
            // then the pixel is checked, this is to allow arrays to overlap. If the checked pixel = 1
            //then the pixel is set rather then cleared, however if it's 0 then it is cleared
            //the location on the LCD that the item is printed is dependant on the 2 global variables
            //item_hMovement (contolles the horizontal possition) and item_vMovement (contolles the
            //vertical movemrnt). If either of those values are constants it means that the
            //vertical/horizontal displacement of the object is constant
                if (lcd.getPixel(c+item_hMovement,r+item_vMovement)!=0) {
                    lcd.setPixel(c+item_hMovement,r+item_vMovement);
                } else {
                    lcd.clearPixel(c+item_hMovement,r+item_vMovement);
                }
            //else if the array element g_item[r][c] is 1 then the pixel is set no matter what
            } else if (g_item[r][c]==1) {
                lcd.setPixel(c+item_hMovement,r+item_vMovement);
            }
        }
    }
}
================================================================================
*/

//Funtion that prints the heart pickup
void print_heart()
{
    for(int c=0; c<=4; c++) { //4 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=4; r++) {
            if (g_heart[r][c]==0) {
                if (lcd.getPixel(c+heart_movement,r+35)!=0) {
                    lcd.setPixel(c+heart_movement,r+35);
                } else {
                    lcd.clearPixel(c+heart_movement,r+35);
                }
            } else if (g_heart[r][c]==1) {
                lcd.setPixel(c+heart_movement,r+35);
            }
        }
    }
}

//Funtion that prints the ammo pickup
void print_ammo_pickUp()
{
    for(int c=0; c<=6; c++) { //6 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=7; r++) {
            if (g_ammo_pickUp[r][c]==0) {
                if (lcd.getPixel(c+ammo_movement,r+35)!=0) {
                    lcd.setPixel(c+ammo_movement,r+35);
                } else {
                    lcd.clearPixel(c+ammo_movement,r+35);
                }
            } else if (g_ammo_pickUp[r][c]==1) {
                lcd.setPixel(c+ammo_movement,r+35);
            }
        }
    }
}

//Funtion that prints the speed boost pickup
void print_speed_boost()
{
    for (int c=0; c<=13; c++) {
        for (int r=0; r<=6; r++) {
            if (g_speed_boost[r][c]==0) {
                if (lcd.getPixel(c+speed_boost_movement,r+38)!=0) {
                    lcd.setPixel(c+speed_boost_movement,r+38);
                } else {
                    lcd.clearPixel(c+speed_boost_movement,r+38);
                }
            } else if (g_speed_boost[r][c]==1) {
                lcd.setPixel(c+speed_boost_movement,r+38);
            }
        }
    }
}
//Funtion that prints recks still
void print_recks_still_gun()
{

    for(int c=0; c<=9; c++) { //9 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=9; r++) {
            if (g_recks_still_gun[r][c]==0) {
                if (lcd.getPixel(c+3,r+37)!=0) {
                    lcd.setPixel(c+3,r+37);
                } else {
                    lcd.clearPixel(c+3,r+37);
                }
            } else if (g_recks_still_gun[r][c]==1) {
                lcd.setPixel(c+3,r+37);
            }
        }
    }
}

//Funtion that prints recks moveing
void print_recks_moving_gun()
{

    for(int c=0; c<=9; c++) { //9 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=9; r++) {
            if (g_recks_moving_gun[r][c]==0) {
                if (lcd.getPixel(c+3,r+37)!=0) {
                    lcd.setPixel(c+3,r+37);
                } else {
                    lcd.clearPixel(c+3,r+37);
                }
            } else if (g_recks_moving_gun[r][c]==1) {
                lcd.setPixel(c+3,r+37);
            }
        }
    }
}

//Funtion that prints recks crouching
void print_recks_crouch_gun()
{
    for(int c=0; c<=9; c++) { //9 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=9; r++) {
            if (g_recks_crouch_gun[r][c]==0) {
                if (lcd.getPixel(c+3,r+37)!=0) {
                    lcd.setPixel(c+3,r+37);
                } else {
                    lcd.clearPixel(c+3,r+37);
                }
            } else if (g_recks_crouch_gun[r][c]==1) {
                lcd.setPixel(c+3,r+37);
            }
        }
    }
}

//Funtion that prints recks with the shield
void print_recks_shield()
{
    for(int c=0; c<=14; c++) {
        for(int r=0; r<=14; r++) {
            if (g_recks_shield[r][c]==0) {
                if (lcd.getPixel(c,r+33)!=0) {
                    lcd.setPixel(c,r+33);
                } else {
                    lcd.clearPixel(c,r+33);
                }
            } else if (g_recks_shield[r][c]==1) {
                lcd.setPixel(c,r+33);
            }
        }
    }
}

//Funtion that prints recks in the jumping position
void print_recks_jump_gun()
{
    for(int c=0; c<=9; c++) { //9 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=9; r++) {
            if (g_recks_jump_gun[r][c]==0) {
                if (lcd.getPixel(c+3,r+g_jump)!=0) {
                    lcd.setPixel(c+3,r+g_jump);
                } else {
                    lcd.clearPixel(c+3,r+g_jump);
                }
            } else if (g_recks_jump_gun[r][c]==1) {
                lcd.setPixel(c+3,r+g_jump);
            }
        }
    }
}

//Funtion that recks falling (different to recks still because vertical movement is variable)
void print_recks_falling()
{
    for(int c=0; c<=9; c++) { //9 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=9; r++) {
            if (g_recks_still_gun[r][c]==0) {
                if (lcd.getPixel(c+3,r+fall)!=0) {
                    lcd.setPixel(c+3,r+fall);
                } else {
                    lcd.clearPixel(c+3,r+fall);
                }
            } else if (g_recks_still_gun[r][c]==1) {
                lcd.setPixel(c+3,r+fall);
            }
        }
    }
}

//Funtion that prints the rat in position 1
void print_mob_rat_p1()
{
    for(int c=0; c<=7; c++) { // 7 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=2; r++) {
            if (g_mob_rat_p1[r][c]==0) {
                if (lcd.getPixel(c+rat_movement,r+44)!=0) {
                    lcd.setPixel(c+rat_movement,r+44);
                } else {
                    lcd.clearPixel(c+rat_movement,r+44);
                }
            } else if (g_mob_rat_p1[r][c]==1) {
                lcd.setPixel(c+rat_movement,r+44);
            }
        }
    }
}

//Funtion that prints the rat in position 2
void print_mob_rat_p2()
{
    for(int c=0; c<=7; c++) { // 7 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=2; r++) {
            if (g_mob_rat_p2[r][c]==0) {
                if (lcd.getPixel(c+rat_movement,r+44)!=0) {
                    lcd.setPixel(c+rat_movement,r+44);
                } else {
                    lcd.clearPixel(c+rat_movement,r+44);
                }
            } else if (g_mob_rat_p2[r][c]==1) {
                lcd.setPixel(c+rat_movement,r+44);
            }
        }
    }
}

//Funtion that prints the still hound
void print_mob_hound_p1()
{
    for(int c=0; c<=12; c++) { // 12 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=7; r++) {
            if (g_mob_hound_p1[r][c]==0) {
                if (lcd.getPixel(c+hound_hMovement,r+hound_vMovement)!=0) {
                    lcd.setPixel(c+hound_hMovement,r+hound_vMovement);
                } else {
                    lcd.clearPixel(c+hound_hMovement,r+hound_vMovement);
                }
            } else if (g_mob_hound_p1[r][c]==1) {
                lcd.setPixel(c+hound_hMovement,r+hound_vMovement);
            }
        }
    }
}

//Funtion that prints the moving hound
void print_mob_hound_p2()
{
    for(int c=0; c<=12; c++) { // 12 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=7; r++) {
            if (g_mob_hound_p2[r][c]==0) {
                if (lcd.getPixel(c+hound_hMovement,r+hound_vMovement)!=0) {
                    lcd.setPixel(c+hound_hMovement,r+hound_vMovement);
                } else {
                    lcd.clearPixel(c+hound_hMovement,r+hound_vMovement);
                }
            } else if (g_mob_hound_p2[r][c]==1) {
                lcd.setPixel(c+hound_hMovement,r+hound_vMovement);
            }
        }
    }
}

//Funtion that prints the dead hound
void print_mob_hound_dead()
{
    for(int c=0; c<=12; c++) { // 12 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=7; r++) {
            if (g_mob_hound_dead[r][c]==0) {
                if (lcd.getPixel(c+hound_hMovement,r+hound_vMovement)!=0) {
                    lcd.setPixel(c+hound_hMovement,r+hound_vMovement);
                } else {
                    lcd.clearPixel(c+hound_hMovement,r+hound_vMovement);
                }
            } else if (g_mob_hound_dead[r][c]==1) {
                lcd.setPixel(c+hound_hMovement,r+hound_vMovement);
            }
        }
    }
}

//Funtion to print the still bear (position 1) on the LCD
void print_mob_bear_p1()
{
    for(int c=0; c<=18; c++) { //18 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=9; r++) {
            if (g_mob_bear_p1[r][c]==0) {
                if (lcd.getPixel(c+bear_movement,r+37)!=0) {
                    lcd.setPixel(c+bear_movement,r+37);
                } else {
                    lcd.clearPixel(c+bear_movement,r+37);
                }
            } else if (g_mob_bear_p1[r][c]==1) {
                lcd.setPixel(c+bear_movement,r+37);
            }
        }
    }
}

//Funtion to print the moving bear (position 2) on the LCD
void print_mob_bear_p2()
{
    for(int c=0; c<=18; c++) { //18 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=9; r++) {
            if (g_mob_bear_p2[r][c]==0) {
                if (lcd.getPixel(c+bear_movement,r+37)!=0) {
                    lcd.setPixel(c+bear_movement,r+37);
                } else {
                    lcd.clearPixel(c+bear_movement,r+37);
                }
            } else if (g_mob_bear_p2[r][c]==1) {
                lcd.setPixel(c+bear_movement,r+37);
            }
        }
    }
}

//Funtion to print the dead bear
void print_mob_bear_dead()
{
    for(int c=0; c<=18; c++) { //18 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=9; r++) {
            if (g_mob_bear_dead[r][c]==0) {
                if (lcd.getPixel(c+bear_movement,r+37)!=0) {
                    lcd.setPixel(c+bear_movement,r+37);
                } else {
                    lcd.clearPixel(c+bear_movement,r+37);
                }
            } else if (g_mob_bear_dead[r][c]==1) {
                lcd.setPixel(c+bear_movement,r+37);
            }
        }
    }
}

//Funtion to print the moving (position 1) bird on the LCD
void print_mob_bird_p1()
{
    for(int c=0; c<=9; c++) { //9 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=9; r++) {
            if (g_mob_bird_p1[r][c]==0) {
                if (lcd.getPixel(c+bird_hMovement,r+bird_vMovement)!=0) {
                    lcd.setPixel(c+bird_hMovement,r+bird_vMovement);
                } else {
                    lcd.clearPixel(c+bird_hMovement,r+bird_vMovement);
                }
            } else if (g_mob_bird_p1[r][c]==1) {
                lcd.setPixel(c+bird_hMovement,r+bird_vMovement);
            }
        }
    }
}

//Funtion to print the moving (position 2) bird on the LCD
void print_mob_bird_p2()
{
    for(int c=0; c<=9; c++) { //9 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=9; r++) {
            if (g_mob_bird_p2[r][c]==0) {
                if (lcd.getPixel(c+bird_hMovement,r+bird_vMovement)!=0) {
                    lcd.setPixel(c+bird_hMovement,r+bird_vMovement);
                } else {
                    lcd.clearPixel(c+bird_hMovement,r+bird_vMovement);
                }
            } else if (g_mob_bird_p2[r][c]==1) {
                lcd.setPixel(c+bird_hMovement,r+bird_vMovement);
            }
        }
    }
}

//Funtion to print the dead bird on the LCD
void print_mob_bird_dead()
{
    for(int c=0; c<=9; c++) { //9 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=9; r++) {
            if (g_mob_bird_dead[r][c]==0) {
                lcd.clearPixel(c+bird_hMovement,r+bird_vMovement);
            } else if (g_mob_bird_dead[r][c]==1) {
                lcd.setPixel(c+bird_hMovement,r+bird_vMovement);
            }
        }
    }
}

//Funtion to print the cactus
void print_cactus()
{
    for(int c=0; c<=4; c++) { //4 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=11; r++) {
            if (g_cactus[r][c]==0) {
                if (lcd.getPixel(c+cactus_movement,r+35)!=0) {
                    lcd.setPixel(c+cactus_movement,r+35);
                } else {
                    lcd.clearPixel(c+cactus_movement,r+35);
                }
            } else if (g_cactus[r][c]==1) {
                lcd.setPixel(c+cactus_movement,r+35);
            }
        }
    }
}

//Funtion to print the quick sand
void print_quick_sand()
{
    for(int x=0; x<=16; x++) {
        lcd.setPixel(x+quick_sand_movement,46);
    }
}

//Funtion to print the T Rex still
void print_t_rex()
{
    for(int c=0; c<=24; c++) { //24 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=27; r++) {
            if (g_t_rex[r][c]==0) {
                if (lcd.getPixel(c+t_rex_movement,r+19)!=0) {
                    lcd.setPixel(c+t_rex_movement,r+19);
                } else {
                    lcd.clearPixel(c+t_rex_movement,r+19);
                }
            } else if (g_t_rex[r][c]==1) {
                lcd.setPixel(c+t_rex_movement,r+19);
            }
        }
    }
}

//Funtion to print the T Rex moving
void print_t_rex_moving()
{
    for(int c=0; c<=24; c++) { //24 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=27; r++) {
            if (g_t_rex_moving[r][c]==0) {
                if (lcd.getPixel(c+t_rex_movement,r+19)!=0) {
                    lcd.setPixel(c+t_rex_movement,r+19);
                } else {
                    lcd.clearPixel(c+t_rex_movement,r+19);
                }
            } else if (g_t_rex_moving[r][c]==1) {
                lcd.setPixel(c+t_rex_movement,r+19);
            }
        }
    }
}

//Funtion to print the T Rex attack
void print_t_rex_attack()
{
    for(int c=0; c<=24; c++) { //24 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=27; r++) {
            if (g_t_rex_attack[r][c]==0) {
                if (lcd.getPixel(c+t_rex_movement,r+19)!=0) {
                    lcd.setPixel(c+t_rex_movement,r+19);
                } else {
                    lcd.clearPixel(c+t_rex_movement,r+19);
                }
            } else if (g_t_rex_attack[r][c]==1) {
                lcd.setPixel(c+t_rex_movement,r+19);
            }
        }
    }
}

//Funtion to print the fire ball (position 1)
void print_fire_ball_p1()
{
    for(int c=0; c<=8; c++) { //24 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=8; r++) {
            if (g_fire_ball_p1[r][c]==0) {
                if (lcd.getPixel(c+fire_ball_hMovement,r+fire_ball_vMovement)!=0) {
                    lcd.setPixel(c+fire_ball_hMovement,r+fire_ball_vMovement);
                } else {
                    lcd.clearPixel(c+fire_ball_hMovement,r+fire_ball_vMovement);
                }
            } else if (g_fire_ball_p1[r][c]==1) {
                lcd.setPixel(c+fire_ball_hMovement,r+fire_ball_vMovement);
            }
        }
    }
}

//Funtion to print the fire ball (position 2)
void print_fire_ball_p2()
{
    for(int c=0; c<=8; c++) { //24 beacause the loop stats from 0 but the array size from 1
        for(int r=0; r<=8; r++) {
            if (g_fire_ball_p2[r][c]==0) {
                if (lcd.getPixel(c+fire_ball_hMovement,r+fire_ball_vMovement)!=0) {
                    lcd.setPixel(c+fire_ball_hMovement,r+fire_ball_vMovement);
                } else {
                    lcd.clearPixel(c+fire_ball_hMovement,r+fire_ball_vMovement);
                }
            } else if (g_fire_ball_p2[r][c]==1) {
                lcd.setPixel(c+fire_ball_hMovement,r+fire_ball_vMovement);
            }
        }
    }
}

//Funtion to print the clouds
void print_clouds()
{
    //8 bit unsigned integer that loops round to 0 when the h_movement variable is > than 255
    //this means that the cloud array loops round when it finishes
    uint8_t clouds_movement=h_movement;
    for(int c=clouds_movement; c<=clouds_movement+83; c++) {
        for(int r=0; r<=2; r++) {
            if (g_clouds[r][c]==0) {
                lcd.clearPixel(c-clouds_movement,r+6);
            } else if (g_clouds[r][c]==1) {
                lcd.setPixel(c-clouds_movement,r+6);
            }
        }
    }
}

void print_locks()
{
    //depending on the value of story_progress locked padlocks are printed or unlocked ones
    int sp=8*story_progress;
    for(int c=0; c<=3; c++) { //24 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=5; r++) {
            for (int n=1; n<=33; n+=8) {
                if (g_padlock_p1[r][c]==0) {
                    lcd.clearPixel(c+8,r+n);
                } else if (g_padlock_p1[r][c]==1) {
                    lcd.setPixel(c+8,r+n);
                }
            }
        }
    }
    for(int c=0; c<=3; c++) { //24 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=5; r++) {
            for (int n=1; n<=sp; n+=8) {
                if (g_padlock_p2[r][c]==0) {
                    lcd.clearPixel(c+8,r+n);
                } else if (g_padlock_p2[r][c]==1) {
                    lcd.setPixel(c+8,r+n);
                }
            }
        }
    }
}


//Funtion that is called when the player walks or jumps on quick sand, Recks falls and
//looses all lives
void falling_animation()
{
    while (fall<60) {
        if (g_Ticker_Game_flag) {
            g_Ticker_Game_flag=0;
            print_recks_falling();
            fall+=3;                //vertical poition of recks increases (goes down) every loop
        }
        lcd.refresh();
        sleep();                    //puts mbed to sleep
        lcd.clear();       //Clear all the pixels on the LCD screen
    }
}

//Funtion that is called before the main menu the start and dislplayes the name of the game
void intro()
{
    lcd.clear(); //clears all pixels on LCD
    lcd.printString("ROBOZOEC",18,2);
    lcd.printString("ERA",33,3);
    lcd.refresh();
    ticker_wait(30);
}

//Interrupt service routine for the menus ticker
void Ticker_Menu_isr()
{
    //sets the menu flag to 1
    g_Ticker_Menu_flag=1;
}

//Interrupt service routine for the game ticker
void Ticker_Game_isr()
{
    //sets the menu flag to 1
    g_Ticker_Game_flag=1;
}

//Interrupt service routine for the ticker_wait funtion ticker
void Ticker_ds_isr()
{
    //sets ds flag to 1
    g_Ticker_ds_flag=1;
}

//Funtion that is called when the time out is timed out
void music_tOut()
{
    //Turns the note off
    PWM.write(0.0);
}

//Interrupt service routine for the press_b_A interrupt
void press_b_A_isr()
{
    //sets the g_press_b_A_flag to 1
    g_press_b_A_flag=1;
}

//Interrupt service routine for the press_b_B interrupt
void press_b_B_isr()
{
    //sets the g_press_b_B_flag to 1
    g_press_b_B_flag=1;
}

// read default positions of the joystick to calibrate later readings
void calibrateJoystick()
{
    swJoy.mode(PullDown);
    // must not move during calibration
    joystick.x0 = xPot;  // initial positions in the range 0.0 to 1.0 (0.5 if centred exactly)
    joystick.y0 = yPot;
}
void updateJoystick()
{
    // read current joystick values relative to calibrated values (in range -0.5 to 0.5, 0.0 is centred)
    joystick.x = xPot - joystick.x0;
    joystick.y = yPot - joystick.y0;
    // read button state
    joystick.swJoy = swJoy;

    // calculate direction depending on x,y values
    // tolerance allows a little lee-way in case joystick not exactly in the stated direction
    if ( fabs(joystick.y) < joystickTolerance && fabs(joystick.x) < joystickTolerance) {
        joystick.direction = CENTRE;
    } else if ( joystick.y > joystickTolerance && fabs(joystick.x) < joystickTolerance) {
        joystick.direction = UP;
    } else if ( joystick.y < joystickTolerance && fabs(joystick.x) < joystickTolerance) {
        joystick.direction = DOWN;
    } else if ( joystick.x > joystickTolerance && fabs(joystick.y) < joystickTolerance) {
        joystick.direction = LEFT;
    } else if ( joystick.x < joystickTolerance && fabs(joystick.y) < joystickTolerance) {
        joystick.direction = RIGHT;
    }
}

//Funtion that prints the main menu and all other funtions are called from it
void main_menu()
{
    menuState=0;
    while(1) {
        g_press_b_A_flag=0;
        g_press_b_A_flag=0;
        if (g_Ticker_Menu_flag) {
            g_Ticker_Menu_flag=0;
            updateJoystick();
            lcd.setBrightness(brightness);
            menu_select = fsm_main_menu[menuState].menu_select;  // set ouput depending on current state
            menuState = fsm_main_menu[menuState].nextState[joystick.direction]; // when joystick.direction has a vaule of CENTRE/RIGHT/LEFT the state machine input is 0 when it has a value of DOWN it is 0b01 when it has a value of UP is is 0b10
            lcd.clear();       //Clear all the pixels on the LCD screen
            //Print the options on the main menu
            lcd.printString("Story mode",13,0);
            lcd.printString("Minigame",18,1);
            lcd.printString("Settings",18,2);
            lcd.printString("Leaderboard",9,3);
            lcd.printString("Credits",21,4);
            //inverts the pixels to highlight the option that would be selected if the buttion A is pressed
            for (int i=0; i<85; i++) {      //go through every pixel on the x axis
                for (int j=menu_select; j<(menu_select+8); j++) {  // go through relevant pixels on the y axis
                    if (lcd.getPixel(i,j)== 0) {                   //if the pixel is on trun it off
                        lcd.setPixel(i,j);
                    } else {
                        lcd.clearPixel(i,j);                       //if the pixel is off turn it on
                    }
                }
            }
            lcd.refresh();
            //if the butto A is pressed with and the output of the menu fsm is 0, 8, 16, 24, 32
            if (b_A & menu_select==0) {
                //calls story mode function
                Story_Mode();
            } else if (b_A & menu_select==8) {
                //calls game function
                Game();
            } else if (b_A & menu_select==16) {
                //calls settings function
                Settings();
            } else if (b_A & menu_select==24) {
                //calls leaderboard function and after it turns the mbes leds off
                Leaderboard();
                red_led=1;
                green_led=1;
            } else if (b_A & menu_select==32) {
                //calls the credits funtion
                Credits();
            }
            //CHEAT CODE that unlocks all the story mode chapters
            //CODE: joystick LEFT, button swJoy and button b_B at the same time
            if (joystick.direction==LEFT&swJoy==1&b_B==1) {
                story_progress=5;
                writeSD_progress();
                //Led turns on and off to show that the code was sucessfull
                green_led=0;
                ticker_wait(5);
                green_led=1;
            }
        }
        sleep();                    //puts mbed to sleep
    }
}

//Function that runs the game, when this funtion runs the game has no end
void Minigame()
{
    ticker_wait(5); //wait 0.5s
    while (1) {
        if (g_Ticker_Game_flag) {
            g_Ticker_Game_flag=0;
            lcd.clear();       //Clear all the pixels on the LCD screen
            updateJoystick();
            Game();             //run the came

        }
        lcd.refresh();
        sleep();                    //puts mbed to sleep
    }
}

//Function that runs story mode menu
void Story_Mode()
{
    menuState=0;
    story_mode_flag=1;  //if this =1 the game funtion will end at different score levels depending on chapter
    led=0;
    readSD_progress();
    while(1) {
        if (g_Ticker_Menu_flag) {
            g_Ticker_Menu_flag=0;
            updateJoystick();
            lcd.setBrightness(brightness);
            menu_select = fsm_main_menu[menuState].menu_select;  // set ouput depending on current state
            menuState = fsm_main_menu[menuState].nextState[joystick.direction]; // when joystick.direction has a vaule of CENTRE/RIGHT/LEFT the state machine input is 0 when it has a value of DOWN it is 0b01 when it has a value of UP is is 0b10
            lcd.clear();       //Clear all the pixels on the LCD screen
            //prints the locks displaying what chapters are unlocked
            print_locks();
            //prints the chapters
            lcd.printString("Tutorial",20,0);
            lcd.printString("Chapter 1",20,1);
            lcd.printString("Chapter 2",20,2);
            lcd.printString("Chapter 3",20,3);
            lcd.printString("Chapter 4",20,4);
            for (int i=0; i<85; i++) {      //go through every pixel on the x axis
                for (int j=menu_select; j<(menu_select+8); j++) {  // go through relevant pixels on the y axis
                    if (lcd.getPixel(i,j)== 0) {                   //if the pixel is on trun it off
                        lcd.setPixel(i,j);
                    } else {
                        lcd.clearPixel(i,j);                       //if the pixel is off turn it on
                    }
                }
            }
            lcd.refresh();
            //selects chapter depending on the button A, the output of the menu fst and whether it is unlocked
            if (b_A & menu_select==0&story_progress>=1) {
                Tutorial();
            } else if (b_A & menu_select==8&story_progress>=2) {
                Chapter1();
            } else if (b_A & menu_select==16&story_progress>=3) {
                Chapter2();
            } else if (b_A & menu_select==24&story_progress>=4) {
                Chapter3();
            } else if (b_A & menu_select==32&story_progress>=5) {
                Chapter4();
            }
            //if button b_B is presses it returns to the main menu clearing the story mode flag
            if (b_B) {
                menuState=0;
                story_mode_flag=0;
                return;
            }
        }
        sleep();                    //puts mbed to sleep
    }
}


//Funtion that introduces the game and the controls to the user
void Tutorial()
{
    //prints message
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("Welcome to",0,0);
    lcd.printString("boot camp",0,1);
    lcd.printString("soldier",0,2);
    lcd.printString("Press A >>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    //when b_A is pressed it exits the while loop continueing to the next printed message
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    //print message
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("Are you ready",0,0);
    lcd.printString("to begin your",0,1);
    lcd.printString("training?",0,2);
    lcd.printString("Press A >>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("Okay use",0,0);
    lcd.printString("joysick to",0,1);
    lcd.printString("move right and",0,2);
    lcd.printString("left to...",0,3);
    lcd.printString("Press A >>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("... move",0,0);
    lcd.printString("forwards and",0,1);
    lcd.printString("backwards.",0,2);
    lcd.printString("Understand?",0,3);
    lcd.printString("Yes Sir!>>",22,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("Now you try...",0,0);
    lcd.printString("Okay!>>",30,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    //sets the difficulty to -1, no interactive elements in the game
    //this allows the player to try the game contolls
    difficulty =-1;
    Game();
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("Good!!!",0,0);
    lcd.printString("Now lets try",0,1);
    lcd.printString("jumping. To",0,2);
    lcd.printString("jump press B",0,3);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    //sets the difficulty to -1, no interactive elements in the game
    //this allows the player to try the game contolls
    difficulty =-1;
    Game();
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("You can also",0,0);
    lcd.printString("crouch if you",0,1);
    lcd.printString("move your",0,2);
    lcd.printString("joystick down",0,3);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("And if you",0,0);
    lcd.printString("move the joy-",0,1);
    lcd.printString("stick up you",0,2);
    lcd.printString("will activate",0,3);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("your shield,",0,0);
    lcd.printString("this will",0,1);
    lcd.printString("protect you",0,2);
    lcd.printString("for 1 sec but",0,3);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("it'll cost",0,0);
    lcd.printString("you 10 score",0,1);
    lcd.printString("points.",0,2);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("Try it...",0,0);
    lcd.printString("Okay>>",30,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    //sets the difficulty to -1, no interactive elements in the game
    //this allows the player to try the game contolls
    //Also increases the score to 30 so player can test using the shield
    difficulty =-1;
    score=30;
    Game();
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("Great!!!",0,0);
    lcd.printString("To shoot press",0,1);
    lcd.printString("A, but watch",0,2);
    lcd.printString("out you...",0,3);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("... might use",0,0);
    lcd.printString("all your ammo",0,1);
    lcd.printString("Give it a go!",0,3);
    lcd.printString("Okay>>",30,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    //sets the difficulty to -1, no interactive elements in the game
    //this allows the player to try the game contolls
    difficulty =-1;
    Game();
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("Remember you",0,0);
    lcd.printString("can also shoot",0,1);
    lcd.printString("while jumping",0,2);
    lcd.printString("and crouching",0,3);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("Information",0,0);
    lcd.printString("about your",0,1);
    lcd.printString("status (ammo",0,2);
    lcd.printString("and score) ...",0,3);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);;
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("... is shown",0,0);
    lcd.printString("above, and the",0,1);
    lcd.printString("number",0,2);
    lcd.printString("lives you ...",0,3);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("... have is",0,0);
    lcd.printString("displayed on",0,1);
    lcd.printString("the LED bar,",0,2);
    lcd.printString("when they...",0,3);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("... all turn",0,0);
    lcd.printString("off you will",0,1);
    lcd.printString("die, so make",0,2);
    lcd.printString("sure that...",0,3);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("... it doesn't",0,0);
    lcd.printString("happen!!!",0,1);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("Excellent!!!",0,0);
    lcd.printString("Your training",0,1);
    lcd.printString("is over",0,2);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("Are you ready",0,0);
    lcd.printString("for your first",0,1);
    lcd.printString("mission?",0,2);
    lcd.printString("Yes!!!>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            //Increses story_pregress
            story_progress=2;
            //autosaves progress
            writeSD_progress();
            break;
        }
        sleep();                    //puts mbed to sleep
    }
}

void Chapter1()
{
    //Introduce story
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("150+ MISSIONS",0,1);
    lcd.printString("LATER",18,2);
    lcd.refresh();
    ticker_wait(20);
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("MISSION #158:",0,0);
    lcd.printString("We have intel",0,1);
    lcd.printString("of a new range",0,2);
    lcd.printString("of high tech",0,3);
    lcd.printString("military grade",0,4);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("weapons being",0,0);
    lcd.printString("developed in",0,1);
    lcd.printString("a remote",0,2);
    lcd.printString("island in the",0,3);
    lcd.printString("South...",0,4);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    ticker_wait(10);
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("... Pacific.",0,0);
    lcd.printString("Your mission",0,1);
    lcd.printString("is to",0,2);
    lcd.printString("infiltrate the",0,3);
    lcd.printString("island and...",0,4);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    ticker_wait(10);
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("... destroy",0,0);
    lcd.printString("as many of",0,1);
    lcd.printString("the weapons as",0,2);
    lcd.printString("you can. Are",0,3);
    lcd.printString("you ready?",0,4);
    lcd.printString("Yes!!>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    ticker_wait(10);
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("Excellent, you",0,0);
    lcd.printString("will land on",0,1);
    lcd.printString("the farside of",0,2);
    lcd.printString("the island and",0,3);
    lcd.printString("work your...",0,4);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    ticker_wait(10);
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("...way towards",0,0);
    lcd.printString("the centre the",0,1);
    lcd.printString("closer you get",0,2);
    lcd.printString("the more",0,3);
    lcd.printString("defences...",0,4);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    ticker_wait(20);
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("they'll have.",0,0);
    lcd.printString("For now you",0,1);
    lcd.printString("need to look",0,2);
    lcd.printString("out for the",0,3);
    lcd.printString("cacti they...",0,4);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }

    ticker_wait(20);
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("if you touch",0,0);
    lcd.printString("one you'll",0,1);
    lcd.printString("lose a life so",0,2);
    lcd.printString("jump over...",0,3);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    ticker_wait(20);
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("...them, also,",0,0);
    lcd.printString("watch out for",0,1);
    lcd.printString("low tech cyber",0,2);
    lcd.printString("rats running",0,3);
    lcd.printString("around, you'll...",0,4);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    ticker_wait(20);
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("have to jump",0,0);
    lcd.printString("them aswell",0,1);
    lcd.printString("as you cannot",0,2);
    lcd.printString("destroy them.",0,3);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    ticker_wait(20);
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("That's all you",0,0);
    lcd.printString("need to know ",0,1);
    lcd.printString("for now. Get",0,2);
    lcd.printString("to work and",0,3);
    lcd.printString("Good Luck!!!",0,4);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    //sets the difficulty to 0, only cactus and rats
    //this allows the player to try the game contolls
    difficulty=0;
    Game();
    //innreases the story progress to 3
    story_progress=3;
    //autosaves progress
    writeSD_progress();
    //prints post game message
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("Well done!!!",0,0);
    lcd.printString("Oh no...",0,1);
    lcd.printString("It looks like",0,2);
    lcd.printString("things are",0,3);
    lcd.printString("steping up",0,4);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
}

void Chapter2()
{
    //Continuing the story, indroducing more mobs
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("Now you'll",0,0);
    lcd.printString("encounter",0,1);
    lcd.printString("robotic birds",0,2);
    lcd.printString("and robotic",0,3);
    lcd.printString("hounds aswell.",0,4);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("Watch out for",0,0);
    lcd.printString("the birds as",0,1);
    lcd.printString("they may swoop",0,2);
    lcd.printString("and the hounds",0,3);
    lcd.printString("will pounce",0,4);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    //Set difficulty to 1. Hounds and birds also appear
    difficulty=1;
    Game();
    //When compleated it increases story_progress to 4
    story_progress=4;
    //autosaves progress
    writeSD_progress();
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("Oh dear...",0,0);
    lcd.printString("There is more",0,1);
    lcd.printString("trouble ahead",0,2);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
}

void Chapter3()
{
    //Continuing the story, indroducing more mobs
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("It looks like",0,0);
    lcd.printString("there is some",0,1);
    lcd.printString("sort of",0,2);
    lcd.printString("bionic bear!!",0,3);
    lcd.printString("You better...",0,4);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("... watch out",0,0);
    lcd.printString("it looks like",0,1);
    lcd.printString("it will be",0,2);
    lcd.printString("able to",0,3);
    lcd.printString("withstand...",0,4);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("a few shots",0,0);
    lcd.printString("before",0,1);
    lcd.printString("destroying it",0,2);
    lcd.printString("4 hits should",0,3);
    lcd.printString("do it. GO!",0,4);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    //Set difficulty to 2. Bears will appear
    difficulty=2;
    Game();
    //Increases story progress
    story_progress=5;
    //Autosaves game
    writeSD_progress();
    //Post game message
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("OH DEAR",0,0);
    lcd.printString("LORD...",0,1);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
}

void Chapter4()
{
    ////Continuing the story, indroducing final boss
    g_press_b_A_flag=0;
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("You won't",0,0);
    lcd.printString("beleve this",0,1);
    lcd.printString("it's it's...",0,2);
    lcd.printString("it can't be",0,3);
    lcd.printString("it's not...",0,4);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("it's not",0,0);
    lcd.printString("possible...",0,1);
    lcd.printString("It's a T Rex,",0,2);
    lcd.printString("a robotic",0,3);
    lcd.printString("T Rex!!!!",0,4);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("It's it's...",0,0);
    lcd.printString("it's",0,1);
    lcd.printString("breathing",0,2);
    lcd.printString("fire!!!",0,3);
    lcd.printString("It looks...",0,4);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("... like it",0,0);
    lcd.printString("will only",0,1);
    lcd.printString("take damage",0,2);
    lcd.printString("when it's",0,3);
    lcd.printString("attacking...",0,4);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("and I think",0,0);
    lcd.printString("you'll have",0,1);
    lcd.printString("to shoot it",0,2);
    lcd.printString("at least 8",0,3);
    lcd.printString("times to...",0,4);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("...destroy it",0,0);
    lcd.printString("I'll drop",0,1);
    lcd.printString("some ammo",0,2);
    lcd.printString("for you.",0,3);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.clear();       //Clear all the pixels on the LCD screen
    lcd.printString("Good Luck",0,0);
    lcd.printString("You'll need",0,1);
    lcd.printString("it",0,2);
    lcd.printString("Press A>>",24,5);
    lcd.refresh();
    ticker_wait(10);
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
    difficulty=3;
    Game();
    initialize_values();
    if (g_story_mode_win) {
        lcd.clear();       //Clear all the pixels on the LCD screen
        lcd.printString("Well done",0,0);
        lcd.printString("Recks",0,1);
        lcd.printString("Lets clear",0,2);
        lcd.printString("get you home",0,3);
        lcd.printString("Press A>>",24,5);
        lcd.refresh();
        ticker_wait(30);
    }
    g_press_b_A_flag=0;
    while (1) {
        if (g_press_b_A_flag) {
            g_press_b_A_flag=0;
            break;
        }
        sleep();                    //puts mbed to sleep
    }
}

//Funtion that inverst the pixels and stops the game for 0.5s when a life is lost
void freeze()
{
    lcd.inverseMode(); //invert pixels
    lcd.refresh();
    ticker_wait(5);
    lcd.normalMode();
}

//Print the settings menu
void Settings()
{
    menuState=0;
    while (1) {
        if (g_Ticker_Menu_flag) {
            g_Ticker_Menu_flag=0;
            updateJoystick();
            menu_select = fsm_settings_menu[menuState].menu_select;  // set ouput depending on current state
            menuState = fsm_settings_menu[menuState].nextState[joystick.direction]; // when joystick.direction has a vaule of CENTRE/RIGHT/LEFT the state machine input is 0 when it has a value of DOWN it is 0b01 when it has a value of UP is is 0b10
            lcd.clear();       //Clear all the pixels on the LCD screen
            //print the options
            lcd.printString("Brightness",13,0);
            lcd.printString("Difficulty",13,1);
            lcd.printString("SD card",13,2);
            lcd.printString("Guns",13,3);
            for (int i=0; i<85; i++) {      //go through every pixel on the x axis
                for (int j=menu_select; j<(menu_select+8); j++) {  // go through relevant pixels on the y axis
                    if (lcd.getPixel(i,j)== 0) {                   //if the pixel is on trun it off
                        lcd.setPixel(i,j);
                    } else {
                        lcd.clearPixel(i,j);                       //if the pixel is off turn it on
                    }
                }
            }
            //Depending of the selected option, call the respective funtion
            lcd.refresh();
            if (b_A & menu_select==0) {
                Brightness();
                return;
            } else if (b_A & menu_select==8) {
                Difficulty();
                return;
            } else if (b_A & menu_select==16) {
                Delete_Highscores();
                return;
            } else if (b_A & menu_select==24) {
                guns();
                return;
            }
            if (b_B) {
                menuState=0;
                return;
            }
        }
    }
}

//Funtion to choose the difficulty of the game
void Difficulty()
{
    menuState=0;
    while(1) {
        if (g_Ticker_Menu_flag) {
            g_Ticker_Menu_flag=0;
            updateJoystick();
            menu_select = fsm_main_menu[menuState].menu_select;  // set ouput depending on current state
            menuState = fsm_main_menu[menuState].nextState[joystick.direction]; // when joystick.direction has a vaule of CENTRE/RIGHT/LEFT the state machine input is 0 when it has a value of DOWN it is 0b01 when it has a value of UP is is 0b10
            lcd.clear();       //Clear all the pixels on the LCD screen
            //print all dificulty options
            lcd.printString("Piece of Cake",3,0);
            lcd.printString("Easy",30,1);
            lcd.printString("Regular",23,2);
            lcd.printString("Hard",30,3);
            lcd.printString("Legendary",15,4);
            for (int i=0; i<85; i++) {      //go through every pixel on the x axis
                for (int j=menu_select; j<(menu_select+8); j++) {  // go through relevant pixels on the y axis
                    if (lcd.getPixel(i,j)== 0) {                   //if the pixel is on trun it off
                        lcd.setPixel(i,j);
                    } else {
                        lcd.clearPixel(i,j);                       //if the pixel is off turn it on
                    }
                }
            }
            //Depending on the option chosen set the difficulty to a certain value, the higher the value the higher the dificulty and return to main menu
            lcd.refresh();
            if (b_A & menu_select==0) {
                difficulty=0;
                return;
            } else if (b_A & menu_select==8) {
                difficulty=1;
                return;
            } else if (b_A & menu_select==16) {
                difficulty=2;
                return;
            } else if (b_A & menu_select==24) {
                difficulty=3;
                return;
            } else if (b_A & menu_select==32) {
                difficulty=4;
                return;
            }
            if (b_B) {
                menuState=0;
                return;
            }
        }
        sleep();                    //puts mbed to sleep
    }
}

//Menu to chose brightness
void Brightness()
{
    menuState=0;
    while(1) {
        if (g_Ticker_Menu_flag) {
            g_Ticker_Menu_flag=0;
            updateJoystick();
            menu_select = fsm_main_menu[menuState].menu_select;  // set ouput depending on current state
            menuState = fsm_main_menu[menuState].nextState[joystick.direction]; // when joystick.direction has a vaule of CENTRE/RIGHT/LEFT the state machine input is 0 when it has a value of DOWN it is 0b01 when it has a value of UP is is 0b10
            lcd.clear();       //Clear all the pixels on the LCD screen
            //Print brightness options
            lcd.printString("Dark",30,0);
            lcd.printString("Eco",33,1);
            lcd.printString("Regular",23,2);
            lcd.printString("Bright",26,3);
            lcd.printString("Blinding",20,4);
            for (int i=0; i<85; i++) {      //go through every pixel on the x axis
                for (int j=menu_select; j<(menu_select+8); j++) {  // go through relevant pixels on the y axis
                    if (lcd.getPixel(i,j)== 0) {                   //if the pixel is on trun it off
                        lcd.setPixel(i,j);
                    } else {
                        lcd.clearPixel(i,j);                       //if the pixel is off turn it on
                    }
                }
            }
            //Depending on chosen option, set the brightness between 0 anf 1 and return to main menu
            lcd.refresh();
            if (b_A & menu_select==0) {
                brightness=0;
                return;
            } else if (b_A & menu_select==8) {
                brightness=0.3;
                return;
            } else if (b_A & menu_select==16) {
                brightness=0.5;
                return;
            } else if (b_A & menu_select==24) {
                brightness=0.7;
                return;
            } else if (b_A & menu_select==32) {
                brightness=1;
                return;
            }
            if (b_B) {
                menuState=0;
                return;
            }
        }
        sleep();                    //puts mbed to sleep
    }
}

//Prints the leaderboard
void Leaderboard()
{
    lcd.clear();       //Clear all the pixels on the LCD screen
    //reads and prints the leaderboard
    readSD_and_print_top_score();
    g_press_b_B_flag=0;
    //if the b_B button is presses return to menu
    while(1) {
        if (g_press_b_B_flag) {
            g_press_b_B_flag=0;
            return;
        }
        lcd.refresh();
        sleep();                    //puts mbed to sleep
    }
}

//Print the guns options
void guns()
{
    menuState=0;
    while(1) {
        if (g_Ticker_Menu_flag) {
            g_Ticker_Menu_flag=0;
            updateJoystick();
            menu_select = fsm_settings_menu[menuState].menu_select;  // set ouput depending on current state
            menuState = fsm_settings_menu[menuState].nextState[joystick.direction]; // when joystick.direction has a vaule of CENTRE/RIGHT/LEFT the state machine input is 0 when it has a value of DOWN it is 0b01 when it has a value of UP is is 0b10
            lcd.clear();       //Clear all the pixels on the LCD screen
            //Print the guns options
            lcd.printString("Pistol",10,0);
            lcd.printString("Revolver",10,1);
            lcd.printString("Rifle",10,2);
            lcd.printString("Random",10,3);
            for (int i=0; i<85; i++) {      //go through every pixel on the x axis
                for (int j=menu_select; j<(menu_select+8); j++) {  // go through relevant pixels on the y axis
                    if (lcd.getPixel(i,j)== 0) {                   //if the pixel is on trun it off
                        lcd.setPixel(i,j);
                    } else {
                        lcd.clearPixel(i,j);                       //if the pixel is off turn it on
                    }
                }
            }
            lcd.refresh();
            //Depending on the options selected g_g1, g_g2 set to one
            //if g_g1=1 and g_g2=1 it increases the dmage taken by certain mobs
            if (b_A & menu_select==0) {
                g_g1=0;
                g_g2=0;
                return;
            } else if (b_A & menu_select==8) {
                g_g1=1;
                g_g2=0;
                return;
            } else if (b_A & menu_select==16) {
                g_g1=1;
                g_g2=1;
                return;
            } else if (b_A & menu_select==24) {
                if (rand()%3==0) {
                    g_g1=0;
                    g_g2=0;
                } else if (rand()%3==1) {
                    g_g1=1;
                    g_g2=0;
                } else if (rand()%3==2) {
                    g_g1=1;
                    g_g2=1;
                }
                return;
            }
            if (b_B) {
                menuState=0;
                return;
            }
        }
        sleep();                    //puts mbed to sleep
    }
}

//prints the credits
void Credits()
{
    lcd.clear();
    lcd.printString("Game made by",6,2);
    lcd.refresh();
    ticker_wait(30);
    lcd.clear();
    lcd.printString("ROBIN",6,1);
    lcd.printString("MILWARD",6,2);
    lcd.printString("COONEY",6,3);
    lcd.refresh();
    ticker_wait(30);
    lcd.clear();
    lcd.printString("Game made for",0,2);
    lcd.refresh();
    ticker_wait(30);
    lcd.clear();
    lcd.printString("ELEC2645",6,2);
    lcd.refresh();
    ticker_wait(30);
}


//Physics related to Recks
void Recks()
{
    //if the joystick is centred recks is still
    if (joystick.direction==CENTRE&jump_flag!=1&shield_flag!=1) {
        lcd.setPixel(bullet,bullet_height);
        lcd.setPixel(bullet+1,bullet_height);
        print_recks_still_gun();
        if (shoot_flag==1) {
            bullet+=20;
            if (bullet>=84) {
                shoot_flag=0;
                g_shoot_loop=0;
            }
        }
        //if the joystick is left then everything except recks moves to the left
    } else if (joystick.direction==LEFT&jump_flag!=1&shield_flag!=1) {
        if ( i%4>=2) {
            print_recks_still_gun();
        } else if ( i%4<2) {
            print_recks_moving_gun();
        }
        lcd.setPixel(bullet,bullet_height);
        lcd.setPixel(bullet+1,bullet_height);
        if (shoot_flag==1) {
            bullet+=21;
            if (bullet>=84) {
                shoot_flag=0;
                g_shoot_loop=0;
            }
        }
        h_movement--;
        //if the joystick is right then everything except recks moves to the right
    } else if (joystick.direction==RIGHT&jump_flag!=1&shield_flag!=1) {
        if ( i%4>=2) {
            print_recks_still_gun();
        } else if ( i%4<2) {
            print_recks_moving_gun();
        }
        lcd.setPixel(bullet,bullet_height);
        lcd.setPixel(bullet+1,bullet_height);
        if (shoot_flag==1) {
            bullet+=19;
            if (bullet>=84) {
                shoot_flag=0;
                g_shoot_loop=0;
            }
        }
        h_movement++;
        //If joystick is down recks crouches
    } else if (joystick.direction==DOWN&jump_flag!=1&shield_flag!=1) {
        lcd.setPixel(bullet,bullet_height);
        lcd.setPixel(bullet+1,bullet_height);
        print_recks_crouch_gun();
        bullet_height=42;
        if (shoot_flag==1) {
            bullet+=20;
            if (bullet>=84) {
                shoot_flag=0;
                g_shoot_loop=0;
            }
        }
        //If the jump_flag is 1 (then teh jump button has been pressed) Recks jumps
        //If the joystick moves while the jump_flag is 1 then Recks moves left or right
    } else if (jump_flag==1&shield_flag!=1) {
        if (joystick.direction==LEFT) {
            if (shoot_flag==1) {
                bullet+=21;
                if (bullet>=84) {
                    shoot_flag=0;
                    g_shoot_loop=0;
                }
            }
            h_movement--;
        } else if (joystick.direction==RIGHT) {
            if (shoot_flag==1) {
                bullet+=19;
                if (bullet>=84) {
                    shoot_flag=0;
                    g_shoot_loop=0;
                }
            }
            h_movement++;
        } else if (joystick.direction==CENTRE) {
            if (shoot_flag==1) {
                bullet+=20;
                if (bullet>=84) {
                    shoot_flag=0;
                    g_shoot_loop=0;
                }
            }
        }
        if (g_jump<=36&jumpUp==0&g_jump!=15) {
            lcd.setPixel(bullet,bullet_height);
            lcd.setPixel(bullet+1,bullet_height);
            if (bullet>=84) {
                shoot_flag=0;
                g_shoot_loop=0;
            }
            print_recks_jump_gun();
            g_jump-=6-accel;
            accel++;
        } else if (g_jump>=15&g_jump!=36) {
            lcd.setPixel(bullet,bullet_height);
            lcd.setPixel(bullet+1,bullet_height);
            if (bullet>=84) {
                shoot_flag=0;
                g_shoot_loop=0;
            }
            print_recks_jump_gun();
            g_jump+=6-accel;
            accel--;
            jumpUp=1;
        } else if (g_jump==36&jumpUp==1) {
            lcd.setPixel(bullet,bullet_height);
            lcd.setPixel(bullet+1,bullet_height);
            if (bullet>=84) {
                shoot_flag=0;
                g_shoot_loop=0;
            }
            print_recks_still_gun();
            jump_flag=0;
            jumpUp=0;
            g_jump=36;
            accel=0;
        }
    }
}

//Physics for rat
void rat()
{
    //rat array p1 or p2 changes every 2 itterations
    if (i%4>=2) {
        print_mob_rat_p1();
    } else if (i%4<2) {
        print_mob_rat_p2();
    }
    if (joystick.direction==LEFT) {
        rat_movement+=recks_movement;
    } else if (joystick.direction==RIGHT) {
        rat_movement-=recks_movement;
    }
    //rat velocity is 3 pixels per itteration
    rat_movement-=3;
    if (rat_movement<=-15) {
        rat_movement=100;
        print_rat_flag=0;
    }
    //when rat is in same vertical and horizontal position as Recks, Recks loses a life and the freeze duntion runs
    if (rat_movement<=5&rat_movement>=-3&g_jump>32&lose_lives_delay_flag==0&shield_flag!=1) {     //a life is lost if recks has an vertical and horizontal position equal to one of the pixels corresponding to the bears position
        lives--;
        freeze();
        lose_lives_delay_flag=1;
    }

}

void hound()
{
        //hound array p1 or p2 changes every 2 itterations
    if (i%4>=2&hound_jump_flag!=1) {
        print_mob_hound_p1();
    } else if (i%4<2&hound_jump_flag!=1) {
        print_mob_hound_p2();
    }
    if (joystick.direction==LEFT) {
        hound_hMovement+=recks_movement;
    } else if (joystick.direction==RIGHT) {
        hound_hMovement-=recks_movement;
    }
    //hound velocity is 2 pixels per itteration
    hound_hMovement-=2;
    if (hound_hMovement<=-15) {
        hound_hMovement=100;
        print_hound_flag=0;
    }
    if (random_num%10==0) {
        hound_jump_flag=1;
    }
    //if the hound_jump_flag is one the houd jumps and increases it's horizontal velocity to 3 pixels per itteration
    if (hound_jump_flag==1) {
        hound_jump++;
        hound_hMovement--;
        if (hound_jump==1) {
            hound_vMovement-=3;
        } else if (hound_jump==2) {
            hound_vMovement-=2;
        } else if (hound_jump==3) {
            hound_vMovement-=1;
        } else if (hound_jump==4) {
            hound_vMovement+=1;
        } else if (hound_jump==5) {
            hound_vMovement+=2;
        } else if (hound_jump==6) {
            hound_vMovement+=3;
        } else if (hound_jump==7) {
            hound_jump_flag=0;
            hound_jump=0;
        }
        print_mob_hound_p2();

    }
    //if hound possiton = recks possition, lives decrease by one
    if ((hound_hMovement<=8&hound_hMovement>=-5&g_jump>30&lose_lives_delay_flag==0&hound_jump_flag!=1&shield_flag!=1)|(hound_hMovement<=8&hound_hMovement>=-5&g_jump>26&lose_lives_delay_flag==0&hound_jump_flag==1&shield_flag!=1)) {     //a life is lost if recks has an vertical and horizontal position equal to one of the pixels corresponding to the hounds position
        lives--;
        freeze();
        lose_lives_delay_flag=1;
    }
    //if bullet is the same hight as hound then hound dies
    if (shoot_flag==1&bullet_height>hound_vMovement&bullet_height<hound_vMovement+8) {
        print_mob_hound_dead();
        print_hound_flag=0;
        hound_hMovement=90;
        kill_score+=5;
    }
}

//Prints bear physics
void bear()
{
    if (i%4>=2) {
        print_mob_bear_p1();
    } else if (i%4<2) {
        print_mob_bear_p2();
    }
    if (joystick.direction==LEFT) {
        bear_movement+=recks_movement;
    } else if (joystick.direction==RIGHT) {
        bear_movement-=recks_movement;
    }
    bear_movement-=2;
    if (bear_movement<=-15) {
        bear_movement=100;
        print_bear_flag=0;
    }
    if (bear_movement<=8&bear_movement>=-5&g_jump>26&lose_lives_delay_flag==0&shield_flag!=1) {     //a life is lost if recks has an vertical and horizontal position equal to one of the pixels corresponding to the bears position
        lives--;
        freeze();
        lose_lives_delay_flag=1;
    }
    if (shoot_flag==1&bullet_height>38) {
        bear_lives++;
        //if bullet hits bear 4 (or 3 or 2 depending on g_g1 and g_g2) bear dies
        if (bear_lives==12-3*g_g1-3*g_g2) {
            print_mob_bear_dead();
            print_bear_flag=0;
            bear_movement=100;
            kill_score+=7;
            bear_lives=0;
        }
    }
}

//Bird physins, has a constant horizontal velocity and the vertical one changes randomly
void bird()
{
    if (i%8>=4) {
        print_mob_bird_p1();
    } else if (i%8<4) {
        print_mob_bird_p2();
    }
    bird_hMovement-=2;
    if (joystick.direction==LEFT) {
        bird_hMovement+=recks_movement;
    } else if (joystick.direction==RIGHT) {
        bird_hMovement-=recks_movement;
    }
    if (random_num%6==0) {
        bird_vMovement--;
    } else if (random_num%6>=4) {
        bird_vMovement++;
    }
    if (bird_vMovement>=37) {
        bird_vMovement=37;
    } else if (bird_vMovement<=10) {
        bird_vMovement=10;
    }
    if (bird_hMovement<=-10) {
        print_bird_flag=0;
        bird_hMovement=100;
        bird_vMovement=20;
        bear_lives=0;
    }
    if ((bird_hMovement>=0&bird_hMovement<=10)&(bird_vMovement+5>=g_jump&bird_vMovement+5<=g_jump+10&lose_lives_delay_flag==0)&shield_flag!=1) {
        lives--;
        freeze();
        lose_lives_delay_flag=1;
    }
    if (shoot_flag==1&(bullet_height==bird_vMovement+5|bullet_height==bird_vMovement+4)) {
        print_mob_bird_dead();
        print_bird_flag=0;
        bird_hMovement=100;
        bird_vMovement=20;
        kill_score+=5;
    }
}

//Cactus physics
void cactus()
{
    print_cactus();
    if (joystick.direction==LEFT) {
        cactus_movement+=recks_movement;
    } else if (joystick.direction==RIGHT) {
        cactus_movement-=recks_movement;
    }
    if (cactus_movement<=-10) {
        cactus_movement=110;
        print_cactus_flag=0;
    }
    if (cactus_movement<=10&cactus_movement>=2&g_jump>32&lose_lives_delay_flag==0&shield_flag!=1) {
        lives--;
        freeze();
        lose_lives_delay_flag=1;
    }
}

//T Rex physics
void t_rex()
{
    if (joystick.direction==LEFT) {
        t_rex_movement+=recks_movement;
    } else if (joystick.direction==RIGHT) {
        t_rex_movement-=recks_movement;
    }
    if (random_num%4==0&print_fire_ball_flag!=1) {
        t_rex_movement+=3;
        print_t_rex_moving();
    } else if (random_num%4==1&print_fire_ball_flag!=1) {
        t_rex_movement-=3;
        print_t_rex_moving();
    } else if (random_num%4>1&print_fire_ball_flag!=1) {
        print_t_rex();
    }
    if (t_rex_movement<=-100) {
        t_rex_movement=120;
        print_t_rex_flag=0;
    }
    if (t_rex_movement<=6&t_rex_movement>=2&lose_lives_delay_flag==0&shield_flag!=1) {
        lives--;
        freeze();
        lose_lives_delay_flag=1;
    }
    if (print_t_rex_flag==1&random_num%10==0&fire_on_screen==0) {
        fire_on_screen=1;
        print_fire_ball_flag=1;
        fire_ball_hMovement=t_rex_movement-6;
        fire_ball_vMovement=25;
    }
}

//Fire ball physics, T Rex only loses lives when fire ball flag is on
void fire_ball()
{
    print_t_rex_attack();
    fire_ball_hMovement-=4;
    if (joystick.direction==LEFT) {
        fire_ball_hMovement+=recks_movement;
    } else if (joystick.direction==RIGHT) {
        fire_ball_hMovement-=recks_movement;
    }
    if (i%4>=2) {
        print_fire_ball_p1();
    } else {
        print_fire_ball_p2();
    }
    if (fire_ball_vMovement>=37) {
        fire_ball_vMovement=37;
    }
    if (random_num%3==0) {
        fire_ball_vMovement++;
    } else if (random_num%3==1) {
        fire_ball_vMovement+=2;
    }
    if (fire_ball_hMovement<=-10) {
        fire_ball_vMovement=27;
        fire_ball_hMovement=t_rex_movement-6;
        print_fire_ball_flag=0;
        fire_on_screen=0;
    }
    if (fire_ball_hMovement>=3&fire_ball_hMovement<=8&fire_ball_vMovement>g_jump-5&fire_ball_vMovement<g_jump+10&lose_lives_delay_flag==0&shield_flag!=1) {
        lives--;
        freeze();
        lose_lives_delay_flag=1;
    }
    if (shoot_flag==1) {
        t_rex_lives++;
        if (t_rex_lives>=27-3*g_g1-3*g_g2) {
            print_t_rex_flag=0;
            t_rex_movement=120;
            kill_score+=20;
            t_rex_lives=0;
        }
    }
}

//Physics for quicksand
void quick_sand()
{
    print_quick_sand();
    if (joystick.direction==LEFT) {
        quick_sand_movement+=recks_movement;
    } else if (joystick.direction==RIGHT) {
        quick_sand_movement-=recks_movement;
    }
    if (quick_sand_movement<7&quick_sand_movement>-5&jump_flag!=1) {
        lives-=5;
        falling_animation();
        quick_sand_movement=85;
        if (quick_sand_movement<-8) {
            print_quick_sand_flag=0;
        }
    }
}

//Heart physics
void heart()
{
    print_heart();
    if (joystick.direction==LEFT) {
        heart_movement+=recks_movement;
    } else if (joystick.direction==RIGHT) {
        heart_movement-=recks_movement;
    }
    if (heart_movement<=7&g_jump>26) {
        heart_movement=90;
        print_heart_flag=0;
        lives++;
    }
}

//Ammo pickup physics
void pickUp_ammo()
{
    print_ammo_pickUp();
    if (joystick.direction==LEFT) {
        ammo_movement+=recks_movement;
    } else if (joystick.direction==RIGHT) {
        ammo_movement-=recks_movement;
    }
    if (ammo_movement<=7&g_jump>26) {
        ammo_movement=90;
        print_ammo_flag=0;
        ammo+=5;
        ammo+=rand()%7;
    }
}

//Speedboost physcis. Recks speed increases by one when pucked up
void speed_boost()
{
    print_speed_boost();
    if (joystick.direction==LEFT) {
        speed_boost_movement+=recks_movement;
    } else if (joystick.direction==RIGHT) {
        speed_boost_movement-=recks_movement;
    }
    if (speed_boost_movement<=5&g_jump>26) {
        speed_boost_movement=120;
        print_speed_boost_flag=0;
        recks_movement++;
    }
}

//Shield physics
void shield()
{
    print_recks_shield();
    recks_movement=0;
    jump_flag=0;
    shoot_flag=0;
    shield_counter++;
    if (shield_counter>=10) {
        shield_counter=0;
        recks_movement=2;
        shield_score+=10;
        shield_flag=0;
    }
}


//Game funtion
//Combines all the privious physics funtions
//if the story mode is on then it ends after certain tasks are complete
void Game()
{
    int run_game=1;
    g_music_count=1;
    while (run_game==1) {
        ground();
        set_difficulty();
        if (g_Ticker_Game_flag) {
            play_music();
            g_Ticker_Game_flag=0;
            lcd.clear();       //Clear all the pixels on the LCD screen
            updateJoystick();
            led_bar();
            print_score();
            generate_random_number();
            if (lose_lives_delay_flag==1) {
                lives_delay_loop++;
                if (lives_delay_loop>=10) {     //means that the delay between one life beeing lost and another one beeing lost is at least 1s
                    lives_delay_loop=0;
                    lose_lives_delay_flag=0;
                }

            }
            if (ammo<=5) {
                if (i%8>=4) {
                    print_ammo();
                }
            } else {
                print_ammo();
            }
            if (b_B) {
                jump_flag=1;
            }
            if (shoot_flag==0) {
                bullet=9;
                if (joystick.direction==DOWN&jump_flag!=1) {
                    bullet_height=42;
                } else {
                    bullet_height=g_jump+4;
                }
            } else if (shoot_flag==1&g_shoot_loop==0) {
                g_shoot_loop++;
                ammo--;
                if (joystick.direction==DOWN&jump_flag!=1) {
                    bullet_height=42;
                } else {
                    bullet_height=g_jump+4;
                }
            }
            if (b_A) {
                if (ammo<=0) {
                    shoot_flag=0;
                } else {
                    shoot_flag=1;
                }
            }
            if (joystick.direction==UP&score>=10&jump_flag!=1) {
                shield_flag=1;
            } else if (joystick.direction==UP&score<10&jump_flag!=1) {
                print_recks_still_gun();
            }

            Recks();
            if (shield_flag==1) {
                shield();
            }
            if (print_rat_flag==1) {
                rat();
            }
            if (print_hound_flag==1) {
                hound();
            }
            if (print_bear_flag==1) {
                bear();
            }
            if (print_bird_flag==1) {
                bird();
            }
            if (print_cactus_flag==1) {
                cactus();
            }
            if (print_t_rex_flag==1) {
                t_rex();
            }
            if (print_fire_ball_flag==1) {
                fire_ball();
            }
            if (print_quick_sand_flag==1) {
                quick_sand();
            }
            if (print_heart_flag==1) {
                heart();
            }
            if (print_ammo_flag==1) {
                pickUp_ammo();
            }
            if (print_speed_boost_flag==1) {
                speed_boost();
            }
            if (recks_movement>=3&i%150==0) {
                recks_movement=2;
            }
            if (lives<=0) {
                run_game=Game_over();                       //calls game over returns 1 if continue was selected returns 0 if back to menu
            }
            if (swJoy==1) {
                Pause();
            }


            if (difficulty==-1&story_mode_flag==1) {
                if (i>70) {
                    initialize_values();
                    return;
                }
            } else if (difficulty==0&story_mode_flag==1) {
                if (score>60) {
                    return;
                }
            } else if (difficulty==1&story_mode_flag==1) {
                if (score>200) {
                    return;
                }
            } else if (difficulty==2&story_mode_flag==1) {
                if (score>500) {
                    return;
                }
            } else if (difficulty==3&story_mode_flag==1) {
                print_t_rex_flag=1;
                g_story_mode_win=0;
                if (t_rex_lives>=24) {
                    print_t_rex_flag=0;
                    g_story_mode_win=1;
                    return;
                }
            }
            i++;
            print_clouds();
        }
        lcd.refresh();
        sleep();                    //puts mbed to sleep
    }
}

//Funtion for pause
void Pause()
{
    int q;
    lcd.printString("PAUSED",25,3);
    ticker_wait(10);
    while (!swJoy) {
        q++;
        if (g_Ticker_Menu_flag) {
            g_Ticker_Menu_flag=0;
            if (q>=20) {
                lcd.setBrightness(0);
                led=0;
            }
        }
        sleep();                    //puts mbed to sleep
    }
    lcd.setBrightness(brightness);
    led_bar();
}


//Funtion that increases game difficuly as difficulty increases
void set_difficulty()
{
    switch(difficulty) {
        case -1:
            break;
        case 0:
            if (random_num<3000) {
                print_cactus_flag=1;
            } else if (random_num>=3000&random_num<6000) {
                print_rat_flag=1;
            } else if (random_num>=6000&random_num<6100) {
                print_heart_flag=1;
            }
            break;
        case 1:
            if (random_num<3000) {
                print_cactus_flag=1;
            } else if (random_num>=3000&random_num<5000) {
                print_rat_flag=1;
            } else if (random_num>=5000&random_num<6000) {
                print_bird_flag=1;
            } else if (random_num>=6000&random_num<6050) {
                print_heart_flag=1;
            } else if (random_num>=6050&random_num<7000) {
                print_hound_flag=1;
            } else if (random_num>=7000&random_num<7200) {
                print_ammo_flag=1;
            }
            break;
        case 2:
            if (random_num<3000) {
                print_cactus_flag=1;
            } else if (random_num>=3000&random_num<5000) {
                print_rat_flag=1;
            } else if (random_num>=5000&random_num<6000) {
                print_bird_flag=1;
            } else if (random_num>=6000&random_num<6040) {
                print_heart_flag=1;
            } else if (random_num>=6040&random_num<7000) {
                print_hound_flag=1;
            } else if (random_num>=7000&random_num<7200) {
                print_ammo_flag=1;
            } else if (random_num>=7200&random_num<8000) {
                print_bear_flag=1;
            } else if (random_num>=8000&random_num<8200) {
                print_speed_boost_flag=1;
            }
            break;
        case 3:
            if (random_num<1000) {
                print_bear_flag=1;
            } else if (random_num>=1000&random_num<3000) {
                print_bird_flag=1;
            } else if (random_num>=3000&random_num<3010) {
                print_heart_flag=1;
            } else if (random_num>=3010&random_num<3050) {
                print_ammo_flag=1;
            } else if (random_num>=3050&random_num<6000) {
                print_cactus_flag=1;
            } else if (random_num>=6000&random_num<6100) {
                print_ammo_flag=1;
                print_t_rex_flag=1;
            } else if (random_num>=6100&random_num<7000) {
                print_rat_flag=1;
            }  else if (random_num>=7000&random_num<8000) {
                print_hound_flag=1;
            }  else if (random_num>=8000&random_num<8200) {
                print_speed_boost_flag=1;
            }
            break;
        case 4:
            if (random_num<1000) {
                print_bear_flag=1;
            } else if (random_num>=1000&random_num<3000) {
                print_bird_flag=1;
            } else if (random_num>=3000&random_num<3010) {
                print_heart_flag=1;
            } else if (random_num>=3010&random_num<3050) {
                print_ammo_flag=1;
            } else if (random_num>=3050&random_num<6000) {
                print_cactus_flag=1;
            } else if (random_num>=6000&random_num<6300) {
                print_ammo_flag=1;
                print_t_rex_flag=1;
            } else if (random_num>=6300&random_num<7000) {
                print_rat_flag=1;
            }  else if (random_num>=7000&random_num<8000) {
                print_hound_flag=1;
            }  else if (random_num>=8000&random_num<8200) {
                print_speed_boost_flag=1;
            } else if (random_num>=8200&random_num<9000) {
                print_quick_sand_flag=1;
            }
            break;
    }
}


//Game over funtion
int Game_over()
{
    led_bar();
    lcd.clear();       //Clear all the pixels on the LCD screen
    sort_top_scores();
    writeSD();
    lcd.printString("GAME",25,1);
    lcd.printString("OVER",25,2);
    lcd.refresh();
    ticker_wait(10);
    lcd.printString("A Retry",40,4);
    lcd.printString("B Back to Menu",0,5);
    lcd.refresh();
    g_press_b_A_flag=0;
    g_press_b_B_flag=0;
    while (1) {
        if (g_press_b_A_flag|g_press_b_B_flag) {
            if (g_press_b_A_flag) {
                initialize_values();
                g_press_b_A_flag=0;
                return 1;
            } else {
                initialize_values();
                g_press_b_B_flag=0;
                return 0;
            }
        }
        sleep();                    //puts mbed to sleep
    }
}

//Print ammo
void print_ammo()
{
    for(int c=0; c<=2; c++) { // 2 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=4; r++) {
            for (int n=70; n<=74; n+=4) {
                if (n==74&ammo%10==0) {
                    if (zero[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==74&ammo%10==1) {
                    if (one[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==74&ammo%10==2) {
                    if (two[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==74&ammo%10==3) {
                    if (three[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==74&ammo%10==4) {
                    if (four[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==74&ammo%10==5) {
                    if (five[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==74&ammo%10==6) {
                    if (six[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==74&ammo%10==7) {
                    if (seven[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==74&ammo%10==8) {
                    if (eight[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==74&ammo%10==9) {
                    if (nine[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                }

                if (n==70&(ammo%100>=0&ammo%100<10)) {
                    if (zero[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==70&(ammo%100>=10&ammo%100<20)) {
                    if (one[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==70&(ammo%100>=20&ammo%100<30)) {
                    if (two[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==70&(ammo%100>=30&ammo%100<40)) {
                    if (three[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==70&(ammo%100>=40&ammo%100<50)) {
                    if (four[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==70&(ammo%100>=50&ammo%100<60)) {
                    if (five[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==70&(ammo%100>=60&ammo%100<70)) {
                    if (six[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==70&(ammo%100>=70&ammo%100<80)) {
                    if (seven[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==70&(ammo%100>=80&ammo%100<90)) {
                    if (eight[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==70&(ammo%100>=90&ammo%100<100)) {
                    if (nine[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                }
            }
        }
    }
    for(int c=0; c<=14; c++) { //14 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=4; r++) {
            if (g_ammo[r][c]==0) {
                lcd.clearPixel(c+50,r);
            } else if (g_ammo[r][c]==1) {
                lcd.setPixel(c+50,r);
            }
        }
    }
    if (ammo>=99) {
        ammo=99;
    }
    lcd.refresh();
}

//Print score
void print_score()
{
    score=h_movement/10+kill_score-shield_score;
    if (score<=0) {
        score=0;
    }
    for(int c=0; c<=2; c++) { //2 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=4; r++) {
            for (int n=24; n<=36; n+=4) {
                if (n==36&score%10==0) {
                    if (zero[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==36&score%10==1) {
                    if (one[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==36&score%10==2) {
                    if (two[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==36&score%10==3) {
                    if (three[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==36&score%10==4) {
                    if (four[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==36&score%10==5) {
                    if (five[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==36&score%10==6) {
                    if (six[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==36&score%10==7) {
                    if (seven[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==36&score%10==8) {
                    if (eight[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==36&score%10==9) {
                    if (nine[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                }

                if (n==32&(score%100>=0&score%100<10)) {
                    if (zero[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==32&(score%100>=10&score%100<20)) {
                    if (one[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==32&(score%100>=20&score%100<30)) {
                    if (two[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==32&(score%100>=30&score%100<40)) {
                    if (three[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==32&(score%100>=40&score%100<50)) {
                    if (four[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==32&(score%100>=50&score%100<60)) {
                    if (five[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==32&(score%100>=60&score%100<70)) {
                    if (six[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==32&(score%100>=70&score%100<80)) {
                    if (seven[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==32&(score%100>=80&score%100<90)) {
                    if (eight[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==32&(score%100>=90&score%100<100)) {
                    if (nine[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                }
                if (n==28&(score%1000>=0&score%1000<100)) {
                    if (zero[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==28&(score%1000>=100&score%1000<200)) {
                    if (one[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==28&(score%1000>=200&score%1000<300)) {
                    if (two[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==28&(score%1000>=300&score%1000<400)) {
                    if (three[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==28&(score%1000>=400&score%1000<500)) {
                    if (four[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==28&(score%1000>=500&score%1000<600)) {
                    if (five[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==28&(score%1000>=600&score%1000<700)) {
                    if (six[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==28&(score%1000>=700&score%1000<800)) {
                    if (seven[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==28&(score%1000>=800&score%1000<900)) {
                    if (eight[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==28&(score%1000>=900&score%1000<1000)) {
                    if (nine[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                }
                if (n==24&(score%10000>=0&score%10000<1000)) {
                    if (zero[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==24&(score%10000>=1000&score%10000<2000)) {
                    if (one[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==24&(score%10000>=2000&score%10000<3000)) {
                    if (two[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==24&(score%10000>=3000&score%10000<4000)) {
                    if (three[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==24&(score%10000>=4000&score%10000<5000)) {
                    if (four[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==24&(score%10000>=5000&score%10000<6000)) {
                    if (five[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==24&(score%10000>=6000&score%10000<7000)) {
                    if (six[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==24&(score%10000>=7000&score%10000<8000)) {
                    if (seven[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==24&(score%10000>=8000&score%10000<9000)) {
                    if (eight[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                } else if (n==24&(score%10000>=9000&score%10000<10000)) {
                    if (nine[r][c]==1) {
                        lcd.setPixel(c+n,r);
                    } else {
                        lcd.clearPixel(c+n,r);
                    }
                }
            }
        }
    }
    for(int c=0; c<=18; c++) { //18 beacause the the loop stats from 0 but the array size from 1
        for(int r=0; r<=4; r++) {
            if (g_score[r][c]==0) {
                lcd.clearPixel(c,r);
            } else if (g_score[r][c]==1) {
                lcd.setPixel(c,r);
            }
        }
    }
    lcd.refresh();
}
