/**
@file main.h
@brief Header file containg functions, variables and prototypes
@brief Revision 1.0
@brief Reverse Parking sensor
@Author Renosi Momoh 
@date March 2015 
**/


#include "mbed.h"
#include "N5110.h"
#include "SRF02/SRF02.h"
#include "buzzer.h"


/** INPUTS AND OUTPUTS  **/

N5110 lcd (PTE26, PTA0, PTC4, PTD0, PTD2, PTD1, PTC3);
/**
@namespace LCD display  
@brief Connections for the LCD Display 
**/
SRF02 sensor(I2C_SDA,I2C_SCL);
/** 
@namespace Ultrasonic sensor connected in I2C mode 
@brief Ultrasonic distance sensor connected in I2C mode
**/
Beep buzzer(PTA2); 
/** 
@namespace Buzzer 
@brief Piezo type buzzer that can produce notes and vary the frequency as well. Connected to Pwm signal 
**/

InterruptIn button(PTB18);
/**
@Brief Button connected to mbed with the use of InterruptIn class**/
InterruptIn sw2(SW2);
/** 
@namespace SW2 button
@brief DigitalIn button
**/
InterruptIn sw3(SW3);

/** 
@namespace SW3 button
@brief DigitalIn button
**/

DigitalOut r_led(PTC2);
/** 
@namespace Led
@brief Changes color depending on distance
**/
Serial serial(USBTX, USBRX);
/**
@Namespace USB connections 
@brief Used for programming the sensor 
**/
AnalogIn pot(PTB2);   
/**
@namespace AnalogIn potentiometer 
@brief Potentiometer middle pin connected to PTB3, other two ends connected to GND and 3.3V
 **/

/** Ticker, flags and Interrupt Service Routines**/

Ticker ticker; //*!< Objects to create tickers for parking sensor in cm */
Ticker ticker2; //*!< Objects to create tickers for radar parking sensor mode */
Ticker ticker3; //*!< Ticker to call interrupt for parking sensor in inches */
void button_isr();
void init_serial();  //*!< function to activate onboard switches and LEDs */
void timer_isr();
volatile int g_timer_flag = 0; /** @Brief G flag makes things easier to distinguish as this is a global variable **/
volatile int g_sw3_flag = 0; //*!< Flag used in interrupt for button 3 */
volatile int g_sw2_flag = 0; //*!< Flag used in interrupt for button 2 */
void sw2_isr(); //*!< Interrupt Service Routine for button 2 */
void sw3_isr(); //*!< Flag used in interrupt for button 3 */
void delete_file(char filename[]); // Function to call for deletion of file.

/** Misc **/

float averageDistance(); 
/**
@namespace Average Distance
@Brief This function allows us to take ten sensor readings and find the average to improve accuracy 
**/
float averageDistanceIn();
/**
@namespace Average Distance in Inches
@Brief Converts the distance from centimetres to inches 
**/

int distance;
/** 
@namespace Distance
@brief Variable for storing integer value for distance in cm(default)
**/
float distanceIn;
/** 
@namespace Distance
@brief Variable for storing integer value for distance in inches
**/

/** Functions **/

void introTune();
/**
@namespace Introductory Tune  
@brief Provides and audible indication that the system is on
**/
void beeping(); 
/**
@namespace Beeping function,
@brief This function allows the sensor to detect the distance and make the speaker beep accordingly
**/
void sensingImage(); 
/**
@Brief This function shows the distance in bars depending on how close an object is
**/
void sensingImageIn();
/**
@namespace Shows the parking sensor distances in inches
@brief Converts the distance into inches
**/
void classicMode1();
void radarMode(); 
/**
Function allows the data to be saved on to an SD card including the time and distance
**/
void saveData();
 /**
 Function will be concurrent with readings and will be intrinsically tied to the actions of the SD card. 
 **/
void loadData(); /** 
Creating a function to allow the data to be loaded when and show the records of all the distances and and times 
**/
void active(); 
/** 
@namespace Active mode in centimetres 
@Brief Main functionality that essentially reads the distance from the sensor and conveys the information via The display and buzzer
**/
void activeIn();
/**
@namespace Active Parking Mode in Inches 
@brief Function to implement active parking mode in inches with the use of tickers and interrupts to save power
**/

void radar();
/**
@namespace Radar
@brief Fucntion calling radar mode so as to allow for use of interrupts 
**/
void sweepSpeed(); 
/** @namespace Sweep Speed
    @Brief Function that varies the rate at which the radar sweeps with the sensor distance 
**/
void mainProg();

/** 
@namespace Main Function
@brief The function containing the main menu to choose functions from 
**/
   
void classicMode(); 
/**
@namespace Screen selection 
@Brief Allow the screen to refresh when the potentiometer is set to reflect output mode due to pot selection
**/

void sweep();
/**@namespace Sweeping Functions
   @Brief  Each of these functions will read the distance from the sensor and set the radar arrow speed across the screen appropriately
**/
void sweepOne();
void sweepTwo();
void sweepThree();
void sweepFour();
void sweepFive();
void sweepSix();
void sweepSeven();
void sweepEight();
void sweepNine();



/** Variables **/

     
float i; 
/*!< Variables used to control rate at which speaker goes off */

float t; 
/*!< Variable used to vary sweep speed.  */



