/**
@file main.h
@brief University of Leeds
@brief ELEC 2645 Embedded System Project
@brief Header file containing functions prototypes, defines and global variables.
@brief The initial documentation was given by Dr.Craig Evans
@author Wang Luyu
@date   May 2016
*/

#include "mbed.h"
#include "N5110.h"

// change this to alter tolerance of joystick direction
#define DIRECTION_TOLERANCE 0.05

/**  
@namespace N5110 lcd
@brief lcd connection
@brief VCC - PTE26
@brief SCE - PTA0
@brief RST - PTC4
@brief D/C - PTD0
@brief MOSI - PTD2
@brief SCLK - PTD1
@brief LED - PTC3 
*/
//    VCC,SCE,RST,D/C,MOSI,SCLK,LED
N5110 lcd (PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);


/**  
@namespace Yellow LED
@brief LED shows the situation of the game
@brief When the pacman 'eat' the 'food', the yellow LED would lit up
*/
// on-board LEDs
Ticker ticker;
DigitalOut yellow_led(PTC2);
// Can also power (VCC) directly from VOUT (3.3 V) -
// Can give better performance due to current limitation from GPIO pin


/**  
@namespace button
@brief lcd pin connection
*/
// connections for joystick
InterruptIn button(PTB11);
/**
@namespace ypot
@brief The y axis potentiometer of joystick
*/
AnalogIn yPot(PTB2);
/**
@namespace xpot
@brief The x axis potentiometer of joystick
*/
AnalogIn xPot(PTB3);

int gameover_flag = 0;  /*!< set gameover flag */

int x_square = rand()%(82-2)+2;  /*!< set the x axis of the point */

int y_square = rand()%(46-2)+2;  /*!< set the y axis of the point */

//0-up 1-down 2-left 3-right
int direction = 0;  /*!< set joystick direction */

// define pacman-x
int Pacman_X = 8;        /*!< set the x axis initial value centre pixel of the pacman */
// define pacman-y
int Pacman_Y = 22;       /*!< set the y axis initial value centre pixel of the pacman */

// define wall-x
int Wall_X = 0;        /*!< set the x axis initial value of the wall */
// define wall-y
int Wall_Y = 0;        /*!< set the y axis initial value of the wall */

// timer to regularly read the joystick
Ticker pollJoystick;
// Serial for debug

int score = 0; /*!< set the initial score value */

volatile int printFlag = 0; /*!< set flag of printing */

/**  
@namespace Joystickbutton
@brief Define the joysitck button 
@brief When joystick button = true, you press the button
@brief Your score would show on the screen
*/
volatile int joystickbutton = false;

/**  
@namespace Joystickbutton
@brief Use the joystick button to see the currently score
*/
void joystickbutton_isr();

/**  
@namespace Eat
@brief Define the pixel that touch the point to 'eat'
@brief All around of the pacman can 'eat' the 'food'
*/
void eat();

/**  
@namespace Food
@brief Define the point
@brief When the point is eaten, it would appear another one
@brief The eaten food would disappeared
*/
void food();

// create enumerated type (0,1,2,3 etc. for direction)
// could be extended for diagonals etc.
enum DirectionName {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    CENTRE,
    UNKNOWN
};

// struct for Joystick
typedef struct JoyStick Joystick;
struct JoyStick {
    float x;    // current x value
    float x0;   // 'centred' x value
    float y;    // current y value
    float y0;   // 'centred' y value
    int button; // button state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    DirectionName direction;  // current direction
};

/**  
@namespace Joystick
@brief Create struct variable
*/
// create struct variable
Joystick joystick;

/**  
@namespace CalibrateJoystick
@brief Set calibrateJoystick 
*/
// function prototypes
void calibrateJoystick();

/**  
@namespace UpdateJoystick
@brief Set the speed of updateJoystick
*/
void updateJoystick();

/**  
@namespace YellowLED
@brief Set-up the on-board LEDs
*/
// set-up the on-board LEDs
void yellow();
