#include "main.h"

volatile int eat_flag = 0;

void PacmanRight(int pacman_x, int pacman_y)    //draw the pacman that the mouth in the right
{
    for (int  m=pacman_x-1; m<=pacman_x+1; m++) 
    {
        lcd.setPixel (m, pacman_y-4);
        lcd.setPixel (m, pacman_y+4);
    }

    for (int n=pacman_x-3; n<=pacman_x+3; n++) 
    {
        lcd.setPixel (n, pacman_y-3);
        lcd.setPixel (n-1, pacman_y-1);
        lcd.setPixel (n-1, pacman_y+1);
        lcd.setPixel (n, pacman_y+3);
    }

    for (int p=pacman_x-3; p<=pacman_x+4; p++) 
    {
        lcd.setPixel (p, pacman_y-2);
        lcd.setPixel (p, pacman_y+2);
    }

    for (int q=pacman_x-4; q<=pacman_x; q++) 
    {
        lcd.setPixel (q, pacman_y);
    }
}

void PacmanLeft (int pacman_x, int pacman_y)    // draw the pacman that the mouth in the left
{
    for (int  m=pacman_x-1; m<=pacman_x+1; m++) 
    {
        lcd.setPixel (m, pacman_y-4);
        lcd.setPixel (m, pacman_y+4);
    }

    for (int n=pacman_x-3; n<=pacman_x+3; n++) 
    {
        lcd.setPixel (n, pacman_y-3);
        lcd.setPixel (n+1, pacman_y-1);
        lcd.setPixel (n+1, pacman_y+1);
        lcd.setPixel (n, pacman_y+3);
    }

    for (int p=pacman_x-4; p<=pacman_x+3; p++) 
    {
        lcd.setPixel (p, pacman_y-2);
        lcd.setPixel (p, pacman_y+2);
    }

    for (int q=pacman_x; q<=pacman_x+4; q++) 
    {
        lcd.setPixel (q, pacman_y);
    }
}

void PacmanDown(int pacman_x, int pacman_y)    //draw the pacman that the mouth in the below
{
    for (int  m=pacman_y-1; m<=pacman_y+1; m++) 
    {
        lcd.setPixel (pacman_x-4, m);
        lcd.setPixel (pacman_x+4, m);
    }

    for (int n=pacman_y-3; n<=pacman_y+3; n++) 
    {
        lcd.setPixel (pacman_x-3, n);
        lcd.setPixel (pacman_x-1, n-1);
        lcd.setPixel (pacman_x+1, n-1);
        lcd.setPixel (pacman_x+3, n);
    }

    for (int p=pacman_y-3; p<=pacman_y+4; p++) 
    {
        lcd.setPixel (pacman_x-2, p);
        lcd.setPixel (pacman_x+2, p);
    }

    for (int q=pacman_y-4; q<=pacman_y; q++) 
    {
        lcd.setPixel (pacman_x, q);
    }
}

void PacmanUp(int pacman_x, int pacman_y)    //draw the pacman that the mouth in the above
{
    for (int  m=pacman_y-1; m<=pacman_y+1; m++) 
    {
        lcd.setPixel (pacman_x-4, m);
        lcd.setPixel (pacman_x+4, m);
    }

    for (int n=pacman_y-3; n<=pacman_y+3; n++) 
    {
        lcd.setPixel (pacman_x-3, n);
        lcd.setPixel (pacman_x-1, n+1);
        lcd.setPixel (pacman_x+1, n+1);
        lcd.setPixel (pacman_x+3, n);
    }

    for (int p=pacman_y-4; p<=pacman_y+3; p++) 
    {
        lcd.setPixel (pacman_x-2, p);
        lcd.setPixel (pacman_x+2, p);
    }

    for (int q=pacman_y; q<=pacman_y+4; q++) 
    {
        lcd.setPixel (pacman_x, q);
    }
}

void Wall(int wall_x, int wall_y)        // draw the wall
{
    for (int k=wall_x; k<=wall_x+83; k++)   // the x direction of the wall
    {      
        lcd.setPixel (k, wall_y);
        lcd.setPixel (k, wall_y+47);

        for (int t=wall_y; t<=wall_y+47; t++)   // the y direction of the wall
        {      
            lcd.setPixel (wall_x, t);
            lcd.setPixel (wall_x+83, t);
        }
    }
}

int main()
{
    // Use the joystick button to see the currently score
    button.fall(&joystickbutton_isr);
    // Set the operation of the button, pull down
    button.mode(PullDown);
    
    // first need to initialise display
    lcd.init();

    // these are default settings so not strictly needed
    lcd.normalMode();           // normal colour mode
    lcd.setBrightness(0.5);     // put LED backlight on 50%

    // can directly print strings at specified co-ordinates
    lcd.printString("FOODIE",24,1);
    lcd.printString("PACMAN",24,3);
    wait(5.0);
    lcd.clear();

    //show the designer's name and student number
    lcd.printString("by Wang Luyu",6,2);
    lcd.printString("200985894",15,4);
    wait(5.0);
    lcd.clear();

    calibrateJoystick();

    // update the location by using Joystick
    // every 0.05 second update the location
    pollJoystick.attach(&updateJoystick,0.05);
    yellow_led = 1;
    
    while(1) {
        if (joystickbutton == true) 
        {
            // present the wall
            Wall(Wall_X, Wall_Y);

            // present the pacman
            PacmanRight(Pacman_X, Pacman_Y);

            // if the pacman touch the wall, game over and shows the score
            if(Pacman_X-5 == 0||Pacman_X+5 == 83||Pacman_Y-5 == 0||Pacman_Y+5 == 47) 
            {
                gameover_flag = 1;
            
                if (gameover_flag == 1) 
                {
                    lcd.clear();
                    lcd.printString("GAME OVER",15,1);
                    char s[14];
                    sprintf(s,"SCORE: %d",score);
                    lcd.printString(s,15,3);
                }
                break;
            }

            if (printFlag)   // if flag set, clear flag and print joystick values to serial port
            {
                printFlag = 0;
                yellow_led=0;
                eat();
                lcd.clear();
                food();

                // check joystick direction
                if (joystick.direction == UP) 
                {
                    Pacman_Y += 1;
                }

                if (joystick.direction == DOWN) 
                {
                    Pacman_Y -= 1;
                }

                if (joystick.direction == LEFT) 
                {
                    Pacman_X += 1;
                }

                if (joystick.direction == RIGHT) 
                {
                    Pacman_X -= 1;
                }

                if (joystick.direction == CENTRE) 
                {
                    //PacmanRight(Pacman_X, Pacman_Y);
                }
            
                if (joystick.direction == UNKNOWN) 
                {
                    //PacmanRight(Pacman_X, Pacman_Y);
                }
            }
            lcd.refresh();   // need to refresh screen
        }
        
        else
        {
            lcd.clear();
            char s[14];
            sprintf(s,"SCORE: %d",score);
            lcd.printString(s,15,2);
            lcd.refresh();
        }
    }
}

// read default positions of the joystick to calibrate later readings
void calibrateJoystick()
{
    button.mode(PullDown);
    
    // must not move during calibration
    joystick.x0 = xPot;  // initial positions in the range 0.0 to 1.0 (0.5 if centred exactly)
    joystick.y0 = yPot;
}

void updateJoystick()
{
    // read current joystick values relative to calibrated values (in range -0.5 to 0.5, 0.0 is centred)
    joystick.x = xPot - joystick.x0;
    joystick.y = yPot - joystick.y0;

    // read button state
    joystick.button = button;

    // calculate direction depending on x,y values
    // tolerance allows a little lee-way in case joystick not exactly in the stated direction
    if ( fabs(joystick.y) < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = CENTRE;
    } else if ( joystick.y > DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = UP;
    } else if ( joystick.y < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = DOWN;
    } else if ( joystick.x > DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = RIGHT;
    } else if ( joystick.x < DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = LEFT;
    } else {
        joystick.direction = UNKNOWN;
    }

    // set flag for printing
    printFlag = 1;
}

void eat()
{
    eat_flag = 0;
    
    // the right of the pacman can eat the point
    // when the point on the right edge touch the point
    // the pacman can 'eat' the 'food'
    if (lcd.getPixel(Pacman_X+5,Pacman_Y-2)||lcd.getPixel(Pacman_X+5,Pacman_Y)||lcd.getPixel(Pacman_X+5,Pacman_Y+2)) {
        eat_flag = 1;
        yellow_led = 1;
        score++;
    }
    
    // the left of the pacman can eat the point
    // when the point on the left edge touch the point
    // the pacman can 'eat' the 'food'
    if (lcd.getPixel(Pacman_X-5,Pacman_Y-2)||lcd.getPixel(Pacman_X-5,Pacman_Y)||lcd.getPixel(Pacman_X-5,Pacman_Y+2)) {
        eat_flag = 1;
        yellow_led = 1;
        score++;
    }
    
    // the top of the pacman can eat the point
    // when the point on the upper edge touch the point
    // the pacman can 'eat' the 'food'
    if (lcd.getPixel(Pacman_X+2,Pacman_Y-5)||lcd.getPixel(Pacman_X,Pacman_Y-5)||lcd.getPixel(Pacman_X-2,Pacman_Y-5)) {
        eat_flag = 1;
        yellow_led = 1;
        score++;
    }
    
    // the bottom of the pacman can eat the point
    // when the point on the bottom edge touch the point
    // the pacman can 'eat' the 'food'
    if (lcd.getPixel(Pacman_X+2,Pacman_Y+5)||lcd.getPixel(Pacman_X,Pacman_Y+5)||lcd.getPixel(Pacman_X-2,Pacman_Y+5)) {
        eat_flag = 1;
        yellow_led = 1;
        score++;
    } 
}

void food()
{
    if (eat_flag) {
        // new food
        x_square = rand()%(82-2)+2;
        y_square = rand()%(46-2)+2;
        lcd.drawRect(x_square,y_square,2,2,1);
    } 
    else if(eat_flag == 0) {
        lcd.drawRect(x_square,y_square,2,2,1);
    }
}

void yellow()
{
    // on-board LEDs are active-low, so set pin high to turn them off.
    yellow_led = ! yellow_led;
}


void joystickbutton_isr()
{
    // use the joystick button to see the currently score
    joystickbutton = !joystickbutton;
}
