/**
@file Mobs.h
@brief The header file containing the mob code.
@brief Revision 9.9.
@author Jacob Markl
@date   May 2016
*/
#ifndef Mobs_H
#define Mobs_H

#include "Main.h"
#include "Arrays.h"
#include "Variables.h"
/**
preforms all the movement for the rat mob and draws it to g_screen
@param mobnum - the mob number passed from mobturn();
@returns a rat mob on the g_screen array
*/
void rat(int mobnum);
/**
preforms all the movement for the frog mob and draws it to g_screen in the location given by g_mobs array
@param mobnum - the mob number passed from mobturn();
@returns a frog mob on the g_screen array
*/
void frog(int mobnum);
/**
preforms all the movement for the crab mob and draws it to g_screen in the location given by g_mobs array
@param mobnum - the mob number passed from mobturn();
@returns a crab mob on the g_screen array
*/
void crab(int mobnum);
/**
preforms all the movement for the shroom mob and draws it to g_screen in the location given by g_mobs array
@param mobnum - the mob number passed from mobturn();
@returns a shroom mob on the g_screen array
*/
void shroom(int mobnum);
/**
preforms all the movement for the boss mob and draws it to g_screen in the location given by g_mobs array
@param mobnum - the mob number passed from mobturn();
@returns a boss mob on the g_screen array
*/
void boss(int mobnum);
/**
draws the heart sprite to g_screen in the location given by g_mobs array
@param mobnum - the mob number passed from mobturn(); 
@returns a heart on the g_screen array
*/
void heart(int mobnum);
/**
initializes the g_mobs for a map, based off the mobcode for each map. Is checked when a new map is loaded
*/
void mobs()
{
    if (cfsm[g_state].cleared==1) {
        for(int x = 0; x < 4; x++) {
            for (int y = 0; y < 5 ; y++) {
                g_mobs[y][x] = 0;
            }
        }
    } else {
        for(int x = 0; x < 4; x++) {
            for (int y = 0; y < 5 ; y++) {
                g_mobs[y][x] = 0;
            }
        }
        switch (cfsm[g_state].mobcode) {

            case 0:
                break;

            case 1:
                g_mobs[0][0]= 1;
                g_mobs[0][1]= 4;
                g_mobs[0][2]= 1;
                g_mobs[0][3]= 0;

                g_mobs[1][0]= 3;
                g_mobs[1][1]= 5;
                g_mobs[1][2]= 5;
                g_mobs[1][3]= 0;
                break;

            case 2:
                g_mobs[0][0]= 2;
                g_mobs[0][1]= 1;
                g_mobs[0][2]= 5;
                g_mobs[0][3]= 0;

                g_mobs[1][0]= 2;
                g_mobs[1][1]= 1;
                g_mobs[1][2]= 6;
                g_mobs[1][3]= 0;

                g_mobs[2][0]= 3;
                g_mobs[2][1]= 1;
                g_mobs[2][2]= 2;
                g_mobs[2][3]= 0;
                break;

            case 3:
                g_mobs[0][0]= 2;
                g_mobs[0][1]= 1;
                g_mobs[0][2]= 1;
                g_mobs[0][3]= 0;

                g_mobs[1][0]= 2;
                g_mobs[1][1]= 1;
                g_mobs[1][2]= 6;
                g_mobs[1][3]= 0;

                g_mobs[2][0]= 3;
                g_mobs[2][1]= 5;
                g_mobs[2][2]= 2;
                g_mobs[2][3]= 0;

                g_mobs[3][0]= 3;
                g_mobs[3][1]= 5;
                g_mobs[3][2]= 5;
                g_mobs[3][3]= 0;
                break;

            case 4:
                g_mobs[0][0]= 2;
                g_mobs[0][1]= 1;
                g_mobs[0][2]= 4;
                g_mobs[0][3]= 0;

                g_mobs[1][0]= 6;
                g_mobs[1][1]= 3;
                g_mobs[1][2]= 2;
                g_mobs[1][3]= 0;

                break;
            case 5:
                g_mobs[0][0]= 1;
                g_mobs[0][1]= 1;
                g_mobs[0][2]= 4;
                g_mobs[0][3]= 0;

                g_mobs[1][0]= 3;
                g_mobs[1][1]= 1;
                g_mobs[1][2]= 1;
                g_mobs[1][3]= 0;

                g_mobs[2][0]= 4;
                g_mobs[2][1]= 5;
                g_mobs[2][2]= 1;
                g_mobs[2][3]= 0;

                break;
            case 6:
                g_mobs[0][0]= 5;
                g_mobs[0][1]= 2;
                g_mobs[0][2]= 5;
                g_mobs[0][3]= 1;
                break;

            case 7:
                g_mobs[0][0]= 3;
                g_mobs[0][1]= 1;
                g_mobs[0][2]= 4;
                g_mobs[0][3]= 0;

                g_mobs[1][0]= 4;
                g_mobs[1][1]= 2;
                g_mobs[1][2]= 1;
                g_mobs[1][3]= 0;

                g_mobs[2][0]= 3;
                g_mobs[2][1]= 4;
                g_mobs[2][2]= 4;
                g_mobs[2][3]= 0;

                break;

            case 8:
                g_mobs[0][0]= 4;
                g_mobs[0][1]= 1;
                g_mobs[0][2]= 2;
                g_mobs[0][3]= 0;

                g_mobs[1][0]= 4;
                g_mobs[1][1]= 3;
                g_mobs[1][2]= 4;
                g_mobs[1][3]= 0;

                break;

            case 9:
                g_mobs[0][0]= 1;
                g_mobs[0][1]= 2;
                g_mobs[0][2]= 1;
                g_mobs[0][3]= 1;

                g_mobs[1][0]= 1;
                g_mobs[1][1]= 5;
                g_mobs[1][2]= 1;
                g_mobs[1][3]= 1;

                g_mobs[2][0]= 1;
                g_mobs[2][1]= 5;
                g_mobs[2][2]= 4;
                g_mobs[2][3]= 1;

                g_mobs[3][0]= 1;
                g_mobs[3][1]= 2;
                g_mobs[3][2]= 4;
                g_mobs[3][3]= 1;
                break;

            case 10:
                g_mobs[0][0]= 4;
                g_mobs[0][1]= 3;
                g_mobs[0][2]= 4;
                g_mobs[0][3]= 0;

                g_mobs[1][0]= 4;
                g_mobs[1][1]= 4;
                g_mobs[1][2]= 4;
                g_mobs[1][3]= 0;

                g_mobs[2][0]= 3;
                g_mobs[2][1]= 3;
                g_mobs[2][2]= 3;
                g_mobs[2][3]= 0;
                break;

            case 11:
                g_mobs[0][0]= 2;
                g_mobs[0][1]= 1;
                g_mobs[0][2]= 6;
                g_mobs[0][3]= 0;

                g_mobs[1][0]= 3;
                g_mobs[1][1]= 3;
                g_mobs[1][2]= 2;
                g_mobs[1][3]= 0;

                g_mobs[2][0]= 4;
                g_mobs[2][1]= 6;
                g_mobs[2][2]= 1;
                g_mobs[2][3]= 0;

                g_mobs[4][0]= 6;
                g_mobs[4][1]= 1;
                g_mobs[4][2]= 5;
                g_mobs[4][3]= 0;
                break;


            default:
                break;
        }
    }
}
/**
calls the functions for every mob that is currently on the map
*/
void mobturn()
{
    for(int y = 0; y < 5; y++) {
        switch(g_mobs[y][0]) {

            case 1:
                rat(y);
                break;
            case 2:
                frog(y);
                break;
            case 3:
                crab(y);
                break;
            case 4:
                shroom(y);
                break;
            case 5:
                boss(y);
                break;
            case 6:
                heart(y);
                break;
            default:
                break;
        }
    }
}


void frog(int mobnum)
{
    int frog[6][6];

    switch (frogfsm[g_mobs[mobnum][3]].facing) {
        case 1:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    frog[x][y] = g_frog[x][y];
                }
            }
            break;

        case 2:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    frog[x][y] = g_frog[5-y][x];
                }
            }

            break;
        case 3:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    frog[x][y] = g_frog[5-x][5-y];
                }
            }
            break;
        case 4:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    frog[x][y] = g_frog[y][5-x];
                }
            }

            break;

        default:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    frog[x][y] = g_frog[x][y];
                }
            }
            break;
    }
    if (g_timer1_flag == 1) {
        if (((g_mobs[mobnum][1]+frogfsm[g_mobs[mobnum][3]].nextx)==g_playerlocationx)and((g_mobs[mobnum][2]+frogfsm[g_mobs[mobnum][3]].nexty)==g_playerlocationy)) {
            if (g_playerinvun==0) {
                g_playerhp--;
                g_playerinvun=4;
            }
        } else {
            g_mobs[mobnum][1] = g_mobs[mobnum][1]+frogfsm[g_mobs[mobnum][3]].nextx;
            g_mobs[mobnum][2] = g_mobs[mobnum][2]+frogfsm[g_mobs[mobnum][3]].nexty;
            g_mobs[mobnum][3] = frogfsm[g_mobs[mobnum][3]].nextstate;
        }
    }
    int mapx = g_mobs[mobnum][2]*6;
    int mapy = g_mobs[mobnum][1]*6;
    for(int x = 0; x < 6; x++) {
        for (int y = 0; y < 6 ; y++) {
            g_screen[mapy+y][mapx+x] = 16+frog[x][y];

        }
    }
}

void rat(int mobnum)
{
    int rat[6][6];

    switch (ratfsm[g_mobs[mobnum][3]].facing) {
        case 1:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    rat[x][y] = g_rat[x][y];
                }
            }
            break;

        case 2:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    rat[x][y] = g_rat[5-y][x];
                }
            }

            break;
        case 3:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    rat[x][y] = g_rat[5-x][5-y];
                }
            }
            break;
        case 4:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    rat[x][y] = g_rat[y][5-x];
                }
            }

            break;

        default:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    rat[x][y] = g_rat[x][y];
                }
            }
            break;
    }
    if (g_timer1_flag == 1) {
        if (((g_mobs[mobnum][1]+ratfsm[g_mobs[mobnum][3]].nextx)==g_playerlocationx)and((g_mobs[mobnum][2]+ratfsm[g_mobs[mobnum][3]].nexty)==g_playerlocationy)) {
            if (g_playerinvun==0) {
                g_playerhp--;
                g_playerinvun=4;
            }
        } else {
            g_mobs[mobnum][1] = g_mobs[mobnum][1]+ratfsm[g_mobs[mobnum][3]].nextx;
            g_mobs[mobnum][2] = g_mobs[mobnum][2]+ratfsm[g_mobs[mobnum][3]].nexty;
            g_mobs[mobnum][3] = ratfsm[g_mobs[mobnum][3]].nextstate;
        }
    }
    int mapx = g_mobs[mobnum][2]*6;
    int mapy = g_mobs[mobnum][1]*6;
    for(int x = 0; x < 6; x++) {
        for (int y = 0; y < 6 ; y++) {
            g_screen[mapy+y][mapx+x] = 14+rat[x][y];

        }
    }
}

void crab(int mobnum)
{
    int crab[6][6];

    switch (crabfsm[g_mobs[mobnum][3]].facing) {
        case 1:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    crab[x][y] = g_crab[x][y];
                }
            }
            break;

        case 2:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    crab[x][y] = g_crab[5-y][x];
                }
            }

            break;
        case 3:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    crab[x][y] = g_crab[5-x][5-y];
                }
            }
            break;
        case 4:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    crab[x][y] = g_crab[y][5-x];
                }
            }

            break;

        default:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    crab[x][y] = g_crab[x][y];
                }
            }
            break;
    }
    if (g_timer1_flag == 1) {
        if (((g_mobs[mobnum][1]+crabfsm[g_mobs[mobnum][3]].nextx)==g_playerlocationx)and((g_mobs[mobnum][2]+crabfsm[g_mobs[mobnum][3]].nexty)==g_playerlocationy)) {
            if (g_playerinvun==0) {
                g_playerhp--;
                g_playerinvun=4;
            }
        } else {
            g_mobs[mobnum][1] = g_mobs[mobnum][1]+crabfsm[g_mobs[mobnum][3]].nextx;
            g_mobs[mobnum][2] = g_mobs[mobnum][2]+crabfsm[g_mobs[mobnum][3]].nexty;
            g_mobs[mobnum][3] = crabfsm[g_mobs[mobnum][3]].nextstate;
        }
    }
    int mapx = g_mobs[mobnum][2]*6;
    int mapy = g_mobs[mobnum][1]*6;
    for(int x = 0; x < 6; x++) {
        for (int y = 0; y < 6 ; y++) {
            g_screen[mapy+y][mapx+x] = 14+crab[x][y];

        }
    }
}

void shroom(int mobnum)
{
    int shroom[6][6];

    switch (shroomfsm[g_mobs[mobnum][3]].facing) {
        case 1:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    shroom[x][y] = g_shroom[x][y];
                }
            }
            break;

        case 2:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    shroom[x][y] = g_shroom[5-y][x];
                }
            }

            break;
        case 3:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    shroom[x][y] = g_shroom[5-x][5-y];
                }
            }
            break;
        case 4:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    shroom[x][y] = g_shroom[y][5-x];
                }
            }

            break;

        default:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    shroom[x][y] = g_shroom[x][y];
                }
            }
            break;
    }
    if (g_timer1_flag == 1) {
        if (((g_mobs[mobnum][1]+shroomfsm[g_mobs[mobnum][3]].nextx)==g_playerlocationx)and((g_mobs[mobnum][2]+shroomfsm[g_mobs[mobnum][3]].nexty)==g_playerlocationy)) {
            if (g_playerinvun==0) {
                g_playerhp--;
                g_playerinvun=4;
            }
        } else {
            g_mobs[mobnum][1] = g_mobs[mobnum][1]+shroomfsm[g_mobs[mobnum][3]].nextx;
            g_mobs[mobnum][2] = g_mobs[mobnum][2]+shroomfsm[g_mobs[mobnum][3]].nexty;
            g_mobs[mobnum][3] = shroomfsm[g_mobs[mobnum][3]].nextstate;
        }
    }
    int mapx = g_mobs[mobnum][2]*6;
    int mapy = g_mobs[mobnum][1]*6;
    for(int x = 0; x < 6; x++) {
        for (int y = 0; y < 6 ; y++) {
            g_screen[mapy+y][mapx+x] = 14+shroom[x][y];

        }
    }
}


void heart(int mobnum)
{
    int heart[6][6];

    for(int x = 0; x < 6; x++) {
        for (int y = 0; y < 6 ; y++) {
            heart[x][y] = g_heart[x][y];
        }
    }

    int mapx = g_mobs[mobnum][2]*6;
    int mapy = g_mobs[mobnum][1]*6;
    for(int x = 0; x < 6; x++) {
        for (int y = 0; y < 6 ; y++) {
            g_screen[mapy+y][mapx+x] = 16+heart[x][y];

        }
    }
}


void boss(int mobnum)
{
    int boss[6][6];

    switch (bossfsm[g_mobs[mobnum][3]].facing) {
        case 1:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    boss[x][y] = g_boss[x][5-y];
                }
            }

            break;
        case 2:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    boss[x][y] = g_boss[x][y];
                }
            }
            break;


        default:
            for(int x = 0; x < 6; x++) {
                for (int y = 0; y < 6 ; y++) {
                    boss[x][y] = g_boss[x][y];
                }
            }
            break;
    }
    if (g_timer1_flag == 1) {
        if (((g_mobs[mobnum][1]+bossfsm[g_mobs[mobnum][3]].nextx)==g_playerlocationx)and((g_mobs[mobnum][2]+bossfsm[g_mobs[mobnum][3]].nexty)==g_playerlocationy)) {
            if (g_playerinvun==0) {
                g_playerhp--;
                g_playerinvun=4;
            }
        } else {
            g_mobs[mobnum][1] = g_mobs[mobnum][1]+bossfsm[g_mobs[mobnum][3]].nextx;
            g_mobs[mobnum][2] = g_mobs[mobnum][2]+bossfsm[g_mobs[mobnum][3]].nexty;
            g_mobs[mobnum][3] = bossfsm[g_mobs[mobnum][3]].nextstate;
        }
    }
    int mapx = g_mobs[mobnum][2]*6;
    int mapy = g_mobs[mobnum][1]*6;
    for(int x = 0; x < 6; x++) {
        for (int y = 0; y < 6 ; y++) {
            g_screen[mapy+y][mapx+x] = 14+boss[x][y];

        }
    }
}



#endif