/**
@file Variables.h
@brief The header file containing the global variables.
@brief Revision 9.9.
@author Jacob Markl
@date   May 2016
*/

#ifndef Variables_H
#define Variables_H


bool g_music = true;/*!< if music is on, value is true */
bool g_playersprite = false;/*!<if the player is attacking, value is true */
bool g_gamewon = false;/*!< if the player wins the game, value is true */

int g_level = 1;/*!< the currently selected level */
int g_isidle = 0;/*!< a flag for if the player goes idle */
int g_select = 0;/*!<the current selected menu option */
int g_options = 0;/*!< the ammount of menu options availalbe */
int g_direction = 0;/*!<the current movement direction of the map */
int g_playerfacing = 0;/*!< the direction the player is facing */
int g_playerinvun = 0;/*!< how long the player is invurable for */
int g_playerdirection = 4;/*!< the current direction the player is moveing */
int g_playerlocationy = 4;/*!< the players y coord */
int g_playerlocationx = 2;/*!< the players x coord */
int g_playerhp = 3;/*!< the players current hp */
int g_state = 0;/*!< the current map state */
int g_playtime = 0;/*!<the total playtime for the current run */
int g_score = 0;/*!< the players score */
int g_layout[8][8];/*!< the layout array for the current map */
int g_screen[48][48];/*!< the screen array for the urrent map */
int g_topscores[3]= {0,0,0};/*!< the topscore array */
int g_mobs[5][4]= {
    {0,0,0,0},
    {0,0,0,0},
    {0,0,0,0},
    {0,0,0,0},
    {0,0,0,0}
};/*!<the current mobs on the map array */
float g_songdefault[9]= {0.5,1175,1245,1175,1480,1397,1175,1245,1109};/*!<the song that is played when the sd cant be loaded */

volatile int g_BUI_flag = 0;/*!<the volatile up button flag */
volatile int g_BRI_flag = 0;/*!<the volatile right button flag */
volatile int g_BDI_flag = 0;/*!<the volatile down button flag */
volatile int g_BLI_flag = 0;/*!<the volatile left button flag */
volatile int g_BAI_flag = 0;/*!<the volatile A button flag */
volatile int g_BBI_flag = 0;/*!<the volatile B button flag */
volatile int g_timer1_flag = 0;/*!<the volatile timer1 flag */
volatile int g_timer2_flag = 0;/*!<the volatile timer2 flag */
volatile int g_idle_flag = 0;/*!<the volatile idle timeout flag */

#endif