/**
@file Tickersandmore.h
@brief The header file containing Tickers, Timeouts, and the pins for the I/Os.
@brief Revision 9.9.
@author Jacob Markl
@date   May 2016
*/

#ifndef Tick_H
#define Tick_H

#include "SDcard.h"
/**
@namespace ticker1
@brief A Ticker that provides the game timing
*/
Ticker ticker1;
/**
@namespace ticker2
@brief A Ticker that provides the music timing
*/
Ticker ticker2;
/**
@namespace tout
@brief A Timeout that triggers the pwm note stop
*/
Timeout tout;
/**
@namespace idle
@brief A Timeout that triggers the timing out from the player not acting for so long.
*/
Timeout idle;
/**
@namespace idle
@brief A Timeout that triggers the timing out from the player not acting for so long.
*/
PwmOut Buzz(PTA2);
/**
@namespace BUI
@brief An InterruptIn for the up button.
*/
InterruptIn BUI(PTB18);
/**
@namespace BRI
@brief An InterruptIn for the right button.
*/
InterruptIn BRI(PTB19);
/**
@namespace BDI
@brief An InterruptIn for the down button.
*/
InterruptIn BDI(PTC1);
/**
@namespace BLI
@brief An InterruptIn for the left button.
*/
InterruptIn BLI(PTC8);
/**
@namespace BAI
@brief An InterruptIn for the A button.
*/
InterruptIn BAI(PTB3);
/**
@namespace BBI
@brief An InterruptIn for the B button.
*/
InterruptIn BBI(PTB2);
/**
@namespace lcd
@brief the pin deffinitions for the N5110 lcd.
*/
//         VCC,    SCE,   RST,   D/C,   MOSI,  SCLK,   LED
N5110 lcd (PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);

/**
@namespace sd
@brief the pin deffinitions for the SDcard.
*/
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd");


#endif