/**
@file SDcard.h
@brief The header file containing functions for the SDcard.
@brief Revision 9.9.
@author Jacob Markl
@date   May 2016
*/

#ifndef SDcard_H
#define SDcard_H

#include "SDFileSystem.h"
#include "Main.h"
#include "Variables.h"
#include "Main.h"

FILE *topscore;
FILE *song;
std::vector<float> g_musicarray;
using namespace std;


/**
checks if the top score file exists, if it does then it closes the file and removes it
if the file does not exist it creates a new file, writes it blank and closes it.
*/
void clearsd()
{
    topscore = fopen("/sd/topscore.txt", "r");
    if (topscore != NULL) {
        fclose(topscore);
        remove("/sd/topscore.txt");
    }
    topscore = fopen("/sd/topscore.txt", "w");
    fprintf(topscore, "0,0,0");
    fclose(topscore);
}

/**
writes a topscore file, fills it with the g_topscore array and closes it.
*/
void writesd()
{

    topscore = fopen("/sd/topscore.txt", "w");
    if (topscore!=NULL) {
        fprintf(topscore, "%d,%d,%d",g_topscores[0],g_topscores[1],g_topscores[2]);
        fclose(topscore);
    }

}
/**
clears the g_musicarray
reads the song stored on the sd card and stores it in the g_musicarray if the song file exists
if the song does not exist then it stores the g_songdefault in the g_musicarray
*/
void readsong()
{

    song = fopen("/sd/song.txt", "r");
    if (song==NULL) {
        song = fopen("/sd/song.txt", "r");
    }
    g_musicarray.clear();
    if (song==NULL) {
        for (int y = 0; y < (((sizeof(g_songdefault))/(sizeof(g_songdefault[0])))-1) ; y++) {
            g_musicarray.push_back(g_songdefault[y]);
        }
    } else {
        int i = 0;
        float note=0;
        while (fscanf(song, "%f,",&note) != EOF) {
            g_musicarray.push_back(note);
            i++;
        }
        fclose(song);
    }

}
/**
reads from the sd card and store the high scores in the g_topscores array
if the file does not exist, then write a new blank file
*/
void readsd()
{
    int value1;
    int value2;
    int value3;
    topscore = fopen("/sd/topscore.txt", "r");
    if (topscore==NULL) {
        topscore = fopen("/sd/topscore.txt", "r");
        if (topscore==NULL) {
            writesd();
        }
    }
    if (topscore!=NULL) {
        fscanf(topscore, "%d,%d,%d",&value1,&value2,&value3);
        g_topscores[0]=value1;
        g_topscores[1]=value2;
        g_topscores[2]=value3;
        fclose(topscore);
    }
    else{
         g_topscores[0]=0;
        g_topscores[1]=0;
        g_topscores[2]=0;
        }

}
#endif