/**
@file Main.h
@brief The header file containing the main functions for the game.
@brief Revision 9.9.
@author Jacob Markl
@date   May 2016
*/
#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"
#include "N5110.h"
#include <vector>




/**
Initialises the mbed and peripherals
*/
void init_K64F();

/**
Toggles the Up button flag
*/
void BUI_isr();
/**
Toggles the Right button flag
*/
void BRI_isr();
/**
Toggles the Down button flag
*/
void BDI_isr();
/**
Toggles the Left button flag
*/
void BLI_isr();
/**
Toggles the A button flag
*/
void BAI_isr();
/**
Toggles the B button flag
*/
void BBI_isr();
/**
Selects the current layout and bulids the map for the game, with the sprites for each point
@param mapnumber - the current mapnumber, passed from the game function
@returns a filled g_screen array
*/
void map_builder(int mapnumber);
/**
Bulids the current player sprite for the game and draws it on g_screen
*/
void player_builder();
/**
Draws the screen onto the lcd. Loops through g_screen and sets each pixel
*/
void screen_builder();
/**
changes the next location and direction of the player sprite based on the inputs from the player
*/
void player_movement();
/**
calls the attack animation and checks for the mobs in the attacked space
*/
void Attack();
/**
calculates and displays the stats on the side of the screen
*/
void stats();
/**
toggles the timer1 flag
*/
void timer1_isr();
/**
toggles the timer 2 flag
*/
void timer2_isr();
/**
checks each button flag for the next movement or action
*/
void buttons();
/**
initializes the game variables
*/
void init_game();
/**
raises the isidle flag when triggered
*/
void outidle();
/**
shows the win screen and calls the score saving function
*/
void win();
/**
show the lose screen and calls the score saving function
*/
void lose();
/**
displays the main menu and controls the inputs for it
*/
void main_menu();
/**
displays the game screen and stats, runs untill the win or lose screen is called
*/
void game();
/**
displays the settings menu and controls the inputs for it
*/
void settings();

/**
sorts the current score into the high score array
*/
void addtopscore();
/**
displayes the highscore screen
*/
void highscores();
/**
displays the tutorial for the game
*/
void tutorial();
/**
turns the current note off when called from tout
*/
void timeoutsound();
/**
shows the intro screen for the game
*/
void startscreen();
/**
draws lines for the tutorial
*/
void drawlines();
/**
pauses on the Level 2 intro screen between levels
*/
void level2screen();


#endif