#include "mbed.h"
#include "N5110.h"
#include "functions.h"

void UserPaddle() //Paddle used by user

{
    lcd.setPixel(0,yp);
    lcd.setPixel(0,yp+1);
    lcd.setPixel(0,yp+2);
    lcd.setPixel(0,yp+3);
    lcd.setPixel(0,yp+4);
    lcd.setPixel(0,yp+5);
    lcd.setPixel(0,yp+6);
    lcd.setPixel(0,yp+7);
    lcd.setPixel(0,yp+8);
    lcd.setPixel(0,yp+9);

}

void ComputerPaddle() //Paddle controlled by the computer

{
    lcd.setPixel(83,yc);
    lcd.setPixel(83,yc+1);
    lcd.setPixel(83,yc+2);
    lcd.setPixel(83,yc+3);
    lcd.setPixel(83,yc+4);
    lcd.setPixel(83,yc+5);
    lcd.setPixel(83,yc+6);
    lcd.setPixel(83,yc+7);
    lcd.setPixel(83,yc+8);
    lcd.setPixel(83,yc+9);

}

void net()
{
    lcd.setPixel (42,0);
    lcd.setPixel (42,2);
    lcd.setPixel (42,4);
    lcd.setPixel (42,6);
    lcd.setPixel (42,8);
    lcd.setPixel (42,10);
    lcd.setPixel (42,12);
    lcd.setPixel (42,14);
    lcd.setPixel (42,16);
    lcd.setPixel (42,18);
    lcd.setPixel (42,20);
    lcd.setPixel (42,22);
    lcd.setPixel (42,24);
    lcd.setPixel (42,26);
    lcd.setPixel (42,28);
    lcd.setPixel (42,30);
    lcd.setPixel (42,32);
    lcd.setPixel (42,34);
    lcd.setPixel (42,36);
    lcd.setPixel (42,38);
    lcd.setPixel (42,40);
    lcd.setPixel (42,42);
    lcd.setPixel (42,44);
    lcd.setPixel (42,46);
    lcd.setPixel (42,48);
}



int main()
{
    wait(2.0);  // short delay for power to settle
    init_display(); // first need to initialise display
    init_K64F();
    menu();
    wait(3);

    init_ball();
    // setup ticker
    game_timer.attach(&game_timer_isr,0.1);

    redraw_screen();  // draw initial screen

    while(1) {
        sprintf(score1, "%d", playerScore);
        lcd.printString(score1,30,0);
        sprintf(score2, "%d", computerScore);
        lcd.printString(score2,50,0);


        if ( g_timer_flag ) {  // ticker interrupt
            g_timer_flag = 0;  // clear flag
            UserPaddle();
            ComputerPaddle();
            moveUserPaddle();
            moveComputerPaddle();
            paddleLimits();
            ComputerpaddleLimits();
            net();
            Scoring();
            victory();
            loss();
            resetBall();
            update_physics_engine();
            check_collisions();
            redraw_screen();
            lcd.refresh();
            refreshCells();
        }

        sleep();  // sleep until next interrupt

    }
}



void game_timer_isr()
{
    g_timer_flag = 1;
}

