#include "mbed.h"
#include "N5110.h"
#define BALLRADIUS 2



//          VCC,    SCE,  RST,    D/C,   MOSI,  SCLK,   LED
N5110 lcd (PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);
AnalogIn yin(PTB3); /*!< sets y position of user paddle*/
DigitalIn select(PTB11);


Ticker game_timer;



/*!<  struct used to store 2D vectors*/
typedef struct vector_t vector_t; /*!<  struct used to store 2D vectors*/
struct vector_t {
    float x;
    float y;
};
/**

@file data.h
@brief A file containing variables and constants 
@brief These variables and constants are then called to be used within the game
@author Harry Petrovic
@date May 2016
*/

vector_t pos;  /*!< Position of the ball*/
vector_t vel;  /*!< Velocity of the ball*/
vector_t acc;  /*!< acceleration of the ball*/

float refresh_rate = 200.0;  /*!<  how often to update display (Hz)*/
float g_dt = 20.0F/refresh_rate;  /*!< global to store time step (F makes it a float, gets rid of compiler warning)*/
volatile int g_timer_flag = 0;

int yp = 0; /*!< y position of user controlled paddle*/
int yc = 0;/*!< y position of computer controlled paddle*/
char score1[80]; /*!< Score 1, used for human score*/
char score2[80]; /*!< Score 2, used for computer score*/
int playerScore = 0;/*!< Set innitially to 0 at start of game*/
int computerScore = 0;/*!< Set innitially to 0 at start of game*/
int Array [84][48]; /*!< Array of Nokia LCD Screen pixels [x][y]*/
int nx = 84; /*!< integer value of number of pixels on x axis, used for lcd.Clearpixels*/
int ny = 48; /*!< integer value of number of pixels on y axis, used for lcd.Clearpixels*/
unsigned char next[84][48]; /*!< used to set buffer for the screen*/
int difficulty =1; /*!< used in initial menu screen to select difficuly*/
