#include "mbed.h"
#include "N5110.h"

//  VCC,    SCE,   RST,   D/C,   MOSI,  SCLK,   LED
N5110 lcd(PTE26,PTA0,PTC4,PTD0,PTD2,PTD1,PTC3);
//BusOut leds(PTC5 , PTC7);
AnalogIn pot(PTB10);

// change this to alter tolerance of joystick direction
//#define DIRECTION_TOLERANCE 0.05L

// connections for joystick
DigitalIn button(PTB11);
AnalogIn xPot(PTB2);
AnalogIn yPot(PTB3);


int x = 42;
int y = 24;
//int gameStart = 0;

int nx= 84;
int ny= 48;

int NextGen[84][48]= {0};
void splashScreen();
void clearCells();
void Wall();
void snakeBody(char x,char y);
//void joystickMovement();

// timer to regularly read the joystick
//Ticker pollJoystick;

// create enumerated type (0,1,2,3 etc. for direction)
// could be extended for diagonals etc.
/*
enum DirectionName {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    CENTRE
};
*/
/*
// struct for Joystick
typedef struct JoyStick Joystick;
struct JoyStick {
    float x;    // current x value
    float x0;   // 'centred' x value
    float y;    // current y value
    float y0;   // 'centred' y value
    int button; // button state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    DirectionName direction;  // current direction
};
*/
// create struct variable
//Joystick joystick;

//int printFlag = 0;

// function prototypes
//void calibrateJoystick();
//void updateJoystick();

int main()
{
    srand(time(NULL));

    wait(2);
    lcd.init();
    splashScreen();
    clearCells();
    wait(0.5);
    Wall();
    snakeBody(x,y);
//    calibrateJoystick();  // get centred values of joystick
//    pollJoystick.attach(&updateJoystick,1.0);  // read joystick 10 times per second
//    gameStart = 1;
    while (1)
    {
        int x_joystick = xPot.read() * 1000; // float (0->1) to int (0-1000)
        int y_joystick = yPot.read() * 1000;
        
        wait(0.05);
        
        if ( ((x_joystick > 30) && (x_joystick < 100)) && ((y_joystick > 0) && (y_joystick < 5)) )
        {// UP
            lcd.clearPixel(x,y);
            lcd.refresh();
            if (y > 0)
                --y;
            lcd.setPixel(x,y);
            lcd.refresh();
        }
        else if ( ((x_joystick > 400) && (x_joystick < 600)) && ((y_joystick > 950) && (y_joystick < 1000)) )
        { // DOWN
            lcd.clearPixel(x,y);
            lcd.refresh();
            if (y < 48)
                ++y;
            lcd.setPixel(x,y);
            lcd.refresh();
        }
        else if ( ((x_joystick > 330) && (x_joystick < 399)) && ((y_joystick > 450) && (y_joystick < 550)) )
        {// RIGHT
            lcd.clearPixel(x,y);
            lcd.refresh();
            if (x < 84)
                ++x;
            lcd.setPixel(x,y);
            lcd.refresh();
        }
        else if ( ((x_joystick > 230) && (x_joystick < 280)) && ((y_joystick > 450) && (y_joystick < 550)) )
         {//LEFT
            lcd.clearPixel(x,y);
            lcd.refresh();
            if (x > 0)
                --x; 
            lcd.setPixel(x,y); 
            lcd.refresh();      
        }
        
//        joystickMovement();
//        lcd.setBrightness(pot*0.001f);
    }
}
/*
// read default positions of the joystick to calibrate later readings
void calibrateJoystick()
{
    button.mode(PullDown);
    // must not move during calibration

    joystick.x0 = xPot;  // initial positions in the range 0.0 to 1.0 (0.5 if centred exactly)
    joystick.y0 = yPot;
}
*/

/*
void updateJoystick()
{
    // read current joystick values relative to calibrated values (in range -0.5 to 0.5, 0.0 is centred)
    joystick.x = xPot - joystick.x0;
    joystick.y = yPot - joystick.y0;
    // read button state
    joystick.button = button;

    // calculate direction depending on x,y values
    // tolerance allows a little lee-way in case joystick not exactly in the stated direction
    if ( fabs(joystick.y) < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = CENTRE;
    } else if ( joystick.y > DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = UP;
    } else if ( joystick.y < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = DOWN;
    } else if ( joystick.x > DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = RIGHT;
    } else if ( joystick.x < DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = LEFT;
    }

    // set flag for printing
    printFlag = 1;
}
*/

/*
void joystickMovement()


{

    while(gameStart) {
        if (printFlag) {  // if flag set, clear flag and print joystick values to serial port
            printFlag = 0;

            // check joystick direction
            if (joystick.direction == UP)
                j--;
            if (joystick.direction == DOWN)
                j++;
            if (joystick.direction == LEFT)
                i--;
            if (joystick.direction == RIGHT)
                i++;
//           if (joystick.direction == CENTRE)
//               lcd.printString(" CENTRE ",5,2);


        }
        sleep();
    }
}
*/

void splashScreen() //This is the first screen the user sees when the game is turned on
{

    lcd.printString("Welcome To",15,1);
    wait(1);
    lcd.printString("D.Honeywell's",3,2);
    lcd.printString("------------------",1,3);
    wait(2);
    lcd.printString("E",15,4);
    wait(0.3);
    lcd.printString("EP",15,4);
    wait(0.3);
    lcd.printString("EPI",15,4);
    wait(0.3);
    lcd.printString("EPIC",15,4);
    lcd.printString("EPIC ",15,4);
    wait(0.3);
    lcd.printString("EPIC G",15,4);
    wait(0.3);
    lcd.printString("EPIC GA",15,4);
    wait(0.3);
    lcd.printString("EPIC GAM",15,4);
    wait(0.3);
    lcd.printString("EPIC GAME",15,4);
    wait(0.3);

}


void clearCells()
{
    for (int i = 0; i < nx ; i++) {
        for (int j = 0; j < ny ; j++) {
            lcd.clearPixel(i,j);

        }
    }
    lcd.refresh();

}



void snakeBody(char x, char y)

{
    lcd.setPixel(x,y);
    lcd.refresh();

}

/*
int Rand (int Min = 1, int Max = 83)
{
    static bool First = true;
    if (First) srand (time (NULL)), First = false;
    while (7) {
        int S = rand () % (Max - Min + 1) + Min;
        if (!((S - 1)  % 3)) return S;
    }
}

*/

void Wall ()

{

    lcd.drawRect(0,0,82,46,0);
    lcd.drawRect(1,1,80,44,0);

}


