#include "main.h"


int main()
{

    // first need to initialise display
    lcd.init();/// turn on the lcd screen.
    button.rise(&button_isr);/// return the value of button_isr to here.
    button.mode(PullDown);/// set the mode of the button to make the user can press the botton.
    /* while(1){
         lcd.clear();
     if(g_button_flag) {
        // g_button_flag = 0;
         lcd.printString("button is on",0,0);
     }else {
         lcd.printString("button is off",0,0);
     }
     lcd.refresh();
     wait(0.1);
     }*/
    buttonjoystick.mode(PullDown);/// set the mode of the button of joystick to make the user can press the botton.
    calibrateJoystick();  // get centred values of joystick
    pollJoystick.attach(&updateJoystick,1.0/10.0);  // read joystick 10 times per second



    // these are default settings so not strictly needed
    lcd.normalMode();      // normal colour mode
    lcd.setBrightness(1.0); // put LED backlight on 50%
    
    // welcome screen
    lcd.printString("Welcome To",15,1);
    lcd.printString("Starcraft III!",4,3);
    lcd.refresh();
    wait(5.0);
    lcd.clear();
    
    lcd.printString("How to Play",10,0);
    
    // draw Enemy.
    lcd.printString("Enemy",30,2);
    // draw the arrow.
    lcd.drawLine(15,19,22,19,1);
    lcd.drawLine(22,19,20,17,1);
    lcd.drawLine(22,19,20,21,1);
    
    lcd.drawLine(0,10,83,10,1);
    
    lcd.drawLine(2,18,3,17,1);
    lcd.drawLine(3,17,7,17,1);
    lcd.drawLine(7,17,8,18,1);
    lcd.drawLine(5,17,5,21,1);
    //You
    lcd.printString("You",30,4);
    lcd.drawLine(15,35,22,35,1);
    lcd.drawLine(22,35,20,33,1);
    lcd.drawLine(22,35,20,37,1);
    
    lcd.drawLine(6,32,6,39,1);
    lcd.drawLine(6-4,34,6+4,34,1);
    lcd.drawLine(6-1,35,6+1,35,1);
    lcd.drawLine(6-1,39,6+1,39,1);
    lcd.refresh();
    
    //to make the screen stick in this while loop when the user press the botton then goes to next page.
    while(1) {
        if (button) {
            //buzzer.period_ms(2.9);
            //buzzer.pulsewidth_ms(1.9);
            wait(0.5);
            lcd.clear();
            lcd.refresh();
            break;
        }
    }
    
    // the screen to tell user how to control the Movement
    lcd.printString("How to Play",10,0);
    lcd.drawLine(0,10,83,10,1);
    lcd.drawLine(41,15,41,22,1);
    lcd.drawLine(41-4,17,41+4,17,1);
    lcd.drawLine(41-1,18,41+1,18,1);
    lcd.drawLine(41-1,22,41+1,22,1);
    
    lcd.drawLine(48,19,55,19,1);
    lcd.drawLine(55,19,53,17,1);
    lcd.drawLine(55,19,53,21,1);
    
    lcd.drawLine(27,19,34,19,1);
    lcd.drawLine(27,19,29,17,1);
    lcd.drawLine(27,19,29,21,1);

    lcd.drawCircle(41,33,3,1);

    lcd.drawLine(48,33,55,33,1);
    lcd.drawLine(55,33,53,31,1);
    lcd.drawLine(55,33,53,35,1);
    
    lcd.drawLine(27,33,34,33,1);
    lcd.drawLine(27,33,29,31,1);
    lcd.drawLine(27,33,29,35,1);
    lcd.printString("JoyStick",19,5);
    lcd.refresh();
    
    //to make the screen stick in this while loop when the user press the botton then goes to next page.
    while(1) {
        if (button) {
            //buzzer.period_ms(2.9);
            //buzzer.pulsewidth_ms(1.9);
            wait(0.5);
            lcd.clear();
            lcd.refresh();
            break;
        }
    }
    
    // describe how to use the button and the joystick button
    lcd.printString("How to Play",10,0);
    lcd.drawLine(0,10,83,10,1);
    
    lcd.printString("Button:",20,2);
    lcd.printString("Viking Missile",0,3);
    lcd.printString("JoyStick:",18,4);
    lcd.printString("Bomb X3",19,5);
    //to make the screen stick in this while loop when the user press the botton then goes to next page.
    while(1) {
        if (button) {
            //buzzer.period_ms(2.9);
            //buzzer.pulsewidth_ms(1.9);
            wait(0.5);
            lcd.clear();
            lcd.refresh();
            break;
        }
    }
    
    //prepare for battle screen
    lcd.printString("Prepare for",10,0);
    lcd.printString("Battle",23,1);
    lcd.drawLine(0,20,83,20,1);
    lcd.printString("Start!",25,4);
    lcd.refresh();
    //to make the screen stick in this while loop when the user press the joystick botton then goes to next page.
    while(1) {
        if (buttonjoystick) {
            //buzzer.period_ms(2.9);
            //buzzer.pulsewidth_ms(1.9);
            wait(0.5);
            lcd.clear();
            lcd.refresh();
            break;
        }

    }
//loading screen
    lcd.printString("Loading......",6,1);

    for (int x = 0; x < WIDTH ; x+=10) {

        lcd.drawRect(0,36,10+x,10,1);
        wait(0.1);
        lcd.refresh();
    }
    lcd.clear();


    int x = 41 ;/// set 'x' to 41 originally.
    // draw the player's unit.
    lcd.drawLine(x,40,x,47,1);
    lcd.drawLine(x-4,42,x+4,42,1);
    lcd.drawLine(x-1,43,x+1,43,1);
    lcd.drawLine(x-1,47,x+1,47,1);
    lcd.refresh();
    //the constant will be used in the code below
    int z=41; ///the x axis value of the bullet, start from the middle of the screen 
    int q = 0; ///the y axis value of the enemy unit, start from 0.
    int p = 0;
    int a;
    int b;
    a = rand() % 76; /// 'a' is a random number from 0-76.
    //b = rand() % 76;
    int yHit = 39;/// y axis value of the bullet. 
    int buttonjoystickpress = 0;/// player can only use the bomb for 3 time, set the value to 0 originally.
    int bu = 0;/// the constant which keep the bullet move in a straight line.
    int score = 0;/// set the score value start from 0.
    int rect = 0;/// y axis value of the left hand side wall.
    int rect1 = 0;/// y axis value of the right hand side wall.
    int width;/// the width of the left hand side wall.
    width = rand() %30;/// set the width of the left hand side wall as a random value between 0-30.
    int width2;/// the width of the right hand side wall.
    width2 = 83 - rand() %30;// set the width of the right hand side wall as a random value between 53-83.
    //bullet.attach(&createbullet,0.1);
    //enermy.attach(&createenermy,2.0);


    while(1) {


        if (printFlag) {  // if flag set, clear flag and print joystick values to serial port
            printFlag = 0;
            // check joystick direction
            //a-b > 7;
            //b-a > 7;
            //a + b < 83;
            
            // make the movement of the left hand side wall
            if(!wall) {
                lcd.drawRect(0,rect,width,5,2);
                
                rect++;/// set the wall moves 1 pixels per time.
                
                lcd.drawRect(0,rect,width,5,1);
                lcd.refresh();
                }
            // return the 'rect' value back to 0 and set the random number again after the wall go out of the screen.
            if(rect > 50) {
                rect = 0;
                width = rand() %30;
            }
            // make the movement of the right hand side wall
            if(!wall) {
                lcd.drawRect(width2,rect1,83-width2,5,2);
                
                rect1++;/// set the wall moves 1 pixels per time.
                
                lcd.drawRect(width2,rect1,83-width2,5,1);
                lcd.refresh();
                }
            // return the 'rect1' value back to 0 and set the random number again after the wall go out of the screen.
            if(rect1 > 50) {
                rect1 = 0;
                width2 = 83 - rand()%30;
            }
            
            if(!hit) {
                // make the movement of the enemy.
                lcd.drawLine(a,q+1,a+1,q,0);
                lcd.drawLine(a+1,q,a+5,q,0);
                lcd.drawLine(a+5,q,a+6,q+1,0);
                lcd.drawLine(a+3,q,a+3,q+4,0);
                q+=2;/// set the enemy moves 2 pixels per time.

                lcd.drawLine(a,q+1,a+1,q,1);
                lcd.drawLine(a+1,q,a+5,q,1);
                lcd.drawLine(a+5,q,a+6,q+1,1);
                lcd.drawLine(a+3,q,a+3,q+4,1);

                lcd.refresh();
            }
            hit = false;
            /*
            if(!hit){
            lcd.drawLine(a+b,p+1,a+1+b,p,0);
            lcd.drawLine(a+1+b,p,a+5+b,p,0);
            lcd.drawLine(a+5+b,p,a+6+b,p+1,0);
            lcd.drawLine(a+3+b,p,a+3+b,p+4,0);

            p++;
            lcd.drawLine(a+b,p+1,a+1+b,p,1);
            lcd.drawLine(a+1+b,p,a+5+b,p,1);
            lcd.drawLine(a+5+b,p,a+6+b,p+1,1);
            lcd.drawLine(a+3+b,p,a+3+b,p+4,1);
            lcd.refresh();
                }
            hit = false;
            */
            
            // creat a new enemy when it has been hit or go out of the screen.
            if(q > 50) {
                q = 0;
                p = 0;
                a = rand () % 76;
                b = rand () % 76;
            }

            // movement of the player's unit controlled by the joystick.
            if (joystick.direction == UP && x > 4) {

                score += 1;/// get 1 score after moving the joystick once and move for 1 pixel
                lcd.drawLine(x,40,x,47,0);
                lcd.drawLine(x-4,42,x+4,42,0);
                lcd.drawLine(x-1,43,x+1,43,0);
                lcd.drawLine(x-1,47,x+1,47,0);
                x-=1;/// set the player's unit move 1 pixels per time.

                lcd.drawLine(x,40,x,47,1);
                lcd.drawLine(x-4,42,x+4,42,1);
                lcd.drawLine(x-1,43,x+1,43,1);
                lcd.drawLine(x-1,47,x+1,47,1);
                lcd.refresh();

            }
            
            if (joystick.direction == DOWN && x < 78) {
                score += 1;/// get 1 score after moving the joystick once and move for 1 pixel
                lcd.drawLine(x,40,x,47,0);
                lcd.drawLine(x-4,42,x+4,42,0);
                lcd.drawLine(x-1,43,x+1,43,0);
                lcd.drawLine(x-1,47,x+1,47,0);
                x+=1;/// set the player's unit move 1 pixels per time.

                lcd.drawLine(x,40,x,47,1);
                lcd.drawLine(x-4,42,x+4,42,1);
                lcd.drawLine(x-1,43,x+1,43,1);
                lcd.drawLine(x-1,47,x+1,47,1);
                lcd.refresh();
            }
            /*
            if(z < width && yHit > rect && yHit < rect+5){
                bullethit = true;
            }
            */
            
            //bullet movement and the calculation which make the bullet start from wherever the player's unit is and make it move in a stright line.
            if(g_button_flag && !bullethit) {
                
                
                //g_button_flag = 0;
                if(joystick.direction == UP && x > 4) {
                    bu--;
                }
                if(joystick.direction == DOWN && x < 78) {
                    bu++;
                }
                z = x -bu;
                lcd.drawLine(z,yHit,z,yHit-1,0);
                
                yHit-=2;/// set the bullet move 2 pixels per time.

                lcd.drawLine(z,yHit,z,yHit-1,1);
                
                // detect if the bullet hits the enemy.
                if(z>=a && z <=a+7 && yHit<=q) {
                    hit = true;
                    // clear the enemy.
                    lcd.drawLine(a,q+1,a+1,q,0);
                    lcd.drawLine(a+1,q,a+5,q,0);
                    lcd.drawLine(a+5,q,a+6,q+1,0);
                    lcd.drawLine(a+3,q,a+3,q+4,0);
                    // recreate the enemy
                    q=0;
                    a = rand() % 76;
                    score += 100; /// get 100 score after player hit an enermy
                }

                /*
                if(z == a+1 && q == yHit) {
                    hit = true;
                    lcd.drawLine(a,q+1,a+1,q,0);
                    lcd.drawLine(a+1,q,a+5,q,0);
                    lcd.drawLine(a+5,q,a+6,q+1,0);
                    lcd.drawLine(a+3,q,a+3,q+4,0);
                    q=0;
                    a = rand() % 76;
                }
                if(z == a+2 && q == yHit) {
                    hit = true;
                    lcd.drawLine(a,q+1,a+1,q,0);
                    lcd.drawLine(a+1,q,a+5,q,0);
                    lcd.drawLine(a+5,q,a+6,q+1,0);
                    lcd.drawLine(a+3,q,a+3,q+4,0);
                    q=0;
                    a = rand() % 76;
                }
                if(z == a+3 && q+4 == yHit) {
                    hit = true;
                    lcd.drawLine(a,q+1,a+1,q,0);
                    lcd.drawLine(a+1,q,a+5,q,0);
                    lcd.drawLine(a+5,q,a+6,q+1,0);
                    lcd.drawLine(a+3,q,a+3,q+4,0);
                    q=0;
                    a = rand() % 76;
                }
                if(z == a+5 && q == yHit) {
                    hit = true;
                    lcd.drawLine(a,q+1,a+1,q,0);
                    lcd.drawLine(a+1,q,a+5,q,0);
                    lcd.drawLine(a+5,q,a+6,q+1,0);
                    lcd.drawLine(a+3,q,a+3,q+4,0);
                    q=0;
                    a = rand() % 76;
                }
                if(z == a+6 && q+1 == yHit) {
                    hit = true;
                    lcd.drawLine(a,q+1,a+1,q,0);
                    lcd.drawLine(a+1,q,a+5,q,0);
                    lcd.drawLine(a+5,q,a+6,q+1,0);
                    lcd.drawLine(a+3,q,a+3,q+4,0);
                    q=0;
                    a = rand() % 76;
                }
*/

                //lcd.drawLine(z,yHit,z,yHit-1,0);
                //yHit--;
                //lcd.drawLine(z,yHit,z,yHit-1,1);
                lcd.refresh();
                wait(0.1);
            }
            if (yHit < -3) {
                g_button_flag = 0;/// set g_button_flag to 0 
                yHit = 39;/// set 'yHit' back to 39
                bu=0;/// set 'bu' back to 0.
                z = x -bu;/// reset the x axis value of the bullet
            }
        }
        //detect if the enemy hit the left hand side wall, the player won't get any score.
        if(width>=a && rect <= q+4 && rect >= q) {
            
            hit = true;
            lcd.drawLine(a,q+1,a+1,q,0);
            lcd.drawLine(a+1,q,a+5,q,0);
            lcd.drawLine(a+5,q,a+6,q+1,0);
            lcd.drawLine(a+3,q,a+3,q+4,0);
            q=0;
            a = rand() % 76;
        }
        //detect if the enemy hit the right hand side wall, the player won't get any score.
        if(a+6 >= width2 && rect <= q+4 && rect >= q){
            hit = true;
            lcd.drawLine(a,q+1,a+1,q,0);
            lcd.drawLine(a+1,q,a+5,q,0);
            lcd.drawLine(a+5,q,a+6,q+1,0);
            lcd.drawLine(a+3,q,a+3,q+4,0);
            q=0;
            a = rand() % 76;
            }
        //set the player can only use 3 bombs per game using joystick button.
        if(buttonjoystick && buttonjoystickpress < 3) {
            ++buttonjoystickpress;
            hit = true;
            lcd.drawLine(a,q+1,a+1,q,0);
            lcd.drawLine(a+1,q,a+5,q,0);
            lcd.drawLine(a+5,q,a+6,q+1,0);
            lcd.drawLine(a+3,q,a+3,q+4,0);
            q=0;
            a = rand() % 76;
            score += 300;// player get 300 score after using the bomb.
            
            // destroy all enemy and keep the wall and the play's unit on the screen.
            for (int r = 5; r < 100; r+=8) {
                lcd.drawCircle(x,45,r,0);
                if(r < 100) {
                    lcd.drawCircle(x,45,r-8,2);/// the action of the bomb.
                    //draw the player's unit again
                    lcd.drawLine(x,40,x,47,1);
                    lcd.drawLine(x-4,42,x+4,42,1);
                    lcd.drawLine(x-1,43,x+1,43,1);
                    lcd.drawLine(x-1,47,x+1,47,1);
                    //draw the wall again
                    lcd.drawRect(0,rect,width,5,1);
                    lcd.drawRect(width2,rect1,83-width2,5,1);
                }
                lcd.refresh();
                wait(0.1);

            }
        }
        
        //detect Game Over if the wall or the enemy hit the player.

        if(a == x-4 && q+1 == 42) {
            lcd.clear();/// clear the screen first.
            // print out the game over information.
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            // after 2 sec show score on the screen.
            lcd.clear();
            char buffer[14];/// put the score which have calculated into the array.
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);/// print out the score.
            lcd.refresh();
            break;
        }
        // the code below also dectect if the player hit the wall or enemy than jump into 'game over' condition.
        if(a+1 == x-4 && q ==42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a+2 == x-4 && q == 42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a+3 == x-4 && q+4 ==42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a+4 == x-4 && q ==42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a+5 == x-4 && q ==42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a+6 == x-4 && q+1 ==42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a+3 == x-4 && q == 42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a+3 == x-3 && q ==42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a+3 == x-2 && q == 42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a+3 == x-1 && q ==42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a+3 == x && q == 40) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a+3 == x+1 && q ==42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a+3 == x+2 && q == 42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a+3 == x+3 && q ==42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
             char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a+3 == x+4 && q ==42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
             char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a == x+4 && q+1 == 42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a+1 == x+4 && q ==42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a+2 == x+4 && q == 42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a+3 == x+4 && q+4 ==42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a+4 == x+4 && q ==42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a+5 == x+4 && q ==42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        if(a+6 == x+4 && q+1 ==42) {
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
        }
        
        //dectect if the player hit the left hand side wall.
        if(width+9 > x+4 && rect+5 >= 40){
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
            }
        //dectect if the player hit the right hand side wall.
        if(x+4 >= width2 && rect1+5 >= 40){
            lcd.clear();
            lcd.printString ("Game Over",18,1);
            lcd.printString ("Viking",24,2);
            lcd.printString ("Destroyed",18,3);
            lcd.refresh();
            wait(2.0);
            lcd.clear();
            char buffer[14];
            int length = sprintf(buffer,"Score: %d",score);
            if (length <= 14)
            lcd.printString(buffer,0,1);
            lcd.refresh();
            break;
            }
        //detect victory. Whenever player's score is over 5000.
        if (score >= 5000)
        {
            lcd.clear();
            lcd.printString("Congratulation!",0,1);
            lcd.printString("Mission",20,2);
            lcd.printString("Complete!",18,3);
            lcd.refresh();
            break;
            }

    }
}

void calibrateJoystick()
{
    button.mode(PullDown);
    // must not move during calibration
    joystick.x0 = xPot;  // initial positions in the range 0.0 to 1.0 (0.5 if centred exactly)
    joystick.y0 = yPot;
}
void updateJoystick()
{
    // read current joystick values relative to calibrated values (in range -0.5 to 0.5, 0.0 is centred)
    joystick.x = xPot - joystick.x0;
    joystick.y = yPot - joystick.y0;
    // read button state
    joystick.buttonjoystick = button;

    // calculate direction depending on x,y values
    // tolerance allows a little lee-way in case joystick not exactly in the stated direction
    if ( fabs(joystick.y) < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = CENTRE;
    } else if ( joystick.y > DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = UP;
    } else if ( joystick.y < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = DOWN;
    } else if ( joystick.x > DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = RIGHT;
    } else if ( joystick.x < DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = LEFT;
    } else {
        joystick.direction = UNKNOWN;
    }

    // set flag for printing
    printFlag = 1;
}
// code below is just used to testing.
void createbullet()
{
    int z = 41;
    if (joystick.direction == UP && z > 4) {
        --z;
    }
    if (joystick.direction == UP && z > 78) {
        ++z;
    }
    if(button) {

        for (int y = 39; y > -5 ; y-=7) {

            lcd.drawLine(z,y,z,y-2,1);
            if(y<39) {
                lcd.drawLine(z,y+7,z,y-2+7,0);
            }
            lcd.refresh();


        }
    }
    bulletFlag = 1;

}
// code below is just used to testing.
void createenermy()
{
    int a;
    int b;
    a = rand() % 76;
    b = rand() % 76;
    for (int q=0 ; q < 52; q+=2) {
        lcd.drawLine(a,q+1,a+1,q,1);
        lcd.drawLine(a+1,q,a+5,q,1);
        lcd.drawLine(a+5,q,a+6,q+1,1);
        lcd.drawLine(a+3,q,a+3,q+4,1);


        lcd.drawLine(a+b,q+1,a+1+b,q,1);
        lcd.drawLine(a+1+b,q,a+5+b,q,1);
        lcd.drawLine(a+5+b,q,a+6+b,q+1,1);
        lcd.drawLine(a+3+b,q,a+3+b,q+4,1);
        if (q < 52) {
            lcd.drawLine(a,q+1-2,a+1,q-2,0);
            lcd.drawLine(a+1,q-2,a+5,q-2,0);
            lcd.drawLine(a+5,q-2,a+6,q+1-2,0);
            lcd.drawLine(a+3,q-2,a+3,q+4-2,0);

            lcd.drawLine(a+b,q+1-2,a+1+b,q-2,0);
            lcd.drawLine(a+1+b,q-2,a+5+b,q-2,0);
            lcd.drawLine(a+5+b,q-2,a+6+b,q+1-2,0);
            lcd.drawLine(a+3+b,q-2,a+3+b,q+4-2,0);
        }
    }
    enermyFlag = 1;

}
// set g_button_flag equals to 1 and return to button_isr().
void button_isr()
{
    g_button_flag =1;
}