/**
@file main.h
@brief Header file containing functions prototypes, defines and global variables.
@brief Acknowledgements to Craig A. Evans's N5110 Library.
@brief Revision 1.0.
@author YangQing
@date   March 2016
*/
#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"
#include "N5110.h"
#include <stdio.h> 
#include <stdlib.h>

/**  
@namespace N5110_lcd
@brief N5110 connection.
*/
N5110 lcd(PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);
// Can also power (VCC) directly from VOUT (3.3 V) -
// Can give better performance due to current limitation from GPIO pin


#define DIRECTION_TOLERANCE 0.30

/**  
@namespace button1 
@brief button1 connection
*/
DigitalIn button1(PTB11);

/**  
@namespace xPot 
@brief x-axis of joystick connection
*/
AnalogIn xPot(PTB2);

/**  
@namespace yPot 
@brief y-axis of joystick connection
*/
AnalogIn yPot(PTB3);

/**  
@namespace ticker 
@brief ticker is to control light
*/
Ticker ticker;

/**  
@namespace yellow_led 
@brief make yellow_led lip
*/
PwmOut yellow_led(PTC2);

/**  
@namespace buzzer
@brief make buzzer work
*/
PwmOut buzzer(PTA2);

/**  
@namespace button 
@brief press this button will stop game, press again to continues
*/
InterruptIn button(PTB18);

/**  
@namespace pollJoystick 
@brief timer to regularly read the joystick
*/
Ticker pollJoystick;

/**  
@namespace serial 
@brief Serial for debug
*/
Serial serial(USBTX,USBRX);

/**
@namespace DirectionName
@brief define joystick's direction based on its x,y values
*/ 
enum DirectionName {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    CENTRE,
    UNKNOWN
};

/**  
@namespace JoyStick 
@brief struct for Joystick
*/
typedef struct JoyStick Joystick;
struct JoyStick {
    float x;    // current x value
    float x0;   // 'centrexd' x value
    float y;    // current y value
    float y0;   // 'centred' y value
    int button; // button state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    DirectionName direction;  // current direction
};

/**  
@namespace JoyStick 
@brief create struct variable
*/
Joystick joystick;

int printFlag = 0;/*!< set printflag variable  */
int c =45;        /*!< c is the y-axis of ball in the game  */
int d =20;        /*!< d is the x-axis of ball in the game  */
int s =0;         /*!< s is the count value to show score when game finish */
int linex1 = 0;   /*!< linex1 is the first line x-axis */
int liney1 = 30;  /*!< liney1 is the first line y-axis */
int linex2 = 12;  /*!< linex2 is the second line x-axis */
int liney2 = 31;  /*!< liney2 is the second line y-axis */
int linex3 = 24;  /*!< linex3 is the third line x-axis */
int liney3 = 32;  /*!< liney3 is the third line y-axis */
int linex4 = 36;  /*!< linex4 is the fourth line x-axis */
int liney4 = 33;  /*!< liney4 is the fourth line y-axis */
int linex5 = 48;  /*!< linex5 is the fifth line x-axis */
int liney5 = 34;  /*!< liney5 is the fifth line y-axis */
int flag=0;       /*!< flag is judgement variable */
volatile bool stop = false; /*!< judge stop is flase or not */

/**  
@namespace ting 
@brief this function will stop the game
*/
void ting();

// function prototypes
/**
update current position to default position of Joystick
*/
void calibrateJoystick();

/**
Update the values of the joystick to get current position
*/
void updateJoystick();

/**
set points which will judge the game over
*/
void touch();

/**  
This function let yellow_led lip when game starts.
*/
void yellow();

#endif 