/**
@file main.h
@brief Header file for functions, defines and global variables.

@author Andrew Ruffley 200887845
@brief University of Leeds ELEC2645 Project
@date May 2015
*/

#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"
#include "SRF02.h"
#include "N5110.h"
#include "SDFileSystem.h"


// --------------- INPUT PERIPHERALS --------------


/**
@namespace sensor
@brief Ultra-Sonic distance sensor requires SDA and SCL lines
*/
SRF02 sensor(PTE25, PTE24);

/**
@namespace Sw1
@brief Digital input button that is used to select program
*/
DigitalIn Sw1(PTB19);

/**
@namespace Sw2
@brief Digital input button that is used to select program
*/
DigitalIn Sw2(PTB18);


// -------------- OUTPUT PERIPHERALS --------------

/**
@namespace lcd
@brief Outputs for the N5110 lcd display, lcd (VCC,SCE,RST,D/C,MOSI,SCLK,LED)
*/
N5110 lcd(PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);

/**
@namespace sd
@brief Outputs for the sd card, sd(PTE3, PTE1, PTE2, PTE4, "sd")
*/
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS, SD Card Connections

/**
@namespace Buzzer
@brief A buzzer that can produce different notes dependant on the frquency of the signal inputted to it. Used as an auditory alert
*/
PwmOut buzzer(PTA2);

/**
@namespace led_Yellow
@brief Yellow indicator LED
*/
DigitalOut LEDY(PTC5);

/**
@namespace led_Green
@brief Green indicator LED
*/
DigitalOut LEDG(PTC7);

/**
@namespace r_led
@brief K64F on-board LED
*/
DigitalOut r_led(LED_RED);

/**
@namespace g_led
@brief K64F on-board LED
*/
DigitalOut g_led(LED_GREEN);

/**
@namespace b_led
@brief K64F on-board LED
*/
DigitalOut b_led(LED_BLUE);


// -------------- VARIABLES --------------

int Array[5]; /*!<Creates an array */
int Total = 0; /*!<Creates and set a variable */
int count = 0; /*!<Creates and set a variable */
int Distance; /*!<Creates a variable */
int T; /*!<Creates variable */
int Time = T; /*!<Creates Variable and sets to T */


//  -------------- Functions --------------

/**
@namespace Parking_Sensor
@brief Parking Sensor Program
@brief Calculates average distance and creates graphic reprisentation
@brief Turns on buzzer if distance drops below 30cm
*/
void Parking_Sensor();

/**
@namespace D_Sensor
@brief Timer and Sensor Function
@brief Creates timer and reads distance
@brief If distance drops below 50cm saves time to sd
*/
void D_Sensor();

/**
@namespace delete_file
@brief Delete Save file
*/
void delete_file(char filename[]); 

/**
@namespace init_K64F
@brief set-up the on-board LEDs and switches
*/
void init_K64F();

/**
@namespace Buzzer
@brief Buzzer control
*/
void Buzzer(); //Buzzer

#endif