#include "mbed.h"
#include "SRF02.h"
#include "N5110.h"
#include "SDFileSystem.h"
/** ELEC2645 Project
*Finalised Project for submission
*/

//         VCC,    SCE,   RST,   D/C,   MOSI,  SCLK,   LED
N5110 lcd (PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);  // mbed pins
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS, SD Card Connections
SRF02 Sensor(PTE25,PTE24);//Distance Sensor

// External LED's
DigitalOut LEDY(PTC5);
DigitalOut LEDG(PTC7);

// K64F on-board LEDs
DigitalOut r_led(LED_RED);
DigitalOut g_led(LED_GREEN);
DigitalOut b_led(LED_BLUE);

// K64F on-board switches
InterruptIn sw2(SW2);
InterruptIn sw3(SW3);

// External Switches
DigitalIn Sw1(PTB19);
DigitalIn Sw2(PTB18);

//Buzzer
PwmOut buzzer(PTA2);

void D_Sensor();//Timer and Sensor Function
void delete_file(char filename[]); //Delete Save file
void init_K64F();// set-up the on-board LEDs and switches
void Buzzer(); //Buzzer
void Parking_Sensor();//Parking Sensor Program
char buffer[14];

Timer timer; //Initiate timer
int T;//Create time variable

int main()

{
    Sw1.mode(PullDown);
    Sw2.mode(PullDown);

    init_K64F();//initialise ob-board LED's and switches
    lcd.init();//initialise screen
    lcd.refresh(); //refresh

    lcd.printString("ELEC 2645",15,1);
    lcd.printString("Sensor",24,2);
    lcd.printString("Andy Ruffley",7,4);
    lcd.printString("200887845",16,5);
    wait(3);
    lcd.clear();

    lcd.printString("Program Select",0,0);
    lcd.printString("Parking Sensor",0,2);
    lcd.printString("Motion Sensor",3,3);
    lcd.printString("200887845",16,5);


    while(1) {

        int program = Sw1+Sw2+Sw2;
        switch (program) {

            case 1:
                lcd.clear();
                lcd.printString("Parking Sensor",0,2);
                lcd.refresh();
                wait(2);
                lcd.clear();
                while(1) {
                    Parking_Sensor();
                }


            case 2:
                lcd.clear();
                lcd.printString("Motion Sensor",3,3);
                lcd.refresh();
                wait(2);
                lcd.clear();
                while(1) {
                    D_Sensor();
                }
        }
    }
}
//End of programme



//Start of functions

//Program 1
void Parking_Sensor()
{
    int Array[5]; //Create an array
    int Total = 0; //Create and set a variable
    int count = 0; //Create and set a variable
    int Distance; //Create a variable

    for(count = 0; count < 5; count++) { //Set limits
        Array[count] = Sensor.getDistanceCm(); //Take sensor readings
        Total = Total + Array[count]; //Add sensor readings to variable
    }
    Distance = Total/5; // Calculate average
    lcd.drawRect(0,0,5,47,2);//Draw white fill rectangle
    lcd.drawRect(0,0,5,(Distance/4.3),1); //Draw black fill rectangle
    float distance = sprintf(buffer,"%d cm",Distance);
    if (distance <=14) {
        lcd.printString(buffer,10,1); //print reading
        // short delay before next measurement
        wait(0.5);
    }
    if (Distance <30) {
        Buzzer();//Activate Buzzer function
        LEDY=1;
        LEDG=0;
    } else  {
        buzzer = 0;//Turn off buzzer
        LEDY=0;
        LEDG=1;
    }
}

//program 2
void D_Sensor()
{
    int Distance;
    Distance = Sensor.getDistanceCm();//reads distance

    float distance = sprintf(buffer,"%d cm",Distance);
    if (distance <=14) {
        lcd.printString(buffer,10,1);//prints distance
        // short delay before next measurement
        wait(0.5);
    }
    timer.start();
    T = timer.read();
    float Time_E = sprintf(buffer,"%d S",T);
    if (Time_E <=14) {
        lcd.printString(buffer,7,2); //prints time
    }
    if (Distance<50) {
        FILE *fp; // this is our file pointer
        delete_file("/sd/Time_Log.txt");
        int Time = T;//Creates Variable and sets to T
        fp = fopen("/sd/Time_Log.txt", "a");
        lcd.printString("Saved",15,3);
        fprintf(fp, "%d",Time); // ensure data type matches
        fclose(fp);  // ensure you close the file after writing
    }
}



//Extra Functions

void Buzzer()
{
    buzzer.period_ms(1); //1KHz frequency
    buzzer = 0.05; //50% Duty cycle
    wait(1);
    buzzer.period_ms(2); //500Hz frequency
}

void delete_file(char filename[])
{

    FILE *fp = fopen(filename, "r");  // try and open file
    if (fp != NULL) {  // if it does open...
        fclose(fp);    // close it
        remove(filename);  // and then delete

    }
    // if we can't open it, it doesn't exist and so we can't delete it
}

void init_K64F()
{
    // on-board LEDs are active-low, so set pin high to turn them off.
    r_led = 1;
    g_led = 1;
    b_led = 1;

    // since the on-board switches have external pull-ups, we should disable the internal pull-down
    // resistors that are enabled by default using InterruptIn
    sw2.mode(PullNone);
    sw3.mode(PullNone);

}
