/**
@file main.h
@brief Header file containing functions prototypes, defines and global variables.
@author John A. C. Richards
@date   April 20156
*/
 
#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"
#include "N5110.h" 
#include "string" 
#include "SDFileSystem.h"

#define DIRECTION_TOLERANCE 0.05f 
#define maxPlayerSize 1000 

/**  
@namespace red_led
@brief GPIO output for game-over LED
*/
DigitalOut red_led(LED_RED);

/**  
@namespace green_led
@brief GPIO output for game-playing LED
*/
DigitalOut green_led(LED_GREEN);

/**  
@namespace N5110_lcd 
@brief GPIO output for Nokia screen
*/
N5110 lcd (PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);

/**  
@namespace yellowLED
@brief GPIO output for collision warning
*/
DigitalOut yellowLED(PTA2);

/**  
@namespace greenLED
@brief GPIO output for eating food
*/
DigitalOut greenLED(PTC2);

/**  
@namespace xPot
@brief GPIO output for joystick in x plane
*/
AnalogIn xPot(PTB2);

/**  
@namespace yPot
@brief GPIO output for joystick in y plane
*/
AnalogIn yPot(PTB3);

/**  
@namespace buzzer
@brief GPIO output for buzzer
*/
PwmOut buzzer(PTA1);

/**  
@namespace volume
@brief GPIO output for potentiometer
*/
AnalogIn volume(PTB10);


/**  
@namespace sd
@brief GPIO output for SDcard
*/
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS



volatile int playerLength; /*!<length of player*/

volatile int playerPositionsX[maxPlayerSize]; /*!<max player size x*/
volatile int playerPositionsY[maxPlayerSize]; /*!<max player size y*/

volatile int areaWidth = 41; /*!<width of game map*/
volatile int areaHeight = 19; /*!<height of game map*/

/**
@brief Sets flag for bringing the next frame
*/
void nextFrame(); //go to next frame function

/**
@brief Sets the bool timerDone as true 
*/
void timerTrigger(); //function to set bool as true to be used again


/**
@brief Timeout which keeps the program at one point for a while
@param seconds Time delayed, in seconds
*/
void screenDelay(float seconds); // timeout function

/**
@brief Turns off external green LED
*/
void greenOff (); 


/**
@brief Checks is snake has hit wall or self
@param x - set x plane
@param y - set y plane
@returns true or false
*/
bool checkCollision(int x,int y); 

/**
@brief read default positions of the joystick to calibrate later readings
*/
void calibrateJoystick();

/**
@brief read current joystick values relative to calibrated values and calculate direction depending on x,y values
*/
void updateJoystick();

/**
@brief Contains all of the snake code 
*/
void snake();
























#endif