/**
@file main.h
@brief Header file containing functions prototypes, defines and global variables.

@author Dogukan Kamacioglu
@brief University of Leeds 2645 Sensor Project
@date   April 2016
*/

#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"
#include "SRF02.h" ///@see a library i found to initiate the srf02 
#include "N5110.h" ///@see a library that i found to initiate the LCD
#include "beep.h" ///@see a library that i found to initiate the buzzer 

// INPUTS

/**
@namespace Sensor
@brief Ultra-Sonic distance sensor requires SDA and SCL lines
*/
SRF02 Sensor(PTE25,PTE24);

/**
@namespace r_led
@brief GPIO for on board LED,s
*/
DigitalOut r_led (LED_RED);

/**
@namespace gr_led
@brief GPIO for on board LED,s
*/
DigitalOut g_led (LED_GREEN);

/**
@namespace b_led
@brief GPIO for on board LED,s
*/
DigitalOut b_led (LED_BLUE);

/**
@namespace but
@brief An Interrupt button that puts beeper into silent
*/
InterruptIn but(PTB18);

/**
@namespace sw2
@brief An Interrupt button that is not used
*/
InterruptIn sw2(SW2);

/**
@namespace sw3
@brief An Interrupt button that is not used
*/
InterruptIn sw3(SW3);


// OUTPUTS

/**
@namespace lcd
@brief outputs for the N5110 lcd display
@brief lcd (VCC,SCE,RST,D/C,MOSI,SCLK,LED)
*/
N5110 lcd(PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);

/**
@namespace Beep Buzzer
@brief A buzzer that can produce different frequencied notes which can be variable
@brief from the signal inputted to it. Used as an auditory alert
*/
Beep buzzer (PTA2);

/**
@namespace red
@brief built in LED's 
*/
BusOut red(LED_RED);

/**
@namespace green
@brief built in LED's
*/
BusOut green(LED_GREEN);

/**
@namespace green
@brief built in LED's
*/
BusOut blue(LED_BLUE);


// VARIABLES

/**
Flag used to control button
*/
int butFlag;

/**
Stores length variable
*/
int length;

/**
Stores length variable
*/
int lengthinch;

/**
Stores distances obtained from array in cm's
*/
int dist;

/**
Stores distances obtained from array in cm's but converted to inches
*/
int dist1;


// Functions

/**
Function for welcome message
*/
void welcomeMessage();

/**
Function for measuring distance in cm's
*/
void measureDistance();

/**
Function for printing distance on the lcd screen
*/
void printDistance();

/**
Function for buzzer
*/
void dynamicBeeper();

/**
Function for button
*/
void butPressed();

/**
Function for drawing walls at the top and bottom of the screen
*/
void walls();

/**
Function for initialising the K64F
*/
void init_K64F();


// MISC

/**
Buffer to store the 14 digit char that is used for printing distance
*/
char buffer[14];


/**
@brief Array stores 5 distances
@returns The distance between the Sensor and the object infront.
*/
int Array[5];

int ArrayIn[5];

/**
@brief Total of those 5 distances are used for calculating average distance both in centimeters and inches
@returns The distance between the Sensor and the object infront.
*/
int Total = 0;

int TotalIn = 0;

int count = 0;

int countIn = 0;


#endif