/**
@file main.cpp
@brief Main file for executing functions that have variables in main.h.

@author Dogukan Kamacioglu
@brief University of Leeds 2645 Sensor Project
@date   April 2015
*/

#include "main.h"

int main()
{
    init_K64F(); /// Initialising board
    lcd.init(); /// Initialising LCD
    welcomeMessage(); /// Displaying welcome message
    lcd.refresh(); /// Refreshing screen after welcome mesage
    // walls(); /// Draving walls to simulate object ahead
    // lcd.refresh(); /// Refreshing screen after walls built

    but.rise(&butPressed); /// Event generated on rising edge
    but.mode(PullDown); /// Pulling up button


    wait(1.0); /// 1 second wait after refreshing screen and before executing while loop

    while (1) { /// Execution of while loop


        measureDistance(); /// Measuring distance between the sensor and oject regularly
        printDistance(); /// Printing distances as distance updated

    }

}


void welcomeMessage() /// Welcome message details
{
    lcd.printString("University of ",5,2); /// Printing "University of Leeds" at coordinate 5,2
    lcd.printString("Leeds",27,3);
    wait(2.0); /// Waiting 2 seconds before clearing the screen
    lcd.clear(); /// Clearing screen for next message

    lcd.printString("2645 Project",7,0); ///Print "2645 Project" at coordinate 6,0
    wait(0.3); ///0.3 seconds delay
    lcd.printString("Distance",19,1); ///Print "Distance" at coordinate 19,1
    wait(0.3); ///0.3 seconds delay
    lcd.printString("Sensor",25,2); ///Print "Sensor" at coordinate 25,2
    wait(0.3); ///0.3 seconds delay
    lcd.printString("By Dogukan",13,3); ///Print "By Dogukan" at coordinate 13,3
    wait(0.3); ///0.3 seconds delay
    lcd.printString("Kamacioglu",13,4); ///Print "Kamacioglu" at coordinate 13,4
    wait(0.3); ///0.3 seconds delay
    lcd.printString("200792949",16,5); ///Print "200792949" at coordinate 16,5
    wait(2.0); ///2 seconds delay
    lcd.clear(); /// Clearing screen after welcome messages for displaying distances.
}


void measureDistance() ///Take 5 readings from the sensor.
{
    int Array[5]; /// initialise the array for storing distances in cm's
    int ArrayIn[5]; /// initialise the array for storing distances in cm's for showing distance in inches
    int Total = 0; /// Taking total of 5 readings
    int TotalIn = 0; /// Taking total of 5 readings
    int count = 0; /// Counting numbers that are stored in array
    int countIn = 0; /// Counting numbers that are stored in inch array


    for(count = 0; count < 5; count++) { /// Counting 5 values for array
        Array [count] = Sensor.getDistanceCm(); /// Storing datas in array obtained from sensor in cm's
        float dist= Sensor.getDistanceCm(); /// Setting variable dist for values obtained from sensor
        Total = Total + Array[count]; /// Fiding the total value of the array
    }

    for(countIn = 0; countIn < 5; countIn++) { // Counting 5 values for array
        ArrayIn [countIn] = Sensor.getDistanceCm(); /// Storing datas in array obtained from sensor in cm's
        float dist1= Sensor.getDistanceIn(); /// Setting variable dist1 for values obtained from sensor
        TotalIn = TotalIn + ArrayIn[countIn]; /// Fiding the total value of the array
    }

    dist = (Total/5); /// Dividing total into 5 to find average distance
    lcd.refresh(); /// Refreshing lcd for updating values

    dist1 = ((TotalIn*0.393701)/5); /// Multiplying total by 0.393 for finding distance in inches and dividing total into 5 to find average distance
    lcd.refresh(); /// Refreshing lcd for updating values

    dynamicBeeper(); /// Executing dynamic beeper right after calculating distance

}


void printDistance() //Display sensor reading to the user
{
    char buffer[14]; /// Setting a gap for 14 digits
    char buffer1[14]; /// Setting a gap for 14 digits

    int length = sprintf(buffer,"Dis: %d cm",dist); /// Printing calculated distance on screen
    lcd.clear(); /// Clearing lcd

    int lengthinch = sprintf(buffer1,"Dis: %d in",dist1); /// Printing calculated distance on screen
    lcd.clear(); /// Clearing lcd

    if (length <=14) {
        lcd.printString(buffer,0,1);
        wait(0.1);
    }

    if (lengthinch <=14) {
        lcd.printString(buffer1,0,4);
        wait(0.1);
    }

    walls(); /// Draving walls to simulate object ahead

    lcd.refresh(); /// Refreshing lcd to update measurements instantly
}


void condition1() ///Buzzer and LED condition 1
{
    red = 0; ///Switch red LED off
    green = 1; ///Switch green LED on
    buzzer.beep(700,0.05); /// Buzzer beeps at 700Hz in 0.05 sec periods

    if (butFlag) { /// If button pressed put buzzer to silent until distance updates
        butFlag = !butFlag;

        buzzer.nobeep ();
    }
}


void condition2() ///Buzzer and LED condition 2
{
    red = 0; ///Switch red LED off
    green = 1; ///Switch green LED off
    buzzer.beep(700,0.2); /// Buzzer beeps at 700Hz in 0.2 sec periods

    if (butFlag) { /// If button pressed put buzzer to silent until distance updates
        butFlag = !butFlag;

        buzzer.nobeep ();
    }

}


void condition3() //Buzzer and LED condition 3
{
    red = 0; //Switch red LED off
    green = 1; //Switch green LED on
    buzzer.beep(700,0.6); /// Buzzer beeps at 700Hz in 0.6 sec periods

    if (butFlag) { /// If button pressed put buzzer to silent until distance updates
        butFlag = !butFlag;

        buzzer.nobeep ();
    }

}


void dangerCondition() //Buzzer and LED condition 4
{
    red = 1; //Switch red LED on
    green = 0; //Switch green LED off
    buzzer.beep(700,1.4); /// Buzzer beeps at 700Hz in 1.4 sec periods

    if (butFlag) { /// If button pressed put buzzer to silent until distance updates
        butFlag = !butFlag;

        buzzer.nobeep ();
    }

}


void dynamicBeeper() /// Beeper condition changes dynamically depending on distance
{
    if (dist >= 100) { ///Buzzer and LED condition 1
        condition1(); ///Green LED and a 0.05 sec periods beep at 700hz

    } else if (dist >= 60 & dist < 100) { ///Buzzer and LED condition 2
        condition2(); ///Green LED and a 0.2 sec periods beep at 700hz

    } else if (dist >= 20 & dist < 60) { ///Buzzer and LED condition 3
        condition3(); ///Green LED and a 0.6 sec periods beep at 700hz

    } else if (dist < 20) { ///Buzzer and LED condition 4
        dangerCondition(); ///Red LED and a 1.4 sec periods beep at 700hz

    }
}


void butPressed() ///ISR for button
{
    butFlag = !butFlag; ///Set a flag when button is pressed
}


void walls() /// Building walls
{
    for (int i = 0; i < WIDTH; i++) { /// Build a line at y=1
        lcd.setPixel(i,1);
    }

    for (int i = 0; i < WIDTH; i++) { /// Build a line at y=2
        lcd.setPixel(i,2);
    }

    for (int i = 0; i < WIDTH; i++) { /// Build a line at y=45
        lcd.setPixel(i,45);
    }

    for (int i = 0; i < WIDTH; i++) { /// Build a line at y=46
        lcd.setPixel(i,46);
    }
}

void init_K64F() /// initialising the K64F
{
    ///setting on board LED's off
    r_led = 1;
    g_led = 1;
    b_led = 1;

    sw2.mode(PullNone); /// pulling buttons to none
    sw3.mode(PullNone);

}
