/*
@file Radar.h
@brief Header file containing member functions and variables
@author James Erringham-Bruce
*/

#ifndef RADAR_H
#define RADAR_H

#include "mbed.h"           // mbed library
#include "DataController.h"

// creating the class used in plotting the graph
class Radar
{
    // defining the public functions
public:
    /**
    @param int average - average reading of distance
    function that allows the user to visually see a wall of pixels moving with respect to the average distance, interactive moving 
    radar so they can see how far they are from the set distance
    */
    void radarMode();

    // defining the private functions
private:

};

//*****************************************************************************************************//

// END OF CLASS //

//*****************************************************************************************************//

#endif

/**
@file Radar.cpp
@brief Member functions implementations
@author James Erringham-Bruce
*/

// FUNCTION TO DISPLAY THE DISTANCE IN A VISUAL WAY
void Radar::radarMode()
{
    /// print a semi-circle at the bottom of the page to act as user position 
    isInRadar = 1;
    while (isInRadar) {
        int average = getAverageReadingCm();
        
        goBackToMenu();
        /// then display the outline of another circle that outlines bigger or lower
        /// with respect to the distance value 
        if (g_timer_flag) { // firing the timer
            g_timer_flag = 0;
            int radias = average/(250/48);
            lcd.clear(); // clear the screen ready for this mode to be displayed
            lcd.drawCircle(42,52,10,1); // printing the users position at the bottom of the screen like a semi-circle
            lcd.drawCircle(42,52,radias,0); // wall of pixels ( circle ) radias changes with respect to average value
            lcd.refresh(); // refresh the screen to dispaly changes
        }
        sleep(); // sleep before next interrupt
    }
}

//*****************************************************************************************************//

// END OF FUNCTION IMPLEMENTATIONS //

//*****************************************************************************************************//





