/**
@file main.cpp

@brief Program implementation
*/

#include "MainMenu.h"
#include "intro.h"

Menu menu; // passing in the class data for the main menu

// MAIN //
int main()
{
    init_all(); /// initialise the screen, mbed, tickers
    wait(2); // waiting for power to settle across the distance sensor
    performAnimatedIntro(); ///animated introduction screen performed
    menu.mainMenu(); /// load the menu screen
}

// FUNCTION TO INITIALISE THE MBED
void init_K64F()
{
    /// on-board LEDs are active-low, so set pin high to turn them off.
    r_led = 1;
    g_led = 1;
    b_led = 1;

    /// since the on-board switches have external pull-ups, we should disable the internal pull-down
    /// resistors that are enabled by default using InterruptIn
    sw2.mode(PullNone);
    sw3.mode(PullNone);

}

// TIMER FLAG 1
void timer_isr()
{
    g_timer_flag = 1;   /// set flag in ISR
}

// TIMER FLAG 2
void timer_isr2()
{
    g_timer_flag2 = 1;   /// set flag in ISR
}

// TIMER FLAG 2
void settings_timer_isr()
{
    settings_timer_flag = 1;   /// set flag in ISR
}


// FUNCTION TO ELIMINATE AND REDUCE ERRORS WHEN OBTAINING THE AVERAGE READING
void readingErrors()
{
    /// check if the distance is out of range
        /// if so, display warning text and activate LED or Buzzer depending on the settings
        lcd.printString("distance is",15,2); // printing error message
        lcd.printString("unreadable",17,3);
        if (LED_Toggle) {
            LED = 1; // warning LED activated
        } else {
            LED = 0; // warning LED activated
        }
        if (buzzer_Toggle) {
            buzzerAlert = 0.5; // 50% duty cycle
        } else {
            buzzerAlert = 0; // turn off buzzer (0% duty cycle)
        }
        // both can be disabled in the settings
}

// FUNCTION TO SET UP THE SYSTEM
void init_all()
{
    /// intitialise all tickers and button modes
    /// including the K64F & N5110
    lcd.init(); // initialise the screen
    init_K64F(); // initialise the mbed
    init_serial(); // initialise the serial
    lcd.clear(); // clear the screen from all previous data
    ticker.attach(&timer_isr,1); // attach ticker 1 - ( 1 second fire rate )
    ticker2.attach(&timer_isr2,5); // attach ticker 2 - ( 3 second fire rate )
    settingsTicker.attach(&settings_timer_isr,0.5); // attach settings ticker - ( 1/2 second fire rate )
    menuTicker.attach(&menu_isr,0.5); // attach settings ticker - ( 1/2 second fire rate )
    backButton.mode(PullDown);
    backButton.fall(&backButton_isr);
    interruptSelector.mode(PullDown);
    interruptSelector.fall(&selector_isr);
}

//*****************************************************************************************************//

// END OF FUNCTION IMPLEMENTATIONS //

//*****************************************************************************************************//





