/*
@file MainMenu.h
@brief Header file containing member functions and variables
@author James Erringham-Bruce
*/

#ifndef MAINMENU_H
#define MAINMENU_H

#include "mbed.h"           // mbed library
#include "Radar.h"
#include "Graph.h"
#include "UserSettings.h"
#include "DataController.h"

// creating the class used in plotting the graph
class Menu
{
    // defining the public functions and variables
public:
    /**
    function to intilaise the banks where each bank is declared in order to display the different settings on the screen
    to the user to interact with
    */
    void mainMenu();
    /**
    function to state which option on the menu the user has selected in order to print the next screen
    */
    void runSelection(int bank);
    /**
    function to state which labels will be displayed on the screen to the user
    */
    void printText();
    /**
    function that uses the potentiometer value in order to achieve the bank value
    */
    int getBank();
    /**
    function which takes measurements from the sensor and calculates an average measurement
    then prints each of the values in cm and inches on the screen for the user to see as a visual display
    */
    void numerical();

    // defining the private functions and variables
private:

};
//*****************************************************************************************************//

// END OF CLASS //

//*****************************************************************************************************//
#endif

// pass in the data from classes elsewhere
Graph graph;
Radar radar;
UserSettings setting;

// FUNCTION TO GET THE BANK THAT THE HIGHLIGHT SHOULD BE PRINTED AT
int Menu::getBank()
{
    /// take the value of the potentiometer and return the corresponding bank
    int bankReturn;
    if (selectorPot < 0.25f) {
        bankReturn = 2;
    }
    if (selectorPot >= 0.25f && selectorPot < 0.5f) {
        bankReturn = 3;
    }
    if (selectorPot >= 0.5f && selectorPot < 0.75f) {
        bankReturn = 4;
    }
    if (selectorPot >= 0.75f) {
        bankReturn = 5;
    }
    return bankReturn; // return the value obtained
}

// MAIN MENU FUNCTION WHERE THE USER CAN INTERFACE
void Menu::mainMenu()
{
    int bank = 0; // initialise the bank
    isInMenu = 1; // declaring the menu screen is active

    while (isInMenu) {
        if (menu_flag) { // ticker
            menu_flag = 0;
            lcd.clear();
            /// get the bank value from the 'getBank' function
            bank = getBank(); // get the bank value
            printText(); // print the users options and title
            // looping through one bank of the screen ( bank 0 in this case)
            // similar algorithm to my scrolling method
            /// convert to pixel form by multiplying by 8
            int tempBank = bank*8;
            /// loop through columns and rows and invert the bank returned
            for ( int columns = 0; columns < 84; columns++ ) {
                // multiply by eight to convert bank value to the rows in that bank
                for ( int currentBank = (bank*8) - 1; currentBank < tempBank+8; currentBank++) {
                    if (lcd.getPixel(columns, currentBank)) { // if the pixel is set
                        lcd.clearPixel(columns, currentBank); // clear it
                    } else { // set the other pixels
                        lcd.setPixel(columns, currentBank); // basically inverting the screen
                    }
                }
            }
            runSelection(bank); // check if a selection has been made
            lcd.refresh();
        }
    }
}

// FUNCTION TO RUN THE SELECTED OPTION IF BUTTON IS PRESSED
void Menu::runSelection(int bank)
{
    /// if the buttton is pressed while at a certain bank, then run that option

    if (selector_flag ) {
        selector_flag = 0;

        if (bank == 2) {
            isInMenu = 0;
            setting.printScreen(); // settings screen
        }
        if (bank == 3) {
            isInMenu = 0;
            graph.plotGraph(); // graph screen
        }
        if (bank == 4) {
            isInMenu = 0;
            numerical(); // numerical screen
        }
        if (bank == 5) {
            isInMenu = 0;
            radar.radarMode(); // radar view (basic Y axis, no X axis movement)
        }

    }
}

// FUNCTION TO PRINT THE DISTANCE ON SCREEN IN NUMERICAL FORM
void Menu::numerical()
{
    isInNumerical = 1;// sets flag to 1 so it can keep running in a cycle

    while (isInNumerical) {
        /// obtain the average value in both cm & inches
        int avgCm = getAverageReadingCm(); //average reading in cm
        int avgInch = getAverageReadingInch(); //average reading in inches
        LED = 0; //LED set to logic 0
        goBackToMenu();//if interrupt is pressed go back to main menu

        if (g_timer_flag) { // firing the first timer flag
            g_timer_flag = 0;//resets the flag and runs again
            lcd.clear(); // clear the screen ( preparing for the reading to be dispalyed
            /// print both of the values on the screen as timer fires
            if (avgCm <=250 && avgCm >=15) { // if in bounds..
                lcd.printString("DISTANCE", 18, 0); //display distance
                // 6 pixels across per char, 84 pixels wide along the screen
                int length = sprintf(buffer,"d = %d cm",avgCm); // defining max length of chars 84 ÷ 6 = 14
                if (length <= 14) { /// if string will fit on display
                    lcd.printString(buffer, 5, 3);//print string to buffer
                }
                // 6 pixels across per char, 84 pixels wide along the screen
                length = sprintf(buffer,"d = %d Inch",avgInch); // defining max length of chars 84 ÷ 6 = 14
                if (length <= 14) { /// if string will fit on display
                    lcd.printString(buffer, 5, 4); //print string to buffer
                }
            } else {
                /// check for reading errors to determine if LED or Buzzer turns on
                readingErrors(); //check for reading error
            }
            lcd.refresh(); // refresh the screen displaying the average reading
        }
        sleep(); // sleep before next interrupt
    }
}

// FUNCTION TO PRINT TEXT TO THE MAIN MENU
void Menu::printText()
{
    /// print the text of the menu
    lcd.printString("MENU",30,0); // print the title
    lcd.drawLine(28,8,54,8,1); // underlining the title
    lcd.printString("SETTINGS",17,2); // options
    lcd.printString("GRAPH PLOT",12,3); //...
    lcd.printString("NUMERICAL",16,4); //...
    lcd.printString("RADAR MODE",12,5); //...
}

//
void menu_isr()
{
    menu_flag = 1;

}

//*****************************************************************************************************//

// END OF FUNCTION IMPLEMENTATIONS //

//*****************************************************************************************************//






