#include "mbed.h"
#include "N5110.h"

#define DIRECTION_TOLERANCE 0.05L

//         VCC,    SCE,   RST,   D/C,   MOSI,  SCLK,   LED
N5110 lcd (PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);

// connections for joystick
DigitalIn button(PTB11);
AnalogIn xPot(PTB2);
AnalogIn yPot(PTB3);

AnalogIn Pot1(PTB10);

PwmOut led1(PTC2);

//InterruptIn sw2 (SW2);
DigitalIn buttonA(PTB18);
DigitalIn buttonB(PTB19);
PwmOut buzzer(PTA2);

//volatile int g_sw2_flag = 0;
int shipShape [7][11] = {
    {0,0,0,0,0,0,0,0,0,0,1},
    {0,0,0,0,0,1,1,1,1,1,0},
    {0,0,1,1,1,1,1,1,1,0,0},
    {1,1,1,1,1,1,1,1,0,0,0},
    {0,0,1,1,1,1,0,1,1,0,0},
    {0,0,0,0,0,1,1,1,1,1,0},
    {0,0,0,0,0,0,0,0,0,0,1}
};

void ship()
{
    for(int shipR = 0; shipR <= 6; shipR ++) {
        for(int shipC = 0; shipC <= 10; shipC ++) {
            if(shipShape[shipR][shipC] == 0) {
                lcd.clearPixel(shipR + 35,shipC + 20);
            } else if(shipShape[shipR][shipC] == 1) {
                lcd.setPixel(shipR + 35,shipC + 20);
            }
        }
    }
    lcd.refresh();
    
}


// timer to regularly read the joystick
Ticker pollJoystick;

enum DirectionName {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    CENTRE,
    UNKNOWN
};

// struct for Joystick
typedef struct JoyStick Joystick;
struct JoyStick {
    float x;    // current x value
    float x0;   // 'centred' x value
    float y;    // current y value
    float y0;   // 'centred' y value
    int button; // button state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    int buttonA; // buttonA state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    int buttonB; // buttonB state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    DirectionName direction;  // current direction
};
// create struct variable
Joystick joystick;

int printFlag = 0;

// function prototypes
void calibrateJoystick();
void updateJoystick();

//void sw2_isr();

void menu();
void game();
void difficultySet();
void highScore();
void instructions();


int menuSelect = 2; //Default value of menuSelect so cursor is already on "Start" option
int menuUp = 1;//default value for indicator to show menu is up

int main()
{
    while(1) {
        calibrateJoystick();  // get centred values of joystick
        pollJoystick.attach(&updateJoystick,1.0/10.0);  // read joystick 10 times per second
        while(menuUp == 1) {
            menu();
        }
    }
}

void menu()
{
    calibrateJoystick();  // get centred values of joystick
    pollJoystick.attach(&updateJoystick,1.0/10.0);  // read joystick 10 times per second

    lcd.init();
    lcd.clear();
    lcd.normalMode();
    lcd.printString("Comet Crusher!",0,0);
    lcd.printString("Start",10,2);
    lcd.printString("Instructions",10,3);
    lcd.printString("Difficulty",10,4);
    lcd.printString("Scores",10,5);
    lcd.printString(">",5,menuSelect);
    lcd.refresh();
    sleep();
    switch (menuSelect) {
        case 2:
            if (joystick.direction == DOWN) {
                menuSelect = 3;
                lcd.refresh();
                wait (0.2);
                sleep();
            } else if (joystick.direction == UP) {
                menuSelect = 5;
                lcd.refresh();
                wait (0.2);
                sleep();
            }
            if (buttonA == 1) {
                menuUp = 0;
                game();
            }
            break;
        case 3:
            if (joystick.direction == DOWN) {
                menuSelect = 4;
                lcd.refresh();
                wait (0.2);
                sleep();
            } else if (joystick.direction == UP) {
                menuSelect = 2;
                lcd.refresh();
                wait (0.2);
                sleep();
            }
            break;
        case 4:
            if (joystick.direction == DOWN) {
                menuSelect = 5;
                lcd.refresh();
                wait (0.2);
                sleep();
            } else if (joystick.direction == UP) {
                menuSelect = 3;
                lcd.refresh();
                wait (0.2);
                sleep();
            }
            break;
        case 5:
            if (joystick.direction == DOWN) {
                menuSelect = 2;
                lcd.refresh();
                wait (0.2);
                sleep();
            } else if (joystick.direction == UP) {
                menuSelect = 4;
                lcd.refresh();
                wait (0.2);
                sleep();
            }
            break;
    }
}
void game()
{
    // SW2 has a pull-up resistor, so the pin will be at 3.3 V by default
    // and fall to 0 V when pressed. We therefore need to look for a falling edge
    // on the pin to fire the interrupt
    //sw2.fall(&sw2_isr);
    //since SW2 has an external pull-up, we should disable to internal pull-down
    // resistor that is enabled by default using InterruptIn
    //sw2.mode(PullNone);
    
    lcd.clear(); //Clear menu and start game
    ship();
}

void difficultySet()
{
}

void highScore()
{
}

void instructions()
{
}




void calibrateJoystick()
{
    button.mode(PullDown);
    buttonA.mode(PullDown);
    buttonB.mode(PullDown);

    // must not move during calibration
    joystick.x0 = xPot;  // initial positions in the range 0.0 to 1.0 (0.5 if centred exactly)
    joystick.y0 = yPot;
}
void updateJoystick()
{
    // read current joystick values relative to calibrated values (in range -0.5 to 0.5, 0.0 is centred)
    joystick.x = xPot - joystick.x0;
    joystick.y = yPot - joystick.y0;
    // read button state
    joystick.button = button;
    joystick.buttonA = buttonA;
    joystick.buttonB = buttonB;

    // calculate direction depending on x,y values
    // tolerance allows a little lee-way in case joystick not exactly in the stated direction
    if ( fabs(joystick.y) < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = CENTRE;
    } else if ( joystick.y > DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = DOWN;
    } else if ( joystick.y < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = UP;
    } else if ( joystick.x > DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = LEFT;
    } else if ( joystick.x < DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = RIGHT;
    } else {
        joystick.direction = UNKNOWN;
    }

    // set flag for printing
    printFlag = 1;
}