#include "mbed.h"
#include "N5110.h"

#define DIRECTION_TOLERANCE 0.05L

//         VCC,    SCE,   RST,   D/C,   MOSI,  SCLK,   LED
N5110 lcd (PTE26 , PTA0 , PTC4 , PTD0 , PTD2 , PTD1 , PTC3);

// connections for joystick
DigitalIn button(PTB11);
AnalogIn xPot(PTB2);
AnalogIn yPot(PTB3);

AnalogIn Pot1(PTB10); //Declaring the variable resistor as an AnalogIn

PwmOut led1(PTC2);//Declaring that led 1 is used as a PwmOut

//InterruptIn sw2 (SW2);

DigitalIn buttonA(PTB18); //Declaring that button A is used as a DigitalIn
DigitalIn buttonB(PTB19); //Declaring that button B is used as a DigitalIn

PwmOut buzzer(PTA2);//Declaring that buzzer is used as a PwmOut

//volatile int g_sw2_flag = 0;

// timer to regularly read the joystick
Ticker pollJoystick;

// Giving the names of the direction of the joystick
enum DirectionName {
    UP,
    DOWN,
    LEFT,
    RIGHT,
    CENTRE,
    UNKNOWN
};

// struct for Joystick
typedef struct JoyStick Joystick;
struct JoyStick {
    float x;    // current x value
    float x0;   // 'centred' x value
    float y;    // current y value
    float y0;   // 'centred' y value
    int button; // button state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    int buttonA; // buttonA state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    int buttonB; // buttonB state (assume pull-down used, so 1 = pressed, 0 = unpressed)
    DirectionName direction;  // current direction
};
// create struct variable
Joystick joystick;

int printFlag = 0;

// function prototypes
void calibrateJoystick(); //Declaring the calibration of joystick void
void updateJoystick(); //Declaring the updating of the joystick displacement void

//void sw2_isr();

void menu(); //Declaring the menu void
void game();//Declaring the game void
void difficultySet();//Declaring the difficulty setting void
void highScore();//Declaring the highscore displaying void
void instructions();//Declaring the instructions display void
void ship();//Declaring the ship displaying void
void bullets();//Declaring the bullets displaying void
void comets();//Declaring the comet displaying void


int menuSelect = 2; //Default value of menuSelect so cursor is already on "Start" option
int menuUp = 1;//Default value for indicator to show menu is up
int gameUp = 0; //Default value to show if game is playing
int instructionsPage = 0; //Default value to show what page of instructions is up
int shipDirection = 0; //Default value to decide with direction the space ship is facing
int gameOver = 0; //Default value to say when the game is over
int cometMoveX = 0; //Default value to the X axis movement of the comets
int cometMoveY = 0; //Default value to the Y axis movement of the comets
int bulletMoveX = 0; //Default value to the X axis movement of the bullets
int bulletMoveY = 0; //Default value to the Y axis movement of the bullets

int main()
{
    while(1) {
        calibrateJoystick();  // get centred values of joystick
        pollJoystick.attach(&updateJoystick,1.0/10.0);  // read joystick 10 times per second
        while(menuUp == 1) {
            menu();
        }
        lcd.refresh();
    }
}

void menu()
{
    calibrateJoystick();  // get centred values of joystick
    pollJoystick.attach(&updateJoystick,1.0/10.0);  // read joystick 10 times per second

    lcd.init();
    lcd.clear();
    lcd.normalMode();
    //Displaying the main menu and showing the name of the game
    lcd.printString("Comet Crusher!",0,0);
    lcd.printString("Start",10,2);
    lcd.printString("Instructions",10,3);
    lcd.printString("Difficulty",10,4);
    lcd.printString("Scores",10,5);
    lcd.printString(">",5,menuSelect); //this is the cursor to show what is being selected
    lcd.refresh();
    sleep();

    //the switch case allows you to move the cursor depending on the displacement of the joystick
    switch (menuSelect) {
        case 2:
            if (joystick.direction == DOWN) {
                menuSelect = 3;
                lcd.refresh();
                wait (0.2);
                sleep();
            } else if (joystick.direction == UP) {
                menuSelect = 5;
                lcd.refresh();
                wait (0.2);
                sleep();
            }
            if (buttonA == 1) {
                menuUp = 0;
                gameUp = 1;
                game();
            }
            break;
        case 3:
            if (joystick.direction == DOWN) {
                menuSelect = 4;
                lcd.refresh();
                wait (0.2);
                sleep();
            } else if (joystick.direction == UP) {
                menuSelect = 2;
                lcd.refresh();
                wait (0.2);
                sleep();
            }
            if (buttonA == 1) {
                menuUp = 0;
                instructions();
            }
            break;
        case 4:
            if (joystick.direction == DOWN) {
                menuSelect = 5;
                lcd.refresh();
                wait (0.2);
                sleep();
            } else if (joystick.direction == UP) {
                menuSelect = 3;
                lcd.refresh();
                wait (0.2);
                sleep();
            }
            if (buttonA == 1) {
                menuUp = 0;
                difficultySet();
            }
            break;
        case 5:
            if (joystick.direction == DOWN) {
                menuSelect = 2;
                lcd.refresh();
                wait (0.2);
                sleep();
            } else if (joystick.direction == UP) {
                menuSelect = 4;
                lcd.refresh();
                wait (0.2);
                sleep();
            }
            if (buttonA == 1) {
                menuUp = 0;
                highScore();
            }
            break;
    }
}
void game()
{
    // SW2 has a pull-up resistor, so the pin will be at 3.3 V by default
    // and fall to 0 V when pressed. We therefore need to look for a falling edge
    // on the pin to fire the interrupt
    //sw2.fall(&sw2_isr);
    //since SW2 has an external pull-up, we should disable to internal pull-down
    // resistor that is enabled by default using InterruptIn
    //sw2.mode(PullNone);

    while(gameUp) {
        lcd.clear(); //Clear menu and starts game
        lcd.inverseMode();
        ship();
        comets();
        /*if (g_sw2_flag == 1) {
            gameUp = 0;
            lcd.printString("pause",20,3);
            if(g_sw2_flag == 0) {
                gameUp = 1;
            }
        }*/
    }

}

//This is for the difficulty setting page to decide how hard the game play will be
void difficultySet()
{
    lcd.clear();
    lcd.printString("Difficulty:",0,0);
    while(!menuUp) {
        if (buttonB == 1) {
            menuUp = 1;
            menu();
        }
    }
}

//This is for the highscores that people have gotten on the game
void highScore()
{
    lcd.clear();
    lcd.printString("HighScores:",0,0);
    lcd.printString("1)",0,1);
    lcd.printString("2)",0,2);
    lcd.printString("3)",0,3);
    while(!menuUp) {
        if (buttonB == 1) {
            menuUp = 1;
            menu();
        }
    }
}

//this displays the instructions on how to play the game
void instructions()
{
    switch(instructionsPage) {
        case 0:
            lcd.clear();
            lcd.printString(" Game controls:",0,0);
            lcd.printString("Joystick L/R =",5,1);
            lcd.printString("rotate ship",10,2);
            lcd.printString("Button A =",5,3);
            lcd.printString("shoot",10,4);
            lcd.printString("next page->",0,5);
            break;
        case 1:
            lcd.clear();
            lcd.printString("Game controls:",0,0);
            lcd.printString("Button B =",5,1);
            lcd.printString("block",10,2);
            lcd.printString("next page->",0,5);
            break;
        case 2:
            lcd.printString("Diff control:",0,0);
            lcd.printString("Variable res =",5,1);
            lcd.printString("change diff",10,2);
            lcd.printString("First page->",0,5);

            while(!menuUp) {
                if(buttonA == 1) {
                    for(instructionsPage = 0; instructionsPage < 3; instructionsPage ++) {
                        instructionsPage =instructionsPage + 1;
                    }
                }
                if (buttonB == 1) {
                    menuUp = 1;
                    menu();
                }
            }
    }
}
//this will display the ship when game is playing and will let you be able to change the direction of the ship
void ship()
{
    calibrateJoystick();  // get centred values of joystick
    pollJoystick.attach(&updateJoystick,1.0/10.0);  // read joystick 10 times per second

    int shipShape1 [7][11] = {
        {0,0,0,0,0,0,0,0,1,1,1},
        {0,0,0,0,0,1,1,1,1,1,0},
        {0,0,1,1,1,1,1,1,1,0,0},
        {1,1,1,1,1,1,1,1,0,0,0},
        {0,0,1,1,1,1,1,1,1,0,0},
        {0,0,0,0,0,1,1,1,1,1,0},
        {0,0,0,0,0,0,0,0,1,1,1}
    };
    int shipShape2 [10][11] = {
        {0,0,0,0,0,0,1,0,0,0,0},
        {0,0,0,0,0,1,1,0,0,0,0},
        {0,0,0,0,1,1,1,0,0,0,0},
        {0,0,0,0,1,1,1,0,0,0,0},
        {0,0,0,1,1,1,1,1,1,1,1},
        {0,0,0,1,1,1,1,1,1,1,0},
        {0,0,1,1,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,0,0,0,0},
        {0,1,1,1,1,0,0,0,0,0,0},
        {0,1,1,0,0,0,0,0,0,0,0}

    };
    int shipShape3 [11][7] = {
        {1,0,0,0,0,0,1},
        {1,1,0,0,0,1,1},
        {1,1,1,0,1,1,1},
        {0,1,1,1,1,1,0},
        {0,1,1,1,1,1,0},
        {0,1,1,1,1,1,0},
        {0,0,1,1,1,0,0},
        {0,0,1,1,1,0,0},
        {0,0,1,1,1,0,0},
        {0,0,0,1,0,0,0},
        {0,0,0,1,0,0,0}
    };
    int shipShape4 [10][11] = {
        {0,0,0,0,1,0,0,0,0,0,0},
        {0,0,0,0,1,1,0,0,0,0,0},
        {0,0,0,0,1,1,1,0,0,0,0},
        {0,0,0,0,1,1,1,0,0,0,0},
        {1,1,1,1,1,1,1,1,0,0,0},
        {0,1,1,1,1,1,1,1,0,0,0},
        {0,0,1,1,1,1,1,1,1,0,0},
        {0,0,0,0,1,1,1,1,1,0,0},
        {0,0,0,0,0,0,1,1,1,1,0},
        {0,0,0,0,0,0,0,0,1,1,0}
    };
    int shipShape5 [7][11] = {
        {1,1,1,0,0,0,0,0,0,0,0},
        {0,1,1,1,1,1,0,0,0,0,0},
        {0,0,1,1,1,1,1,1,1,0,0},
        {0,0,0,1,1,1,1,1,1,1,1},
        {0,0,1,1,1,1,1,1,1,0,0},
        {0,1,1,1,1,1,0,0,0,0,0},
        {1,1,1,0,0,0,0,0,0,0,0}
    };
    int shipShape6 [10][11] = {
        {0,0,0,0,0,0,0,0,1,1,0},
        {0,0,0,0,0,0,1,1,1,1,0},
        {0,0,0,0,1,1,1,1,1,0,0},
        {0,0,1,1,1,1,1,1,1,0,0},
        {0,1,1,1,1,1,1,1,0,0,0},
        {1,1,1,1,1,1,1,1,0,0,0},
        {0,0,0,0,1,1,1,0,0,0,0},
        {0,0,0,0,1,1,1,0,0,0,0},
        {0,0,0,0,1,1,0,0,0,0,0},
        {0,0,0,0,1,0,0,0,0,0,0}
    };
    int shipShape7 [11][7] = {
        {0,0,0,1,0,0,0},
        {0,0,0,1,0,0,0},
        {0,0,1,1,1,0,0},
        {0,0,1,1,1,0,0},
        {0,0,1,1,1,0,0},
        {0,1,1,1,1,1,0},
        {0,1,1,1,1,1,0},
        {0,1,1,1,1,1,0},
        {1,1,1,0,1,1,1},
        {1,1,0,0,0,1,1},
        {1,0,0,0,0,0,1}
    };
    int shipShape8 [10][11] = {
        {0,1,1,0,0,0,0,0,0,0,0},
        {0,1,1,1,1,0,0,0,0,0,0},
        {0,0,1,1,1,1,1,0,0,0,0},
        {0,0,1,1,1,1,1,1,0,0,0},
        {0,0,0,1,1,1,1,1,1,1,0},
        {0,0,0,1,1,1,1,1,1,1,1},
        {0,0,0,0,1,1,1,0,0,0,0},
        {0,0,0,0,0,1,1,0,0,0,0},
        {0,0,0,0,0,1,1,0,0,0,0},
        {0,0,0,0,0,0,1,0,0,0,0}
    };


    while(gameUp) {
        lcd.printString("Score:",0,0);

        if (joystick.direction == RIGHT) {
            if (shipDirection < 7) {
                shipDirection = shipDirection + 1;
            } else if (shipDirection == 7) {
                shipDirection = 0;
            }
        } else if (joystick.direction == LEFT) {
            if (shipDirection > 0) {
                shipDirection = shipDirection - 1;
            } else if(shipDirection == 0) {
                shipDirection = 7;
            }
        }

        switch(shipDirection) {
            case 0:
                lcd.clear();
                lcd.printString("Score:",0,0);
                for(int shipR = 0; shipR <= 6; shipR ++) {
                    for(int shipC = 0; shipC <= 10; shipC ++) {
                        if(shipShape1[shipR][shipC] == 0) {
                            lcd.clearPixel(shipR + 38,shipC + 18);
                        } else if(shipShape1[shipR][shipC] == 1) {
                            lcd.setPixel(shipR + 38,shipC + 18);
                        }
                    }
                }
                lcd.refresh();
                break;
            case 1:
                lcd.clear();
                lcd.printString("Score:",0,0);
                for(int shipR = 0; shipR <= 9; shipR ++) {
                    for(int shipC = 0; shipC <= 10; shipC ++) {
                        if(shipShape2[shipR][shipC] == 0) {
                            lcd.clearPixel(shipR + 38,shipC + 18);
                        } else if(shipShape2[shipR][shipC] == 1) {
                            lcd.setPixel(shipR + 38,shipC + 18);
                        }
                    }
                }
                lcd.refresh();
                break;
            case 2:
                lcd.clear();
                lcd.printString("Score:",0,0);
                for(int shipR = 0; shipR <= 10; shipR ++) {
                    for(int shipC = 0; shipC <= 6; shipC ++) {
                        if(shipShape3[shipR][shipC] == 0) {
                            lcd.clearPixel(shipR + 36,shipC + 20);
                        } else if(shipShape3[shipR][shipC] == 1) {
                            lcd.setPixel(shipR + 36,shipC + 20);
                        }
                    }
                }
                lcd.refresh();
                break;
            case 3:
                lcd.clear();
                lcd.printString("Score:",0,0);
                for(int shipR = 0; shipR <= 9; shipR ++) {
                    for(int shipC = 0; shipC <= 10; shipC ++) {
                        if(shipShape4[shipR][shipC] == 0) {
                            lcd.clearPixel(shipR + 38,shipC + 18);
                        } else if(shipShape4[shipR][shipC] == 1) {
                            lcd.setPixel(shipR + 38,shipC + 18);
                        }
                    }
                }
                lcd.refresh();
                break;
            case 4:
                lcd.clear();
                lcd.printString("Score:",0,0);
                for(int shipR = 0; shipR <= 6; shipR ++) {
                    for(int shipC = 0; shipC <= 10; shipC ++) {
                        if(shipShape5[shipR][shipC] == 0) {
                            lcd.clearPixel(shipR + 38,shipC + 18);
                        } else if(shipShape5[shipR][shipC] == 1) {
                            lcd.setPixel(shipR + 38,shipC + 18);
                        }
                    }
                }
                lcd.refresh();
                break;
            case 5:
                lcd.clear();
                lcd.printString("Score:",0,0);
                for(int shipR = 0; shipR <= 9; shipR ++) {
                    for(int shipC = 0; shipC <= 10; shipC ++) {
                        if(shipShape6[shipR][shipC] == 0) {
                            lcd.clearPixel(shipR + 38,shipC + 18);
                        } else if(shipShape6[shipR][shipC] == 1) {
                            lcd.setPixel(shipR + 38,shipC + 18);
                        }
                    }
                }
                lcd.refresh();
                break;
            case 6:
                lcd.clear();
                lcd.printString("Score:",0,0);
                for(int shipR = 0; shipR <= 10; shipR ++) {
                    for(int shipC = 0; shipC <= 6; shipC ++) {
                        if(shipShape7[shipR][shipC] == 0) {
                            lcd.clearPixel(shipR + 36,shipC + 20);
                        } else if(shipShape7[shipR][shipC] == 1) {
                            lcd.setPixel(shipR + 36,shipC + 20);
                        }
                    }
                }
                lcd.refresh();
                break;
            case 7:
                lcd.clear();
                lcd.printString("Score:",0,0);
                for(int shipR = 0; shipR <= 9; shipR ++) {
                    for(int shipC = 0; shipC <= 10; shipC ++) {
                        if(shipShape8[shipR][shipC] == 0) {
                            lcd.clearPixel(shipR + 38,shipC + 18);
                        } else if(shipShape8[shipR][shipC] == 1) {
                            lcd.setPixel(shipR + 38,shipC + 18);
                        }
                    }
                }
                lcd.refresh();
                break;
        }
        sleep();

    }
}

//this void is to display the bullets on when game is playing if button A is pressed
void bullets()
{
    switch(shipDirection) {
        case 0:
            for(bulletMoveY = 0; bulletMoveY >= 0; bulletMoveY++) {
                lcd.setPixel(41,18 + bulletMoveY);
                sleep();
            }
            break;
        case 1:
            for(bulletMoveY = 0; bulletMoveY >= 0; bulletMoveY++) {
                lcd.setPixel(41,18 + bulletMoveY);
                sleep();

            }
            break;
        case 2:
            for(bulletMoveY = 0; bulletMoveY >= 0; bulletMoveY++) {
                lcd.setPixel(44,23 + bulletMoveY);
                sleep();
            }
            break;
        case 3:
            for(bulletMoveY = 0; bulletMoveY >= 0; bulletMoveY++) {
                lcd.setPixel(41,18 + bulletMoveY);
                sleep();
            }
            break;
        case 4:
            for(bulletMoveY = 0; bulletMoveY >= 0; bulletMoveY++) {
                lcd.setPixel(41,28 + bulletMoveY);
                sleep();
            }
            break;
        case 5:
            for(bulletMoveY = 0; bulletMoveY >= 0; bulletMoveY++) {
                lcd.setPixel(41,18 + bulletMoveY);
                sleep();
            }
            break;
        case 6:
            for(bulletMoveY = 0; bulletMoveY >= 0; bulletMoveY++) {
                lcd.setPixel(38,23 + bulletMoveY);
                sleep();
            }
            break;
        case 7:
            for(bulletMoveY = 0; bulletMoveY >= 0; bulletMoveY++) {
                lcd.setPixel(41,18 + bulletMoveY);
                sleep();
            }
            break;
    }
}

//this void will create comets to display on the screen for the ship to destroy or for it to destroy the ship
void comets()
{
    while(gameUp) {
        int cometDirection = rand() % 8 + 1;

        int comet [11][11] = {
            {0,0,0,0,1,1,0,0,0,0,0},
            {0,0,0,1,0,0,1,0,0,0,0},
            {0,0,1,0,0,0,0,1,1,0,0},
            {0,1,0,0,0,0,0,0,0,1,0},
            {0,1,0,0,0,0,0,0,0,0,1},
            {1,0,0,0,0,0,0,0,0,0,1},
            {0,1,1,0,0,0,0,0,0,0,1},
            {0,0,0,1,1,0,0,0,1,1,0},
            {0,0,0,0,0,1,0,0,1,0,0},
            {0,0,0,0,0,1,0,1,0,0,0},
            {0,0,0,0,0,1,1,0,0,0,0}
        };

        switch(cometDirection) {
            case 1:
                for(int cometR = 0; cometR <= 10; cometR ++) {
                    for(int cometC = 0; cometC <= 10; cometC ++) {
                        if(comet[cometR][cometC] == 0) {
                            lcd.clearPixel(cometR + cometMoveX,cometC + cometMoveY);
                        } else if(comet[cometR][cometC] == 1) {
                            lcd.setPixel(cometR + cometMoveX,cometC + cometMoveY);
                        }
                    }
                }
                lcd.refresh();
                break;
            case 2:
                for(int cometR = 0; cometR <= 10; cometR ++) {
                    for(int cometC = 0; cometC <= 10; cometC ++) {
                        if(comet[cometR][cometC] == 0) {
                            lcd.clearPixel(cometR + cometMoveX,cometC + cometMoveY);
                        } else if(comet[cometR][cometC] == 1) {
                            lcd.setPixel(cometR + cometMoveX,cometC + cometMoveY);
                        }
                    }
                }

                lcd.refresh();
                break;
            case 3:
                for(int cometR = 0; cometR <= 10; cometR ++) {
                    for(int cometC = 0; cometC <= 10; cometC ++) {
                        if(comet[cometR][cometC] == 0) {
                            lcd.clearPixel(cometR + cometMoveX,cometC + cometMoveY);
                        } else if(comet[cometR][cometC] == 1) {
                            lcd.setPixel(cometR + cometMoveX,cometC + cometMoveY);
                        }
                    }
                }
                lcd.refresh();
                break;
            case 4:
                for(int cometR = 0; cometR <= 10; cometR ++) {
                    for(int cometC = 0; cometC <= 10; cometC ++) {
                        if(comet[cometR][cometC] == 0) {
                            lcd.clearPixel(cometR + cometMoveX,cometC + cometMoveY);
                        } else if(comet[cometR][cometC] == 1) {
                            lcd.setPixel(cometR + cometMoveX,cometC + cometMoveY);
                        }
                    }
                }

                lcd.refresh();
                break;
            case 5:
                for(int cometR = 0; cometR <= 10; cometR ++) {
                    for(int cometC = 0; cometC <= 10; cometC ++) {
                        if(comet[cometR][cometC] == 0) {
                            lcd.clearPixel(cometR + cometMoveX,cometC + cometMoveY);
                        } else if(comet[cometR][cometC] == 1) {
                            lcd.setPixel(cometR + cometMoveX,cometC + cometMoveY);
                        }
                    }
                }

                lcd.refresh();
                break;
            case 6:
                for(int cometR = 0; cometR <= 10; cometR ++) {
                    for(int cometC = 0; cometC <= 10; cometC ++) {
                        if(comet[cometR][cometC] == 0) {
                            lcd.clearPixel(cometR + cometMoveX,cometC + cometMoveY);
                        } else if(comet[cometR][cometC] == 1) {
                            lcd.setPixel(cometR + cometMoveX,cometC + cometMoveY);
                        }
                    }
                }

                lcd.refresh();
                break;
            case 7:
                for(int cometR = 0; cometR <= 10; cometR ++) {
                    for(int cometC = 0; cometC <= 10; cometC ++) {
                        if(comet[cometR][cometC] == 0) {
                            lcd.clearPixel(cometR + cometMoveX,cometC + cometMoveY);
                        } else if(comet[cometR][cometC] == 1) {
                            lcd.setPixel(cometR + cometMoveX,cometC + cometMoveY);
                        }
                    }
                }

                lcd.refresh();
                break;
            case 8:
                for(int cometR = 0; cometR <= 10; cometR ++) {
                    for(int cometC = 0; cometC <= 10; cometC ++) {
                        if(comet[cometR][cometC] == 0) {
                            lcd.clearPixel(cometR + cometMoveX,cometC + cometMoveY);
                        } else if(comet[cometR][cometC] == 1) {
                            lcd.setPixel(cometR + cometMoveX,cometC + cometMoveY);
                        }
                    }
                }

                lcd.refresh();
                break;

        };
    }
}

void GameOver()
{
    lcd.clear();
    lcd.printString("GAME OVER",20,3);
    wait(2.0);
    menuUp = 1;
    menu();
}

//this will calibrate the joystick
void calibrateJoystick()
{
    button.mode(PullDown);
    buttonA.mode(PullDown);
    buttonB.mode(PullDown);

    // must not move during calibration
    joystick.x0 = xPot;  // initial positions in the range 0.0 to 1.0 (0.5 if centred exactly)
    joystick.y0 = yPot;
}

//this will update the joystick to show it's current displacement
void updateJoystick()
{
    // read current joystick values relative to calibrated values (in range -0.5 to 0.5, 0.0 is centred)
    joystick.x = xPot - joystick.x0;
    joystick.y = yPot - joystick.y0;
    // read button state
    joystick.button = button;
    joystick.buttonA = buttonA;
    joystick.buttonB = buttonB;

    // calculate direction depending on x,y values
    // tolerance allows a little lee-way in case joystick not exactly in the stated direction
    if ( fabs(joystick.y) < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = CENTRE;
    } else if ( joystick.y > DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = DOWN;
    } else if ( joystick.y < DIRECTION_TOLERANCE && fabs(joystick.x) < DIRECTION_TOLERANCE) {
        joystick.direction = UP;
    } else if ( joystick.x > DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = RIGHT;
    } else if ( joystick.x < DIRECTION_TOLERANCE && fabs(joystick.y) < DIRECTION_TOLERANCE) {
        joystick.direction = LEFT;
    } else {
        joystick.direction = UNKNOWN;
    }

    // set flag for printing
    printFlag = 1;
}