#include "sample_buffer.hpp"
#include "sample_hardware.hpp"

//Thread sychronisation primatives
//Semaphore spaceAvailable(BUFFERSIZE);
Semaphore samplesInBuffer(0);
Mutex bufferLock;
int NInBuffer[4];

//Output buffer
float buffer[4][BUFFERSIZE];
unsigned int newestIndex[4] ={ BUFFERSIZE-1 };    //First time it is incremented, it will be 0
unsigned int oldestIndex[4] ={ BUFFERSIZE-1 };   
int32_t Nspace =  BUFFERSIZE;

//Producer
void addDataToBuffer(float data, int row)
{       
    //Is there space?
   // int32_t Nspaces = spaceAvailable.wait();
     
     
             
    //Ok, there is space - take the lock
    bufferLock.lock();
  //  redLED = 1;       
    
    if (NInBuffer[row] < 120)
    {
    NInBuffer[row] = NInBuffer[row] +1; 
    }
    
    if (NInBuffer[row] == 120)
    {
     oldestIndex[row] = (oldestIndex[row]+1) % BUFFERSIZE;
    }
    
    
    //Update buffer
    newestIndex[row] = (newestIndex[row]+1) % BUFFERSIZE;  
    
    buffer[row][newestIndex[row]] = data;
//    printf("NInBuffer = %d", NInBuffer);
//    printf("oldestIndex= %d", oldestIndex);
    printf("\tAdded data: %5.1f to buffer \r\n", data);
    
    //Release lock
    bufferLock.unlock();
  //  redLED = 0;
    
    //Signal that a sample has been added
    samplesInBuffer.release();
}

//Consumer
float takeDataFromBuffer(int row)
{    
    if(NInBuffer[row] >0)
    {
    NInBuffer[row] = NInBuffer[row] -1;
    }
    
    //Are thre any samples in the buffer
    int32_t Nsamples = samplesInBuffer.wait();
        
    //Ok, there are samples - take the lock
    bufferLock.lock();   
 //   yellowLED = 1;
    
    //Update buffer - remove oldest
    oldestIndex[row] = (oldestIndex[row]+1) % BUFFERSIZE;
    float data = buffer[row][oldestIndex[row]];  
//    printf("NInBuffer = %d", NInBuffer);
//    printf("\t\tTaking data: %5.1f from buffer\r\n", data);
    
    //Release lock
    bufferLock.unlock();
 //   yellowLED = 0;
    
    //Signal there is space in the buffer
   // spaceAvailable.release();
    
    //return a copy of the result
    return data;
}

char readDataFromBuffer(int row)
{
 bufferLock.lock(); 
 float data = buffer[row][oldestIndex[row]];
 bufferLock.unlock();
 return data;
}