#include "mbed.h"
//#include "Terminal.h"     
#include <cmath>  
#include <vector>
#include <algorithm>
#define TI  0.001 //1kHz Sample time
#define KP  1.0f  //Proportional gain
#define KI  1.0f  //Integral gain
#define LOWER_BOUNDARY  0.0f  //Lower boundary
#define UPPER_BOUNDARY  1.0f //upper boundary
#define LOWERDC_BOUNDARY  0.0f  //Lower boundary
#define UPPERDC_BOUNDARY  0.6f //upper boundary

volatile float INTEGRAL_ERROR = 0.0;  

float errorArea;

Terminal term(USBTX, USBRX); 

AnalogIn AI_in(PTB0);
PwmOut PWM_out(PTE21);
AnalogIn Tach_in(PTB2); //0-3.3 feedback
Ticker Time_Wizard;
DigitalOut Adjustingled(LED3);

void Adjusting(){
    float feedback = Tach_in.read();
    float vref = AI_in.read();
    float err = vref - feedback;
    errorArea += err * TI;
    errorArea = min(max(LOWER_BOUNDARY, errorArea),UPPER_BOUNDARY);
    float control_out = KP*err + KI*errorArea; 
    control_out = min(max(LOWERDC_BOUNDARY, errorArea),UPPERDC_BOUNDARY);
    PWM_out.write(control_out);
    
    }

int main() {
    PWM_out.period(.005);
    Time_Wizard.attach(&Adjusting, TI);
    while(1) {
        
     term.cls();
     term.printf("\nVrefV:\r\n %f", 3.3*AI_in.read(), AI_in.read());
     term.printf("\nVrefADC/Duty: \r\n %f" ,AI_in.read() );
     term.printf("\nVrefADC/Duty: \r\n %f" ,Tach_in.read() );
      
        wait(.05);        
    }
}
