#include "mbed.h"
#include <iostream>

//state button
AnalogIn input(PTC1);

// localization sensor inputs
AnalogIn sen_left(PTB0);
AnalogIn sen_right(PTC2);
// distance sensor inputs
AnalogIn Lin(PTB2);
AnalogIn Rin(PTB1);
// pwm output to servo
PwmOut output(PTB3);

//PWM output for motors
PwmOut motorOutput(PTE21);
//break control
DigitalOut rightBreak(PTE0);
DigitalOut leftBreak(PTE1);
//motor speeds
double speed1 = .4;
double speed2 = .7;
double speed3 = 1;

// LED binary display for localization
DigitalOut led_out0(D0); // 2^0 place
DigitalOut led_out1(D1); // 2^1 place
DigitalOut led_out2(D2); // 2^2 place
DigitalOut led_out3(PTC7); // 2^3 place
// LED displays for state control
DigitalOut led_wait(LED3);
DigitalOut led_run(LED2);
DigitalOut led_stop(LED1);

// int representing state
// 0 = wait
// 1 = run
// 2 or any other value = stop
int state = 0;

// variables for steering control
const float ti = 1e-3;
const float PI = 3.1415926535;
Ticker updater;
float vL = 0;
float vR = 0;
float turn_angle = 0;
float err = 0; 
float prev_error = 0;
float del_error = 0;
int i = 0;
float sum = 0;
float sample_count = 120;
const float kp = 368; //proportional gain constant
const float kd = 2.128; //derivative gain constant
const float full_left = .059f; // duty cycle for full left turn
const float full_right = .091f; // duty cycle for full right turn
float d = full_left;

// variables for localization
Ticker locator;
const float ti_L = 1e-3;
const float threshold = 0.2;
float sen_left_val = 0;
float sen_right_val = 0;
int index = 0; // position index
int rem = 0; // remainder for conversion to binary
bool left_sensed = false;
bool right_sensed = false;
bool left_prev = false;
bool right_prev = false;

// localization function
// checks IR sensors and updates position index
void locate() {
    sen_left_val = sen_left.read();
    sen_right_val = sen_right.read();
    
    left_prev = left_sensed;
    right_prev = right_sensed;
    
    left_sensed = sen_left_val >= threshold; // true if black tape detected
    right_sensed = sen_right_val >= threshold;
    
    if (left_prev == left_sensed && right_prev == right_sensed) // skip this sample if nothing changed
        return;
    else if (left_sensed && right_sensed) // both sensors triggered
        index = 0;
    else if (left_sensed && !right_sensed || right_sensed && !left_sensed) // only one triggered
        index++;
    
    if (index == 16)
        index = 0;
    
    rem = index % 2;
    led_out0.write(rem == 1);
    rem = (index / 2) % 2;
    led_out1.write(rem == 1);
    rem = (index / 4) % 2;
    led_out2.write(rem == 1);
    rem = (index / 8) % 2;
    led_out3.write(rem == 1);
}

// steering control function
// checks distance from track and updates steering angle every 20 samples
void pwmUpdate()
{
    // updates the previous error 
    prev_error = err; 
    // reads the voltage from the distance sensor
    vL = Lin.read(); 
    vR = Rin.read();

    err = -(vL-vR); // voltage error
    del_error = (err -prev_error)/ti; // change in voltage error
    turn_angle = kp*err + kd*del_error; // calculates turn angle
    
    // saturation prevention
    if(turn_angle < 0) 
        turn_angle = 0; 
    if(turn_angle > PI) 
        turn_angle = PI;  
    
    // determines the duty cycle of the pwm output of the servo from a running average of sample_count samples
    sum += (turn_angle/PI) * (full_right - full_left) + full_left;
    if(i == sample_count -1) 
    {
        d = sum/sample_count;
        if( abs(d - output.read()) > 0.002) //only updates the duty cycle if there is a change in the duty cycle greater than 0.3%
        {
         output.write(d);
        }
        cout << "del error: " << del_error << "\r" << std::endl;
        sum = 0;
        i=0;
    }
    else {
        i++; 
    }
} 
//motor speed update code
void mtorUpdate(float N)
{
    motorOutput.period(0.00005f);  // 20 kHz control signal
    motorOutput.write(N);    //DC of the wave
}
void breakUpdate(int X){
    if(X == 1, X == 0)
    {
        rightBreak.write(X);
        leftBreak.write(X);      
    }
}
void changeState(float userState){
    if(userSate <= .2){
        //change state
    }
}
int main() {
    // Steering init
    output.period(0.02f); // 50 Hz control signal
    // attaches pwmUpdate function to the ticker with a period of 1ms
    updater.attach(&pwmUpdate,ti);
    
    // Localization init
    locator.attach(&locate,ti_L);
    led_out0.write(0);
    led_out1.write(0);
    led_out2.write(0);
    led_out3.write(0);
    
    // state init (embedded LEDs have inverted logic)
    led_wait.write(1);
    led_run.write(1);
    led_stop.write(1);
    
    while(1) {
        if (state == 0) {
            led_wait.write(0);
            led_run.write(1);
            led_stop.write(1);
            // TODO wait for user input
            wait(1);
            state=1;
        }
        else if (state == 1) {
            led_wait.write(1);
            led_run.write(0);
            led_stop.write(1);
            // TODO run as normal
            // TODO transition to stop if fault detected
            wait(2);
            state=2;
        }
        else {
            led_wait.write(1);
            led_run.write(1);
            led_stop.write(0);
            // TODO stop motor
            // TODO activate brakes
            // TODO turn right
            // TODO print detected fault
            wait(3);
            state=0;
        }
    }
}
