// open-loop control of the servo motor
// reads analog input and converts it to a pwm signal
 
#include "mbed.h"
#include <iostream>
 
AnalogIn input(PTB0);
PwmOut output(PTE21);
Ticker updater;

float v = 0.0;
float d = 0.0;
float prevArea = 0.0;
float area = 0.0:
float feedback = 0.0;

float KP =-0.0058;
float KI =1.0223;
float TI = .001f;
int sat = 99999;
void pwmUpdate()
{
    v = input.read();
    d = v; // sets DC to voltage
    if( abs(d - output.read()) > 0.001) //only updates the duty cycle if there is a change in the duty cycle greater than 0.3%
         output.write(d);
}
void piUpdate(){
    feedback = input.read();//inputs frequency of motor
    area= TI*feedback + prevArea; //PI integration
    d = KP*error(i)+ KI*errorArea(i); //PI integration
    output.write(d); //changing speed from PI
    prevArea = area; //storing value
}
void realUpdate(float x){
    feedback = input.read();
    area= TI*feedback + prevArea;
    d = KP*error(i)+ KI*errorArea(i);
    output.write(x-d);
    prevArea = area; 
}
void step(){
 for(float s = 0; s < SAT; s+= TI){
     v = (-1.277e-18*s^4 - 1.61e-14*s^3 + 2.789e-12*s^2 + 1.23e-11*s)/(5.759e-21*s^6 + 1.472e-16*s^5 + 9.414e-13*s^4 + 8.078e-12*s^3 + 2.02e-11*s^2 + 1.23e-11*s)//TF from gclose
     realUpdate(val);
     }     
}
int main(void)
{
    output.period(0.00005f); // 20 kHz control signal
    // attaches pwmUpdate function to the ticker with a period of 20ms
    //updater.attach(&pwmUpdate,0.00005f);
    updater.attach(&piUpdate,TI);
    std::cout << "AnalogIn: " << v << " Duty Cycle: " << d << std::endl;
    while(1) {} // do nothing
}