
class Kalman{
    public:
        void statePriori();
        void statePostPriori();
        void kCompute(float observation, float variance, float angle);
    
    private:
        float mean;
        float covariance;
        float dt;
        float PredictionVariance;
};

float[2] Kalman::statePriori(float speed, float angle){
    float returns[2];
    returns[1] = this->mean + this->dt*speed*sin(angle);
    returns[2] = this->covariance * pow(this->dt*speed*cos(angle),2) + PredictionVariance;
    return returns;
}

void Kalman::statePostPriori(float observation, float measVariance, float angle, float covariance_hat, float mean_hat){
    float h = observation*cos(angle);
    float s = 1/(pow(h,2)*covariance_hat + measVariance);
    float k = covariance_hat*h*s;
    float z = observation*sin(angle);
    this->mean = mean_hat+k*(z-h*mean_hat);
    this->covariance = (1-k*h)*covariance_hat;
}

float Kalman::kCompute(float speed, float turnAngle, float observation[2], float variance[2], float angle[2]){
   float[2] predictions = statePriori(speed, turnAngle);
   statePostPriori(observation[0], variance[0], angle[0], predictions[1], predictions[0]);
   statePostPriori(observation[0], variance[0], angle[0], this->covariance, this->mean);
   return this->mean;
}
   
   

