#include "mbed.h"
#include <iostream>

#define TI 0.001f
//#define KPS 0.0896852742245504f
#define KPS 0.12f
#define KD 0.072870569295611f
#define SET 0.0f
#define MINS 0.065f
#define MAXS 0.085f
#define BIAS 0.075f
#define TOL 0.002f
#define STEER_FREQ 0.02f //50 Hz

AnalogIn RSensor(PTB1); //Right sensor
AnalogIn LSensor(PTB2); //Left sensor
PwmOut servoSig(PTD0); //PWM output to control servo
Ticker timer;
DigitalOut myled(LED_BLUE);
float fbPrev = 0.0f;
Serial bt(PTE0, PTE1); //COM12

void steer()
{
    float fb = LSensor.read()-RSensor.read();
    
    float e = SET - fb;
    float Controlleroutput = KPS * e - KD * (fb - fbPrev)/TI + BIAS;//subtract derivative of error??
    if (Controlleroutput > MAXS) Controlleroutput = MAXS;
    else if (Controlleroutput < MINS) Controlleroutput = MINS;
    if (abs(Controlleroutput - servoSig.read()) > TOL) servoSig.write(Controlleroutput);
    //printf("Controlleroutput, %f\r\n", Controlleroutput);
    fbPrev = fb;
}

int main()
{
    servoSig.period(STEER_FREQ);
    timer.attach(&steer, TI);
    bt.baud(115200);
    while(1) {
        myled = !myled;
        //bt.printf("%f\r\n",fbPrev);
    }
}