#include "mbed.h"
#include <iostream>

#define SCALAR 0.6f
#define TACH PTB1
#define SPEED_CONTROL PTD5
#define BRAKE PTA13

#define TI 0.001f
#define MINM 0.0f
#define MAXM 1.0f
#define KPM 0.1414f
#define KI 19.7408f

Ticker sample;
AnalogIn speed(TACH);
PwmOut gateDrive(SPEED_CONTROL);
//DigitalOut brake(BRAKE);
DigitalOut myLed(LED_GREEN);

float Setpoint = 0.0;
float errSum = 0.0;

//Serial pc(USBTX, USBRX);
Serial bt(PTE0, PTE1); //COM12

void serCb()
{
    char x = bt.getc();
    if (x == 'u')
    {
        Setpoint = Setpoint + 0.05;
    }
    else if(x == 'h')
    {
        Setpoint = Setpoint - 0.05;
    }
    else
    {
        bt.putc(x);
    } 
}

void compute_PI()
{
    float error = Setpoint-speed.read();
    errSum +=(error * TI);
    float iTerm = KI*errSum;
    if(iTerm > MAXM) iTerm = MAXM;
    if(iTerm < MINM) iTerm = MINM; 
    float output = KPM*error + iTerm;
    if(output > MAXM) output = MAXM;
    if(output < MINM) output = MINM;    
    if(output < MINM) 
    {
        gateDrive.write(MINM);
        //brake.write(1);
    }
    else 
    {
        //brake.write(0);
        gateDrive.write(output);
    }
    //data[1] = output;           
}

int main()
{ 
    sample.attach(&compute_PI, TI);
    
    myLed = 0;
    bt.baud(115200);
    bt.printf("Press 'u' to speed up and 'h' to slow down%\r\n");
    
    bt.attach(&serCb);
    while(true)
    {}  
}