#include "utils.h"
#include "mbed.h"

//System IO    global currently, might put this in a namespace
AnalogIn speed(TACH);
AnalogIn RSensor(STEER_RIGHT);
AnalogIn LSensor(STEER_LEFT);

PwmOut gateDrive(SPEED_CONTROL);
PwmOut servoSig(SERVO);

DigitalOut brake(BRAKE);

//Car
float Car::filter_input(AnalogIn input, int filterLength)
{  
    float* samples = new float[filterLength]; 
     
   for(int i = filterLength -1; i > 0; i--)
   {
      samples[i] = samples[i-1]; 
   }
   samples[0] = input.read();
   float sum = 0.0;
   for(int j = 0; j < filterLength; j++)
   {
       sum += samples[j];
   }
   delete[] samples;
   return sum/filterLength;   
}

float Car::increment_with_bound(float val, float upper, float increment)
{
    val += increment;
    if (val > upper)
    {
        return upper;
    }
    else
    {
        return val;
    }
}

float Car::decrement_with_bound(float val, float lower, float decrement)
{
    val -= decrement;
    if (val < lower)
    {
        return lower;
    }
    else
    {
        return val;
    }
}
//endCar

//PI
float Control::motor_setpoint;
float Control::errSum;

//PD
float Control::steerValue = 0.0;
float Control::dutyCycle = 0.0;
float Control::distanc = 0.0;
float Control::ep = 0.0;
float Control::derivative = 0.0;
float Control::Controlleroutput = 0.0;
float Control::prevOutput = 0.0;

Ticker Control::sample;

void Control::compute_PI()
{
    //proportional
    float error = motor_setpoint-speed.read();;
    
    //integral
    errSum +=(error *TI);//potentially the problem
    float ITerm = KI*errSum;
    if(ITerm > MAXm) ITerm = MAXm;
    if(ITerm < MINm) ITerm = MINm; 
    
    //compute output
    float motor_output = KPm*error + ITerm;
    if(motor_output > MAXm) motor_output = MAXm;
    if(motor_output <= MINm) motor_output = MINm;
    if(motor_output == MINm)
    {
        //activate brake
        brake.write(1);
        gateDrive.write(MINm);
    }
    else
    {
        //turn off brake
        brake.write(0);
        gateDrive.write(SCALAR*motor_output);   
    }       
}

void Control::compute_PD()
{         
    //distanc = LSensor.read() - RSensor.read();                                  //Determine distance from center
    //float e = SET - distanc;                                                    //Calculate error from center
    float e = SET - (LSensor.read() - RSensor.read());
    //derivative = (e - ep)/TI;                                                   //Calculate Derivative Term
//    Controlleroutput = KPS * e + KD * derivative + BIAS;                        //Determine Controller output
    float Controlleroutput = KPS * e + KD * derivative + BIAS;
    if (Controlleroutput > MAXs) Controlleroutput = MAXs;                       //Check for upperlimit saturation
    else if (Controlleroutput < MINs) Controlleroutput = MINs;                  //Check for lower limit saturation
    if (abs(Controlleroutput - prevOutput) < TOL) Controlleroutput = prevOutput;
    prevOutput = Controlleroutput;
    ep = e;                                                                     //Update previous error
//    servoSig=(Controlleroutput);                                                //Update PWM output
    servoSig.write(Controlleroutput);
}

void Control::run()
{
    motor_setpoint = 0.0;
    errSum = 0.0;
    sample.attach(&control_cb, TI);
}

/*void Control::stop()
{
    sample.detach();
    //dont do this
}*/

void Control::control_cb()
{
    compute_PI();
    compute_PD();
}
//endControl

//Data
Serial Data::bt(BT_TX, BT_RX);

void Data::serial_cb()
{
    char x = bt.getc();
    if (x == 'u')
    {
        Control::motor_setpoint = Car::increment_with_bound(Control::motor_setpoint,1.0, 0.05);
    }
    else if(x == 'h')
    {
        Control::motor_setpoint = Car::decrement_with_bound(Control::motor_setpoint,0.0, 0.05);
    }  
}

void Data::start_bt()
{
    bt.baud(BAUD_RATE);
    bt.attach(&serial_cb);
}
//endData
    