
#include "mbed.h"
#include "TextLCD.h"
#include "PS_PAD.h"
#include "Motor.h"
#include "encoderKRAI.h"

#include <string>
using namespace std;

Thread thread2(osPriorityNormal, OS_STACK_SIZE, NULL);
Thread thread1(osPriorityNormal, OS_STACK_SIZE, NULL);
Thread thread3(osPriorityNormal, OS_STACK_SIZE, NULL);

TextLCD lcd(PA_9, PC_3, PC_2, PA_8, PB_0, PC_15, TextLCD::LCD20x4); //rs,e,d4-d7
encoderKRAI enc1 (PC_14, PC_13, 11, encoderKRAI::X4_ENCODING);
encoderKRAI enc2 (PC_0, PC_1, 11, encoderKRAI::X4_ENCODING);
encoderKRAI enc3 (PB_10, PB_3, 11, encoderKRAI::X4_ENCODING);
PS_PAD ps2(PB_15,PB_14,PB_13, PC_4); //(mosi, miso, sck, ss)

    Motor motor3(PB_7, PA_14, PA_15); //motor4
    Motor motor2(PA_11, PA_6, PA_5); //motor2
    //Motor motor1(PA_10, PB_5, PB_4);  //motor_griper
    Motor motor1(PB_6, PA_7, PB_12); //motor 3
string a;
    
void dataJoystick();
void lcdPrint();
void motorP();

Serial pc(USBTX,USBRX);

int main()
{    
    pc.baud(115200);
    ps2.init();
    thread1.start(dataJoystick);
    thread2.start(lcdPrint);
    thread3.start(motorP);
    while (1)
    {      
        // baca input
/*      
        ps2.poll();
        if(ps2.read(PS_PAD::PAD_X)==1)                   a = "silang";
        else if(ps2.read(PS_PAD::PAD_CIRCLE)==1)         a = "lingkaran";
        else if(ps2.read(PS_PAD::PAD_TRIANGLE)==1)       a = "segitiga";
        else if(ps2.read(PS_PAD::PAD_SQUARE)==1)         a = "kotak";
        else                                             a = "NULL";
 */   
/*        
        //tampilkan LCD
        lcd.locate(0,0);
        lcd.printf("input joystik :");
        lcd.locate(0,1);
        lcd.printf("%s",a); 
    
        wait_ms(10);
        lcd.cls();
*/
    }
}

void dataJoystick(){
    while(true){
    ps2.poll();
    if(ps2.read(PS_PAD::PAD_X)==1)                   a =  "silang";
    else if(ps2.read(PS_PAD::PAD_CIRCLE)==1)         a = "lingkaran";
    else if(ps2.read(PS_PAD::PAD_TRIANGLE)==1)       a = "segitiga";
    else if(ps2.read(PS_PAD::PAD_SQUARE)==1)         a = "kotak";
    else                                             a = "NULL";    
    }
}

void lcdPrint(){
    while (true){
    lcd.cls(); 
    int pulse1 = enc1.getPulses();
    int pulse2 = enc2.getPulses();
    int pulse3 = enc3.getPulses();
    lcd.locate(0,0);
    lcd.printf("input : %s", a);
    lcd.locate(0,1);
    lcd.printf("enc1 = %d", pulse1);
    lcd.locate(0,2);
    lcd.printf("enc2 = %d", pulse2);
    lcd.locate(0,3);
    lcd.printf("enc3 = %d", pulse3);
    Thread::wait(20);
    }
}

void motorP() {
        while(true){
            motor1.speed(0.5);
            motor2.speed(0.5);
            motor3.speed(0.5);
            Thread::wait(2000);
            motor1.speed(-0.5);
            motor2.speed(-0.5);
            motor3.speed(-0.5);
            Thread::wait(2000);
        }  
}      